/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import com.centit.support.security.AESSecurityUtils;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecurityOptUtils {
    protected static final Logger logger = LoggerFactory.getLogger(SecurityOptUtils.class);

    public static String decodeSecurityString(String sStr) {
        if (sStr == null) {
            return "";
        }
        if ((sStr = sStr.trim()).startsWith("encode:")) {
            return new String(Base64.decodeBase64((String)sStr.substring(7))).trim();
        }
        if (sStr.startsWith("cipher:")) {
            return AESSecurityUtils.decryptBase64String(sStr.substring(7), "0123456789abcdefghijklmnopqrstuvwxyzABCDEF");
        }
        if (sStr.startsWith("aescbc:")) {
            return AESSecurityUtils.decryptAsCBCType(sStr.substring(7), "U2FsdGVkX1BymlPj", "WUG1TpTpkinX9pNs");
        }
        return sStr;
    }

    public static String encodeSecurityString(String sStr, String encType) {
        if (sStr == null) {
            return "";
        }
        switch (encType) {
            case "cipher": {
                return "cipher:" + AESSecurityUtils.encryptAndBase64(sStr, "0123456789abcdefghijklmnopqrstuvwxyzABCDEF");
            }
            case "base64": {
                return "encode:" + Base64.encodeBase64String((byte[])sStr.getBytes(StandardCharsets.UTF_8));
            }
            case "aescbc": {
                return "aescbc:" + AESSecurityUtils.encryptAsCBCType(sStr, "U2FsdGVkX1BymlPj", "WUG1TpTpkinX9pNs");
            }
        }
        return sStr;
    }
}

