/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import com.alibaba.fastjson.JSON;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;

public abstract class RSASecurityUtils {
    private static final String ALGORITHM = "RSA";
    private static final int KEYSIZE = 1024;

    private RSASecurityUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        return RSASecurityUtils.generateKeyPair(1024);
    }

    public static KeyPair generateKeyPair(int keysize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
        keyPairGenerator.initialize(keysize);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public static String encrypt(String source, Key key) throws BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        RSASecurityUtils.generateKeyPair();
        Key publicKey = key;
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, publicKey);
        byte[] b = source.getBytes();
        byte[] b1 = cipher.doFinal(b);
        return Base64.encodeBase64String((byte[])b1);
    }

    public static String decrypt(String cryptograph, Key key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Key privateKey = key;
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, privateKey);
        byte[] b1 = Base64.decodeBase64((String)cryptograph);
        byte[] b = cipher.doFinal(b1);
        return new String(b);
    }

    public static String keyPairToJson(KeyPair keyPair) {
        HashMap<String, String> keyJson = new HashMap<String, String>();
        keyJson.put("private", Base64.encodeBase64String((byte[])keyPair.getPrivate().getEncoded()));
        keyJson.put("public", Base64.encodeBase64String((byte[])keyPair.getPublic().getEncoded()));
        return JSON.toJSONString(keyJson);
    }
}

