/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.json;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.json.DefaultJSONTransformDataSupport;
import com.centit.support.json.JSONTransformDataSupport;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONTransformer {
    protected static final Logger logger = LoggerFactory.getLogger(JSONTransformer.class);

    public static Object transformer(Object templateObj, JSONTransformDataSupport dataSupport) {
        if (templateObj instanceof String) {
            String value = (String)templateObj;
            if (value.startsWith("@")) {
                return value.substring(1);
            }
            return dataSupport.attainExpressionValue(value);
        }
        if (templateObj instanceof Map) {
            Map<String, Object> tempMap = CollectionsOpt.objectToMap(templateObj);
            JSONObject jobj = new JSONObject();
            for (Map.Entry<String, Object> ent : tempMap.entrySet()) {
                String skey = ent.getKey();
                if (skey.startsWith("@")) {
                    Object value = JSONTransformer.transformer(ent.getValue(), dataSupport);
                    if (value instanceof Map) {
                        jobj.putAll(CollectionsOpt.objectToMap(value));
                        continue;
                    }
                    jobj.put(skey.substring(1), value);
                    continue;
                }
                if (skey.startsWith("#")) {
                    Object obj = dataSupport.attainExpressionValue(skey.substring(1));
                    if (!(obj instanceof Collection)) {
                        logger.warn(skey.substring(1) + "\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u662f\u6570\u7ec4");
                    }
                    JSONArray array = new JSONArray();
                    List<Object> loopData = CollectionsOpt.objectToList(obj);
                    for (Object ld : loopData) {
                        dataSupport.pushStackValue(ld);
                        if (StringBaseOpt.isNvl(String.valueOf(ent.getValue()))) {
                            array.add(ld);
                        } else {
                            array.add(JSONTransformer.transformer(ent.getValue(), dataSupport));
                        }
                        dataSupport.popStackValue();
                    }
                    return array;
                }
                jobj.put(skey, JSONTransformer.transformer(ent.getValue(), dataSupport));
            }
            return jobj;
        }
        if (templateObj instanceof Collection) {
            JSONArray array = new JSONArray();
            Collection valueList = (Collection)templateObj;
            for (Object ov : valueList) {
                if (ov == null) continue;
                array.add(JSONTransformer.transformer(ov, dataSupport));
            }
            return array;
        }
        Class<?> clazz = templateObj.getClass();
        if (clazz.isArray()) {
            JSONArray array = new JSONArray();
            int len = Array.getLength(templateObj);
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    array.add(JSONTransformer.transformer(Array.get(templateObj, i), dataSupport));
                }
            }
            return array;
        }
        return templateObj;
    }

    public static Object transformer(Object templateObj, Object dataSupport) {
        return JSONTransformer.transformer(templateObj, new DefaultJSONTransformDataSupport(dataSupport));
    }
}

