/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.file;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class IniReader {
    protected Map<String, Map<String, String>> sections = new HashMap<String, Map<String, String>>();
    private transient String currentSecion = null;
    private transient Map<String, String> current = null;

    private IniReader() {
        throw new IllegalAccessError("Utility class");
    }

    public IniReader(String filename) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "GBK"));){
            this.read(reader);
        }
    }

    protected void read(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            this.parseLine(line);
        }
    }

    protected void parseLine(String line) {
        if ((line = line.trim()).startsWith("[") && line.endsWith("]")) {
            if (this.current != null && this.currentSecion != null) {
                this.sections.put(this.currentSecion, this.current);
            }
            this.currentSecion = line.substring(1, line.length() - 1);
            this.current = this.sections.get(this.currentSecion);
            if (this.current == null) {
                this.current = new HashMap<String, String>();
            }
        } else if (this.current != null && this.currentSecion != null && !line.startsWith(";") && line.indexOf(61) >= 0) {
            int i = line.indexOf(61);
            String name = line.substring(0, i).trim();
            String value = line.substring(i + 1).trim();
            this.current.put(name, value);
            this.sections.put(this.currentSecion, this.current);
        }
    }

    public String getValue(String section, String name) {
        Map<String, String> p = this.sections.get(section);
        if (p == null) {
            return null;
        }
        String value = p.get(name);
        return value;
    }
}

