/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.file;

import com.centit.support.security.AESSecurityUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;

public abstract class FileEncryptWithAes {
    private FileEncryptWithAes() {
        throw new IllegalAccessError("Utility class");
    }

    public static void encrypt(String sourceFileName, String diminationFileName, String keyValue) throws IOException, GeneralSecurityException {
        FileEncryptWithAes.encrypt(new File(sourceFileName), new File(diminationFileName), keyValue);
    }

    public static void encrypt(InputStream sourceFile, OutputStream diminationFile, String keyValue) throws IOException, GeneralSecurityException {
        try (CipherInputStream cis = new CipherInputStream(sourceFile, AESSecurityUtils.createEncryptCipher(keyValue));){
            int r;
            byte[] buffer = new byte[1024];
            while ((r = cis.read(buffer)) > 0) {
                diminationFile.write(buffer, 0, r);
            }
        }
    }

    public static void encrypt(File sourceFile, File diminationFile, String keyValue) throws IOException, GeneralSecurityException {
        try (FileInputStream is = new FileInputStream(sourceFile);
             FileOutputStream out = new FileOutputStream(diminationFile);){
            FileEncryptWithAes.encrypt(is, out, keyValue);
        }
    }

    public static void decrypt(String sourceFileName, String diminationFileName, String keyValue) throws IOException, GeneralSecurityException {
        FileEncryptWithAes.decrypt(new File(sourceFileName), new File(diminationFileName), keyValue);
    }

    public static void decrypt(InputStream sourceFile, OutputStream diminationFile, String keyValue) throws IOException, GeneralSecurityException {
        try (CipherOutputStream cos = new CipherOutputStream(diminationFile, AESSecurityUtils.createDencryptCipher(keyValue));){
            int r;
            byte[] buffer = new byte[1024];
            while ((r = sourceFile.read(buffer)) >= 0) {
                cos.write(buffer, 0, r);
            }
        }
    }

    public static void decrypt(File sourceFile, File diminationFile, String keyValue) throws IOException, GeneralSecurityException {
        try (FileInputStream is = new FileInputStream(sourceFile);
             FileOutputStream out = new FileOutputStream(diminationFile);){
            FileEncryptWithAes.decrypt(is, out, keyValue);
        }
    }
}

