/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ListAppendMap<T> {
    private List<T> listData;
    private Map<String, T> appendMap;

    public ListAppendMap(List<T> listData, Function<T, String> func) {
        if (listData != null) {
            this.listData = listData;
            this.appendMap = new HashMap<String, T>(listData.size());
            for (T d : listData) {
                this.appendMap.put(func.apply(d), d);
            }
        } else {
            this.listData = Collections.emptyList();
            this.appendMap = Collections.emptyMap();
        }
    }

    public List<T> getListData() {
        return this.listData;
    }

    public Map<String, T> getAppendMap() {
        return this.appendMap;
    }
}

