/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.ByteBaseOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.EnumBaseOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaBeanField {
    private static final Logger logger = LoggerFactory.getLogger(JavaBeanField.class);
    private String fieldJavaType;
    private Class<?> fieldType;
    private Method setFieldValueFunc;
    private Method getFieldValueFunc;
    private Field objectField;

    public JavaBeanField() {
    }

    public JavaBeanField(Field objectField) {
        this.setObjectField(objectField);
    }

    public Method getSetFieldValueFunc() {
        return this.setFieldValueFunc;
    }

    public void setSetFieldValueFunc(Method setFieldValueFunc) {
        this.setFieldValueFunc = setFieldValueFunc;
    }

    public Method getGetFieldValueFunc() {
        return this.getFieldValueFunc;
    }

    public void setGetFieldValueFunc(Method getFieldValueFunc) {
        this.getFieldValueFunc = getFieldValueFunc;
    }

    public Field getObjectField() {
        return this.objectField;
    }

    public void setObjectField(Field objectField) {
        this.objectField = objectField;
        this.setFieldType(objectField.getType());
    }

    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(Class<?> fieldType) {
        this.fieldType = fieldType;
        this.fieldJavaType = ReflectionOpt.getJavaTypeName(fieldType);
    }

    public String getFieldJavaTypeShortName() {
        return this.fieldJavaType;
    }

    public boolean isAssignableFrom(Class<?> valueType) {
        return this.fieldType.isAssignableFrom(valueType);
    }

    private void innerSetObjectFieldValue(Object obj, Object fieldValue) {
        try {
            if (this.setFieldValueFunc != null) {
                this.setFieldValueFunc.invoke(obj, fieldValue);
            } else if (this.objectField != null) {
                boolean accessible = this.objectField.isAccessible();
                if (!accessible) {
                    this.objectField.setAccessible(true);
                }
                this.objectField.set(obj, fieldValue);
                if (!accessible) {
                    this.objectField.setAccessible(false);
                }
            } else {
                logger.error(Object.class.getName() + "\u6ca1\u6709\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setObjectFieldValue(Object object, Object newValue) {
        if (newValue == null) {
            if (this.fieldType != null && this.fieldType.isPrimitive() || StringUtils.equalsAny((CharSequence)this.fieldJavaType, (CharSequence[])new CharSequence[]{"int", "long", "float", "double"})) {
                return;
            }
            this.innerSetObjectFieldValue(object, null);
            return;
        }
        if (this.fieldType.isAssignableFrom(newValue.getClass())) {
            this.innerSetObjectFieldValue(object, newValue);
            return;
        }
        if (this.fieldType.isEnum()) {
            if (NumberBaseOpt.castObjectToInteger(newValue) != null) {
                this.innerSetObjectFieldValue(object, EnumBaseOpt.ordinalToEnum(this.fieldType, NumberBaseOpt.castObjectToInteger(newValue)));
            }
            return;
        }
        switch (this.fieldJavaType) {
            case "int": 
            case "Integer": {
                this.innerSetObjectFieldValue(object, NumberBaseOpt.castObjectToInteger(newValue));
                break;
            }
            case "long": 
            case "Long": {
                this.innerSetObjectFieldValue(object, NumberBaseOpt.castObjectToLong(newValue));
                break;
            }
            case "float": 
            case "double": 
            case "Float": 
            case "Double": {
                this.innerSetObjectFieldValue(object, NumberBaseOpt.castObjectToDouble(newValue));
                break;
            }
            case "byte[]": {
                this.innerSetObjectFieldValue(object, ByteBaseOpt.castObjectToBytes(newValue));
                break;
            }
            case "BigDecimal": {
                this.innerSetObjectFieldValue(object, NumberBaseOpt.castObjectToBigDecimal(newValue));
                break;
            }
            case "BigInteger": {
                this.innerSetObjectFieldValue(object, NumberBaseOpt.castObjectToBigInteger(newValue));
                break;
            }
            case "String": {
                this.innerSetObjectFieldValue(object, StringBaseOpt.objectToString(newValue));
                break;
            }
            case "Date": {
                this.innerSetObjectFieldValue(object, DatetimeOpt.castObjectToDate(newValue));
                break;
            }
            case "sqlDate": {
                this.innerSetObjectFieldValue(object, DatetimeOpt.castObjectToSqlDate(newValue));
                break;
            }
            case "sqlTimestamp": {
                this.innerSetObjectFieldValue(object, DatetimeOpt.castObjectToSqlTimestamp(newValue));
                break;
            }
            case "boolean": 
            case "Boolean": {
                this.innerSetObjectFieldValue(object, BooleanBaseOpt.castObjectToBoolean(newValue, false));
                break;
            }
            default: {
                this.innerSetObjectFieldValue(object, JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)StringBaseOpt.castObjectToString(newValue)), this.fieldType));
            }
        }
    }

    public Object getObjectFieldValue(Object obj) {
        try {
            if (this.getFieldValueFunc != null) {
                return this.getFieldValueFunc.invoke(obj, new Object[0]);
            }
            if (this.objectField != null) {
                boolean accessible = this.objectField.isAccessible();
                if (!accessible) {
                    this.objectField.setAccessible(true);
                }
                Object result = this.objectField.get(obj);
                if (!accessible) {
                    this.objectField.setAccessible(accessible);
                }
                return result;
            }
            logger.error(Object.class.getName() + "\u6ca1\u6709\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
            return null;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

