/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.common.ICachedObject;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractCachedObject<T>
implements ICachedObject<T> {
    protected T target;
    boolean evicted;
    Date refreshTime;
    private Set<ICachedObject<?>> deriveCaches;

    boolean isTargetOutOfDate(long freshPeriod) {
        return this.evicted || System.currentTimeMillis() > this.refreshTime.getTime() + freshPeriod * 1000L;
    }

    void evictDerivativeCahce() {
        if (this.deriveCaches != null) {
            for (ICachedObject<?> eriveCache : this.deriveCaches) {
                eriveCache.evictCahce();
            }
        }
    }

    void setRefreshDataAndState(T tempTarget, long freshPeriod, boolean delayIfNull) {
        if (tempTarget != null) {
            this.target = CollectionsOpt.unmodifiableObject(tempTarget);
            this.refreshTime = DatetimeOpt.currentUtilDate();
            this.evicted = false;
        } else if (this.target != null && delayIfNull) {
            this.refreshTime = new Date(System.currentTimeMillis() - freshPeriod * 1000L + (freshPeriod / 2L > 5L ? 5L : freshPeriod / 2L) * 1000L);
            this.evicted = false;
        }
    }

    @Override
    public void evictCahce() {
        this.evicted = true;
        this.evictDerivativeCahce();
    }

    public void addDeriveCache(ICachedObject<?> eriveCache) {
        if (eriveCache == null) {
            return;
        }
        if (this.deriveCaches == null) {
            this.deriveCaches = new HashSet(6);
        }
        this.deriveCaches.add(eriveCache);
    }

    public abstract T getCachedTarget();
}

