/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.quartz;

import com.alibaba.fastjson2.JSON;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuartzJob
implements Job {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractQuartzJob.class);

    protected abstract boolean runRealJob(JobExecutionContext var1) throws JobExecutionException;

    protected abstract void loadExecutionContext(JobExecutionContext var1);

    protected void beforeRun(JobExecutionContext context) {
        JobKey jobKey = context.getJobDetail().getKey();
        logger.debug("beforeRun \uff1a" + jobKey.getGroup() + ":" + jobKey.getName());
    }

    protected void onSuccess(JobExecutionContext context) {
        JobKey jobKey = context.getJobDetail().getKey();
        logger.debug("onSuccess \uff1a" + jobKey.getGroup() + ":" + jobKey.getName());
    }

    protected void onError(JobExecutionContext context) {
        JobKey jobKey = context.getJobDetail().getKey();
        logger.error("onError \uff1a" + jobKey.getGroup() + ":" + jobKey.getName() + "\r\n\t" + JSON.toJSONString((Object)context.getMergedJobDataMap()));
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.loadExecutionContext(context);
        this.beforeRun(context);
        boolean success = this.runRealJob(context);
        if (success) {
            this.onSuccess(context);
        } else {
            this.onError(context);
        }
    }
}

