/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.centit.support.algorithm.ReflectionOpt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

@Deprecated
public class ExportExcelUtil {
    private HSSFWorkbook wb = null;
    private HSSFSheet sheet = null;

    public static InputStream generateExcel(List<? extends Object> objLists) {
        return ExportExcelUtil.generateExcel(objLists, null, null);
    }

    public static InputStream generateExcel(List<? extends Object> objLists, String[] header, String[] property) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HSSFSheet sheet = ExportExcelUtil.createDefaultSheet();
        if (header != null && header.length > 0) {
            ExportExcelUtil.generateHeader(sheet, header);
        }
        try {
            if (property != null && property.length > 0) {
                ExportExcelUtil.generateText(sheet, objLists, property);
            } else {
                ExportExcelUtil.generateObjText(sheet, objLists);
            }
            sheet.getWorkbook().write((OutputStream)baos);
        }
        catch (IOException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static InputStream generateExcel(List<Object[]> objLists, String[] header) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HSSFSheet sheet = ExportExcelUtil.createDefaultSheet();
        ExportExcelUtil.generateHeader(sheet, header);
        ExportExcelUtil.generateText(sheet, objLists);
        try {
            sheet.getWorkbook().write((OutputStream)baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private static HSSFSheet createDefaultSheet() {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        return new ExportExcelUtil(wb, sheet).getSheet();
    }

    private static void generateHeader(HSSFSheet sheet, String[] header) {
        HSSFRow headerRow = sheet.createRow(0);
        for (int i = 0; i < header.length; ++i) {
            HSSFCell cell = headerRow.createCell(i);
            ExportExcelUtil.setCellStyle(sheet.getWorkbook(), cell);
            cell.setCellValue(header[i]);
        }
    }

    private static void generateText(HSSFSheet sheet, List<? extends Object> objLists, String[] property) throws NoSuchFieldException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        for (int i = 0; i < objLists.size(); ++i) {
            HSSFRow textRow = sheet.createRow(i + 1);
            for (int j = 0; j < property.length; ++j) {
                Object val;
                HSSFCell cell = textRow.createCell(j);
                ExportExcelUtil.setCellStyle(sheet.getWorkbook(), cell);
                if (objLists.get(i) instanceof Map) {
                    Object val2 = ((Map)objLists.get(i)).get(property[j]);
                    cell.setCellValue(null == val2 ? "" : val2.toString());
                    continue;
                }
                Method method = ReflectionOpt.getGetterMethod(objLists.get(i).getClass(), (String)property[j]);
                if (method == null) {
                    method = ReflectionOpt.getBooleanGetterMethod(objLists.get(i).getClass(), (String)property[j]);
                }
                cell.setCellValue(null == (val = method.invoke(objLists.get(i), new Object[0])) ? "" : val.toString());
            }
        }
    }

    private static void generateObjText(HSSFSheet sheet, List<? extends Object> objLists) throws InvocationTargetException, IllegalAccessException {
        for (int i = 0; i < objLists.size(); ++i) {
            HSSFRow textRow = sheet.createRow(i);
            List getMethods = ReflectionOpt.getAllGetterMethod(objLists.get(i).getClass());
            int errorLen = 0;
            for (int j = 0; j < getMethods.size(); ++j) {
                HSSFCell cell = textRow.createCell(j - errorLen);
                ExportExcelUtil.setCellStyle(sheet.getWorkbook(), cell);
                Object val = ((Method)getMethods.get(j)).invoke(objLists.get(i), new Object[0]);
                cell.setCellValue(null == val ? "" : val.toString());
            }
        }
    }

    private static void generateText(HSSFSheet sheet, List<Object[]> objLists) {
        for (int i = 0; i < objLists.size(); ++i) {
            HSSFRow textRow = sheet.createRow(i + 1);
            for (int j = 0; j < objLists.get(i).length; ++j) {
                HSSFCell cell = textRow.createCell(j);
                ExportExcelUtil.setCellStyle(sheet.getWorkbook(), cell);
                cell.setCellValue(null == objLists.get(i)[j] ? "" : objLists.get(i)[j].toString());
            }
        }
    }

    private static void setCellStyle(HSSFWorkbook wb, HSSFCell cell) {
        cell.setCellType(CellType.STRING);
        cell.setCellStyle(ExportExcelUtil.getDefaultCellStyle(wb));
    }

    private static HSSFCellStyle getDefaultCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont font = wb.createFont();
        font.setFontName("\u5b8b\u4f53");
        cellStyle.setFont(font);
        return cellStyle;
    }

    private ExportExcelUtil(HSSFWorkbook wb, HSSFSheet sheet) {
        this.wb = wb;
        this.sheet = sheet;
    }

    public HSSFSheet getSheet() {
        return this.sheet;
    }

    public void setSheet(HSSFSheet sheet) {
        this.sheet = sheet;
    }

    public HSSFWorkbook getWb() {
        return this.wb;
    }

    public void setWb(HSSFWorkbook wb) {
        this.wb = wb;
    }
}

