/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office.commons;

import com.centit.support.file.FileIOOpt;
import com.centit.support.office.OfficeToPdf;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextRun;
import org.apache.poi.hslf.usermodel.HSLFTextShape;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextRun;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerPointUtils {
    private static final Logger logger = LoggerFactory.getLogger(OfficeToPdf.class);
    private static PDRectangle mediaBox = PDRectangle.LETTER;
    private static boolean landscape = false;
    private static boolean autoOrientation = true;
    private static boolean resize = true;

    private static void createPDFFromImages(List<ByteArrayOutputStream> imageFilenames, String targetFilePath) throws IOException {
        PDDocument doc = new PDDocument();
        for (ByteArrayOutputStream imageFileName : imageFilenames) {
            PDImageXObject pdImage = PDImageXObject.createFromByteArray((PDDocument)doc, (byte[])imageFileName.toByteArray(), (String)"");
            PDRectangle actualMediaBox = mediaBox;
            if (autoOrientation && pdImage.getWidth() > pdImage.getHeight() || landscape) {
                actualMediaBox = new PDRectangle(mediaBox.getHeight(), mediaBox.getWidth());
            }
            PDPage page = new PDPage(actualMediaBox);
            doc.addPage(page);
            PDPageContentStream contents = new PDPageContentStream(doc, page);
            if (resize) {
                contents.drawImage(pdImage, 0.0f, 0.0f, actualMediaBox.getWidth(), actualMediaBox.getHeight());
            } else {
                contents.drawImage(pdImage, 0.0f, 0.0f, (float)pdImage.getWidth(), (float)pdImage.getHeight());
            }
            contents.close();
        }
        doc.save(targetFilePath);
        doc.close();
    }

    private static void createHTMLFromImages(List<ByteArrayOutputStream> imageFilenames, String targetFilePath) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (ByteArrayOutputStream imageFileName : imageFilenames) {
            String base64 = Base64.getEncoder().encodeToString(imageFileName.toByteArray());
            sb.append("<br><img src=\"data:image/png;base64,").append(base64).append("\">");
        }
        FileIOOpt.writeStringToFile((String)sb.toString(), (String)targetFilePath);
    }

    public static String pptToPdfUseImage(String sourceFilePath, String targetFileName, String suffix) {
        File pptFile = new File(sourceFilePath);
        if (pptFile.exists()) {
            try {
                if ("ppt".equalsIgnoreCase(suffix)) {
                    List<ByteArrayOutputStream> htmlStr = PowerPointUtils.toImage2003(sourceFilePath);
                    PowerPointUtils.createPDFFromImages(htmlStr, targetFileName);
                    return "ok";
                }
                if ("pptx".equalsIgnoreCase(suffix)) {
                    List<ByteArrayOutputStream> htmlStr = PowerPointUtils.toImage2007(sourceFilePath);
                    PowerPointUtils.createPDFFromImages(htmlStr, targetFileName);
                    return "ok";
                }
                logger.error("ppt\u8f6c\u6362\u4e3apdf,\u6e90\u6587\u4ef6={}\u4e0d\u662fppt\u6587\u4ef6", (Object)sourceFilePath);
                return null;
            }
            catch (Exception e) {
                logger.error("ppt\u6587\u6863\u8f6c\u6362\u4e3apdf,\u53d1\u751f\u5f02\u5e38,\u6e90\u6587\u4ef6={},", (Object)sourceFilePath, (Object)e);
                return null;
            }
        }
        logger.error("ppt\u6587\u6863\u8f6c\u6362\u4e3apdf,\u6e90\u6587\u4ef6={}\u4e0d\u5b58\u5728", (Object)sourceFilePath);
        return null;
    }

    public static String pptToHtmlUseImage(String sourceFilePath, String targetFileName, String suffix) {
        File pptFile = new File(sourceFilePath);
        if (pptFile.exists()) {
            try {
                if ("ppt".equalsIgnoreCase(suffix)) {
                    List<ByteArrayOutputStream> htmlStr = PowerPointUtils.toImage2003(sourceFilePath);
                    PowerPointUtils.createHTMLFromImages(htmlStr, targetFileName);
                    return "ok";
                }
                if ("pptx".equalsIgnoreCase(suffix)) {
                    List<ByteArrayOutputStream> htmlStr = PowerPointUtils.toImage2007(sourceFilePath);
                    PowerPointUtils.createHTMLFromImages(htmlStr, targetFileName);
                    return "ok";
                }
                logger.error("ppt\u8f6c\u6362\u4e3ahtml,\u6e90\u6587\u4ef6={}\u4e0d\u662fppt\u6587\u4ef6", (Object)sourceFilePath);
                return null;
            }
            catch (Exception e) {
                logger.error("ppt\u6587\u6863\u8f6c\u6362\u4e3ahtml,\u53d1\u751f\u5f02\u5e38,\u6e90\u6587\u4ef6={},", (Object)sourceFilePath, (Object)e);
                return null;
            }
        }
        logger.error("ppt\u6587\u6863\u8f6c\u6362\u4e3ahtml,\u6e90\u6587\u4ef6={}\u4e0d\u5b58\u5728", (Object)sourceFilePath);
        return null;
    }

    private static List<ByteArrayOutputStream> toImage2007(String sourcePath) throws Exception {
        ArrayList<ByteArrayOutputStream> htmlStr = new ArrayList<ByteArrayOutputStream>();
        FileInputStream is = new FileInputStream(sourcePath);
        XMLSlideShow ppt = new XMLSlideShow((InputStream)is);
        is.close();
        Dimension pgsize = ppt.getPageSize();
        for (int i = 0; i < ppt.getSlides().size(); ++i) {
            try {
                for (XSLFShape shape : ((XSLFSlide)ppt.getSlides().get(i)).getShapes()) {
                    if (!(shape instanceof XSLFTextShape)) continue;
                    XSLFTextShape tsh = (XSLFTextShape)shape;
                    for (XSLFTextParagraph p : tsh) {
                        for (XSLFTextRun r : p) {
                            r.setFontFamily("\u5b8b\u4f53");
                        }
                    }
                }
                BufferedImage img = new BufferedImage(pgsize.width, pgsize.height, 1);
                Graphics2D graphics = img.createGraphics();
                graphics.setPaint(Color.white);
                graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, pgsize.width, pgsize.height));
                ((XSLFSlide)ppt.getSlides().get(i)).draw(graphics);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)img, "png", out);
                out.close();
                htmlStr.add(out);
                continue;
            }
            catch (Exception e) {
                logger.error("ppt\u8f6c\u6362\u4e3apdf,\u53d1\u751f\u5f02\u5e38,\u6e90\u6587\u4ef6={}", (Object)sourcePath, (Object)e);
                System.out.println("\u7b2c" + i + "\u5f20ppt\u8f6c\u6362\u51fa\u9519");
                return null;
            }
        }
        return htmlStr;
    }

    private static List<ByteArrayOutputStream> toImage2003(String sourcePath) {
        ArrayList<ByteArrayOutputStream> htmlStr = new ArrayList<ByteArrayOutputStream>();
        try {
            HSLFSlideShow ppt = new HSLFSlideShow(new HSLFSlideShowImpl(sourcePath));
            Dimension pgsize = ppt.getPageSize();
            for (int i = 0; i < ppt.getSlides().size(); ++i) {
                for (HSLFShape shape : ((HSLFSlide)ppt.getSlides().get(i)).getShapes()) {
                    if (!(shape instanceof HSLFTextShape)) continue;
                    HSLFTextShape tsh = (HSLFTextShape)shape;
                    for (HSLFTextParagraph p : tsh) {
                        for (HSLFTextRun r : p) {
                            r.setFontFamily("\u5b8b\u4f53");
                        }
                    }
                }
                BufferedImage img = new BufferedImage(pgsize.width, pgsize.height, 1);
                Graphics2D graphics = img.createGraphics();
                graphics.setPaint(Color.white);
                graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, pgsize.width, pgsize.height));
                ((HSLFSlide)ppt.getSlides().get(i)).draw(graphics);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)img, "png", out);
                out.close();
                htmlStr.add(out);
            }
        }
        catch (Exception e) {
            logger.error("ppt\u8f6c\u6362\u4e3aPdf,\u53d1\u751f\u5f02\u5e38,\u6e90\u6587\u4ef6={}", (Object)sourcePath, (Object)e);
            return null;
        }
        return htmlStr;
    }
}

