/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.centit.support.file.FileSystemOpt;
import com.centit.support.file.FileType;
import com.centit.support.office.XlsxTransformXls;
import com.centit.support.office.commons.CommonUtils;
import com.centit.support.office.commons.PowerPointUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hssf.converter.ExcelToHtmlConverter;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.docx4j.Docx4J;
import org.docx4j.Docx4jProperties;
import org.docx4j.convert.out.HTMLSettings;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OfficeToHtml {
    private static final Logger logger = LoggerFactory.getLogger(OfficeToHtml.class);

    private OfficeToHtml() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean ppt2Html(String inPptFile, String outPdfFile, String suffix) {
        String pdfFile;
        String inputFile = CommonUtils.mapWidowsPathIfNecessary(inPptFile);
        return "ok".equals(PowerPointUtils.pptToHtmlUseImage(inputFile, pdfFile = CommonUtils.mapWidowsPathIfNecessary(outPdfFile), suffix));
    }

    public static boolean ppt2Html(String inPptFile, String outPdfFile) {
        return OfficeToHtml.ppt2Html(inPptFile, outPdfFile, FileType.getFileExtName((String)inPptFile));
    }

    public static boolean excel2Html(InputStream inExcelStream, OutputStream outPdfStream, String suffix) {
        try {
            HSSFWorkbook excelBook = new HSSFWorkbook();
            if ("xls".equalsIgnoreCase(suffix)) {
                excelBook = new HSSFWorkbook(inExcelStream);
            } else if ("xlsx".equalsIgnoreCase(suffix)) {
                XlsxTransformXls xls = new XlsxTransformXls();
                XSSFWorkbook workbookOld = new XSSFWorkbook(inExcelStream);
                xls.transformXSSF(workbookOld, excelBook);
            } else {
                return false;
            }
            ExcelToHtmlConverter excelToHtmlConverter = new ExcelToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
            excelToHtmlConverter.setOutputColumnHeaders(false);
            excelToHtmlConverter.setOutputRowNumbers(false);
            excelToHtmlConverter.processWorkbook(excelBook);
            Transformer serializer = CommonUtils.createTransformer();
            serializer.transform(new DOMSource(excelToHtmlConverter.getDocument()), new StreamResult(outPdfStream));
            return true;
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean excel2Html(String inExcelFile, String outHtmlFile, String suffix) {
        String inFilePath = CommonUtils.mapWidowsPathIfNecessary(inExcelFile);
        String outFilePath = CommonUtils.mapWidowsPathIfNecessary(outHtmlFile);
        try (FileInputStream inWordStream = new FileInputStream(new File(inFilePath));){
            boolean bl;
            try (FileOutputStream outPdfStram = new FileOutputStream(new File(outFilePath));){
                bl = OfficeToHtml.excel2Html(inWordStream, outPdfStram, suffix);
            }
            return bl;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    public static boolean excel2Html(String inExcelFile, String outPdfFile) {
        return OfficeToHtml.excel2Html(inExcelFile, outPdfFile, FileType.getFileExtName((String)inExcelFile));
    }

    public static boolean word2Html(InputStream inWordStream, OutputStream outHtmlStream, final String imagePath, String suffix) {
        try {
            if ("doc".equalsIgnoreCase(suffix)) {
                HWPFDocument wordDocument = new HWPFDocument(inWordStream);
                WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(XMLHelper.getDocumentBuilderFactory().newDocumentBuilder().newDocument());
                wordToHtmlConverter.setPicturesManager(new PicturesManager(){

                    public String savePicture(byte[] paramArrayOfByte, PictureType paramPictureType, String paramString, float paramFloat1, float paramFloat2) {
                        return imagePath + File.separator + paramString;
                    }
                });
                wordToHtmlConverter.processDocument((HWPFDocumentCore)wordDocument);
                List pics = wordDocument.getPicturesTable().getAllPictures();
                for (Picture pic : pics) {
                    pic.writeImageContent((OutputStream)new FileOutputStream(imagePath + File.separator + pic.suggestFullFileName()));
                }
                Transformer serializer = CommonUtils.createTransformer();
                serializer.transform(new DOMSource(wordToHtmlConverter.getDocument()), new StreamResult(outHtmlStream));
                return true;
            }
            if ("docx".equalsIgnoreCase(suffix)) {
                WordprocessingMLPackage wordMLPackage = Docx4J.load((InputStream)inWordStream);
                HTMLSettings htmlSettings = Docx4J.createHTMLSettings();
                htmlSettings.setImageDirPath(imagePath);
                htmlSettings.setImageTargetUri(FileSystemOpt.extractFileName((String)imagePath));
                htmlSettings.setWmlPackage((OpcPackage)wordMLPackage);
                String userCSS = "html, body, div, span, h1, h2, h3, h4, h5, h6, p, a, img,  ol, ul, li, table, caption, tbody, tfoot, thead, tr, th, td { margin: 0; padding: 0; border: 0;}body {line-height: 1;} ";
                htmlSettings.setUserCSS(userCSS);
                Docx4jProperties.setProperty((String)"docx4j.Convert.Out.HTML.OutputMethodXML", (Boolean)true);
                Docx4jProperties.setProperty((String)"docx4j.Log4j.Configurator.disabled", (Boolean)true);
                Docx4J.toHTML((HTMLSettings)htmlSettings, (OutputStream)outHtmlStream, (int)1);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean word2Html(String inWordFile, String outHtmlFile) {
        String inFilePath = CommonUtils.mapWidowsPathIfNecessary(inWordFile);
        String outFilePath = CommonUtils.mapWidowsPathIfNecessary(outHtmlFile);
        try (FileInputStream inWordStream = new FileInputStream(new File(inFilePath));){
            boolean bl;
            try (FileOutputStream outPdfStram = new FileOutputStream(new File(outFilePath));){
                bl = OfficeToHtml.word2Html(inWordStream, outPdfStram, outFilePath.substring(0, outFilePath.lastIndexOf(46)), FileType.getFileExtName((String)inWordFile));
            }
            return bl;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

