/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service;

import com.centit.search.document.DocumentUtils;
import com.centit.search.service.ElasticConfig;
import com.centit.search.service.ElasticsearchClientManager;
import com.centit.search.service.Impl.ESIndexer;
import com.centit.search.service.Impl.ESSearcher;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.file.PropertiesReader;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public abstract class IndexerSearcherFactory {
    private static final ConcurrentHashMap<String, ESIndexer> indexerMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ESSearcher> searcherMap = new ConcurrentHashMap();

    public static ESIndexer obtainIndexer(String indexName) {
        return indexerMap.get(indexName);
    }

    public static ESIndexer obtainIndexer(ElasticConfig config, Class<?> objType) {
        String indexName = DocumentUtils.obtainDocumentIndexName(objType);
        if (StringUtils.isBlank((CharSequence)indexName)) {
            return null;
        }
        ESIndexer index = indexerMap.get(indexName);
        if (index != null) {
            return index;
        }
        ESIndexer indexer = new ESIndexer(ElasticsearchClientManager.getClient(config), indexName, objType);
        indexerMap.put(indexName, indexer);
        return indexer;
    }

    public static ESSearcher obtainSearcher(String indexName) {
        return searcherMap.get(indexName);
    }

    public static ESSearcher obtainSearcher(ElasticConfig config, Class<?> objType) {
        String indexName = DocumentUtils.obtainDocumentIndexName(objType);
        if (indexName == null) {
            return null;
        }
        ESSearcher search = searcherMap.get(indexName);
        if (search != null) {
            return search;
        }
        ESSearcher searcher = new ESSearcher(ElasticsearchClientManager.getClient(config));
        searcher.initTypeFields(indexName, objType);
        searcher.setHighlightPreTags(new String[]{"<span class='highlight'>"});
        searcher.setHighlightPostTags(new String[]{"</span>"});
        searcherMap.put(indexName, searcher);
        return searcher;
    }

    public static ElasticConfig loadESServerConfigFormProperties(Properties properties) {
        ElasticConfig config = new ElasticConfig();
        config.setServerHostIp(properties.getProperty("elasticsearch.server.ip"));
        config.setServerHostPort(properties.getProperty("elasticsearch.server.port"));
        config.setClusterName(properties.getProperty("elasticsearch.server.cluster"));
        config.setUsername(properties.getProperty("elasticsearch.server.username"));
        config.setPassword(properties.getProperty("elasticsearch.server.password"));
        config.setMinScore(NumberBaseOpt.parseFloat((String)properties.getProperty("elasticsearch.filter.minScore"), (Float)Float.valueOf(0.5f)).floatValue());
        return config;
    }

    public static ElasticConfig loadESServerConfigFormProperties(String propertiesFile) {
        Properties properties = PropertiesReader.getClassPathProperties((String)propertiesFile);
        assert (properties != null);
        return IndexerSearcherFactory.loadESServerConfigFormProperties(properties);
    }
}

