/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.centit.search.service.ElasticConfig;
import com.centit.support.security.SecurityOptUtils;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public abstract class ElasticsearchClientManager {
    private static final ConcurrentHashMap<ElasticConfig, ElasticsearchClient> clientCache = new ConcurrentHashMap();

    public static ElasticsearchClient getClient(ElasticConfig config) {
        return clientCache.computeIfAbsent(config, ElasticsearchClientManager::createClient);
    }

    private static ElasticsearchClient createClient(ElasticConfig config) {
        try {
            String[] urls = config.getServerUrls();
            HttpHost[] httpHosts = new HttpHost[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                String[] parts;
                String url = urls[i];
                if (url.startsWith("http://")) {
                    parts = url.substring(7).split(":");
                    httpHosts[i] = new HttpHost(parts[0], Integer.parseInt(parts[1]), "http");
                    continue;
                }
                if (!url.startsWith("https://")) continue;
                parts = url.substring(8).split(":");
                httpHosts[i] = new HttpHost(parts[0], Integer.parseInt(parts[1]), "https");
            }
            RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])httpHosts);
            if (StringUtils.isNotBlank((CharSequence)config.getUsername()) && StringUtils.isNotBlank((CharSequence)config.getPassword())) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(SecurityOptUtils.decodeSecurityString((String)config.getUsername()), SecurityOptUtils.decodeSecurityString((String)config.getPassword())));
                clientBuilder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider));
            }
            clientBuilder.setHttpClientConfigCallback(httpClientBuilder -> {
                if (StringUtils.isNotBlank((CharSequence)config.getUsername()) && StringUtils.isNotBlank((CharSequence)config.getPassword())) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(SecurityOptUtils.decodeSecurityString((String)config.getUsername()), SecurityOptUtils.decodeSecurityString((String)config.getPassword())));
                    httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
                return httpClientBuilder.setMaxConnTotal(500).setMaxConnPerRoute(100);
            });
            RestClient restClient = clientBuilder.build();
            RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
            return new ElasticsearchClient((ElasticsearchTransport)transport);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create ElasticsearchClient", e);
        }
    }

    public static void closeClient(ElasticConfig config) {
        ElasticsearchClient client = clientCache.remove(config);
        if (client != null) {
            try {
                ((ElasticsearchTransport)client._transport()).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeAllClients() {
        for (ElasticsearchClient client : clientCache.values()) {
            try {
                ((ElasticsearchTransport)client._transport()).close();
            }
            catch (IOException iOException) {}
        }
        clientCache.clear();
    }

    public static int getCacheSize() {
        return clientCache.size();
    }
}

