/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.metadata.DB2Metadata;
import com.centit.support.database.metadata.JdbcMetadata;
import com.centit.support.database.metadata.OracleMetadata;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.SqlSvrMetadata;
import com.centit.support.database.utils.DBType;
import java.sql.Connection;
import java.sql.SQLException;

public interface DatabaseMetadata {
    public static DatabaseMetadata createDatabaseMetadata(DBType dbtype) throws SQLException {
        switch (dbtype) {
            case Oracle: 
            case DM: 
            case KingBase: 
            case Oscar: {
                return new OracleMetadata();
            }
            case DB2: {
                return new DB2Metadata();
            }
            case SqlServer: {
                return new SqlSvrMetadata();
            }
        }
        return new JdbcMetadata();
    }

    public void setDBConfig(Connection var1);

    public SimpleTableInfo getTableMetadata(String var1);

    public String getDBSchema();

    public void setDBSchema(String var1);
}

