/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.orm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.LeftRightPair;
import com.centit.support.common.ObjectException;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.jsonmaptable.JsonObjectDao;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.JpaMetadata;
import com.centit.support.database.orm.TableMapInfo;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.database.utils.DatabaseAccess;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class OrmUtils {
    private static final String DNS1123 = "0123456789qwertyuiopasdfghjklzxcvbnm";

    private OrmUtils() {
        throw new IllegalAccessError("Utility class");
    }

    private static void putResultSetObjectToField(Object object, TableMapInfo mapInfo, SimpleTableField field, Object newValue) throws IOException {
        if (field == null) {
            return;
        }
        if (newValue instanceof Clob) {
            String sValue = DatabaseAccess.fetchClobString((Clob)newValue);
            if ("object".equals(field.getFieldType())) {
                Class<?> clazz = field.getJavaType();
                if (JSON.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
                    mapInfo.setObjectFieldValue(object, field, JSON.parse((String)sValue));
                } else {
                    mapInfo.setObjectFieldValue(object, field, JSON.parseObject((String)sValue, clazz));
                }
            } else {
                mapInfo.setObjectFieldValue(object, field, (Object)sValue);
            }
        } else if (newValue instanceof Blob) {
            mapInfo.setObjectFieldValue(object, field, (Object)DatabaseAccess.fetchBlobBytes((Blob)newValue));
        } else if ("object".equals(field.getFieldType())) {
            Class<?> clazz = field.getJavaType();
            newValue = JSON.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) ? JSON.parse((String)StringBaseOpt.castObjectToString((Object)newValue)) : JSON.parseObject((String)StringBaseOpt.castObjectToString((Object)newValue), clazz);
            mapInfo.setObjectFieldValue(object, field, newValue);
        } else {
            mapInfo.setObjectFieldValue(object, field, newValue);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static <T> T makeObjectValueByGenerator(T object, TableMapInfo mapInfo, JsonObjectDao sqlDialect, GeneratorTime generatorTime) throws SQLException, IOException {
        valueGenerators = mapInfo.getValueGenerators();
        if (valueGenerators == null || valueGenerators.size() < 1) {
            return object;
        }
        block12: for (LeftRightPair<String, ValueGenerator> ent : valueGenerators) {
            valueGenerator = (ValueGenerator)ent.getRight();
            if (!valueGenerator.occasion().matchTime(generatorTime) || (fieldValue = mapInfo.getObjectFieldValue(object, field = mapInfo.findFieldByName((String)ent.getLeft()))) != null && valueGenerator.condition() != GeneratorCondition.ALWAYS) continue;
            block0 : switch (1.$SwitchMap$com$centit$support$database$orm$GeneratorType[valueGenerator.strategy().ordinal()]) {
                case 1: {
                    mapInfo.setObjectFieldValue(object, field, (Object)UuidOpt.getUuidAsString32());
                    break;
                }
                case 2: {
                    mapInfo.setObjectFieldValue(object, field, (Object)UuidOpt.getUuidAsString22());
                    break;
                }
                case 3: {
                    if (sqlDialect == null) break;
                    genValue = valueGenerator.value();
                    params = genValue.split(":");
                    seqNo = sqlDialect.getSequenceNextValue(params[0]);
                    if (params.length == 1) {
                        mapInfo.setObjectFieldValue(object, field, (Object)seqNo);
                        break;
                    }
                    if (params.length > 3) {
                        mapInfo.setObjectFieldValue(object, field, (Object)StringBaseOpt.midPad((String)seqNo.toString(), (int)NumberBaseOpt.castObjectToInteger((Object)params[2], (Integer)1), (String)params[1], (String)params[3]));
                        break;
                    }
                    mapInfo.setObjectFieldValue(object, field, (Object)(params[1] + seqNo));
                    break;
                }
                case 4: {
                    mapInfo.setObjectFieldValue(object, field, (Object)valueGenerator.value());
                    break;
                }
                case 5: {
                    mapInfo.setObjectFieldValue(object, field, VariableFormula.calculate((String)valueGenerator.value(), object));
                    break;
                }
                case 6: {
                    genValue = valueGenerator.value();
                    n = genValue.indexOf(58);
                    if (n <= 0 || sqlDialect == null) continue block12;
                    seq = genValue.substring(0, n);
                    seqNo = sqlDialect.getSequenceNextValue(seq);
                    json = (JSONObject)JSON.toJSON(object);
                    json.put("seqNo", (Object)seqNo);
                    mapInfo.setObjectFieldValue(object, field, VariableFormula.calculate((String)genValue.substring(n + 1), object));
                    break;
                }
                case 7: {
                    genValue = valueGenerator.value();
                    params = genValue.split(":");
                    if (params.length <= 0 || sqlDialect == null) ** GOTO lbl58
                    prefix = params.length > 1 ? params[1] : "";
                    len = NumberBaseOpt.castObjectToInteger((Object)params[0], (Integer)23);
                    if (len <= 22) ** GOTO lbl53
                    mapInfo.setObjectFieldValue(object, field, (Object)(prefix + UuidOpt.getUuidAsString22()));
                    ** GOTO lbl58
lbl53:
                    // 2 sources

                    for (i = 0; i < 100; ++i) {
                        no = prefix + UuidOpt.getUuidAsString22().substring(0, len);
                        if (NumberBaseOpt.castObjectToInteger((Object)DatabaseAccess.fetchScalarObject(sqlDialect.findObjectsBySql("select count(*) hasId from " + mapInfo.getTableName() + " where " + field.getColumnName() + " = ?", new Object[]{no})), (Integer)0) != 0) continue;
                        mapInfo.setObjectFieldValue(object, field, (Object)no);
                        break;
                    }
                }
lbl58:
                // 5 sources

                case 8: {
                    genValue = valueGenerator.value();
                    params = genValue.split(":");
                    if (params.length <= 0 || sqlDialect == null) continue block12;
                    prefix = params.length > 1 ? params[1] : "";
                    len = NumberBaseOpt.castObjectToInteger((Object)params[0], (Integer)10);
                    for (i = 0; i < 100; ++i) {
                        no = prefix + RandomStringUtils.random((int)len, (String)"0123456789qwertyuiopasdfghjklzxcvbnm");
                        nHasId = NumberBaseOpt.castObjectToInteger((Object)DatabaseAccess.fetchScalarObject(sqlDialect.findObjectsBySql("select count(*) hasId from " + mapInfo.getTableName() + " where " + field.getColumnName() + " = ?", new Object[]{no})), (Integer)0);
                        if (nHasId != 0) continue;
                        mapInfo.setObjectFieldValue(object, field, (Object)no);
                        break block0;
                    }
                    continue block12;
                }
                case 9: {
                    mapInfo.setObjectFieldValue(object, field, (Object)((System.currentTimeMillis() - 1577808000000L) * 10000L + Math.round(Math.random() * 10000.0)));
                    break;
                }
                case 10: {
                    pkCount = mapInfo.countPkColumn();
                    if (pkCount < 2 || !field.isPrimaryKey()) {
                        throw new ObjectException(627, "\u4e3b\u952e\u751f\u6210\u89c4\u5219SUB_ORDER\u5fc5\u987b\u7528\u4e8e\u7b26\u5408\u4e3b\u952e\u8868\u4e2d\uff0c\u5e76\u4e14\u53ea\u80fd\u7528\u4e8e\u6574\u578b\u5b57\u6bb5\uff01");
                    }
                    sqlBuilder = new StringBuilder("select max(");
                    sqlBuilder.append(field.getColumnName()).append(" ) as maxOrder from ").append(mapInfo.getTableName()).append(" where ");
                    pki = 0;
                    pkValues = new Object[pkCount - 1];
                    for (SimpleTableField col : mapInfo.getColumns()) {
                        if (!col.isPrimaryKey() || StringUtils.equals((CharSequence)col.getPropertyName(), (CharSequence)field.getPropertyName())) continue;
                        if (pki > 0) {
                            sqlBuilder.append(" and ");
                        }
                        sqlBuilder.append(col.getColumnName()).append(" = ?");
                        pkValues[pki] = mapInfo.getObjectFieldValue(object, col);
                        ++pki;
                    }
                    pkSubOrder = NumberBaseOpt.castObjectToLong((Object)DatabaseAccess.fetchScalarObject(sqlDialect.findObjectsBySql(sqlBuilder.toString(), pkValues)), (Long)0L);
                    mapInfo.setObjectFieldValue(object, field, (Object)(pkSubOrder + 1L));
                }
            }
        }
        return object;
    }

    public static <T> T prepareObjectForInsert(T object, TableMapInfo mapInfo, JsonObjectDao sqlDialect) throws SQLException, IOException {
        return OrmUtils.makeObjectValueByGenerator(object, mapInfo, sqlDialect, GeneratorTime.NEW);
    }

    public static <T> T prepareObjectForUpdate(T object, TableMapInfo mapInfo, JsonObjectDao sqlDialect) throws SQLException, IOException {
        return OrmUtils.makeObjectValueByGenerator(object, mapInfo, sqlDialect, GeneratorTime.UPDATE);
    }

    public static <T> T prepareObjectForMerge(T object, TableMapInfo mapInfo, JsonObjectDao sqlDialect) throws SQLException, IOException {
        Map<String, Object> objectMap = OrmUtils.fetchObjectDatabaseField(object, mapInfo);
        if (!GeneralJsonObjectDao.checkHasAllPkColumns(mapInfo, objectMap)) {
            return OrmUtils.makeObjectValueByGenerator(object, mapInfo, sqlDialect, GeneratorTime.NEW);
        }
        return OrmUtils.makeObjectValueByGenerator(object, mapInfo, sqlDialect, GeneratorTime.UPDATE);
    }

    public static Map<String, Object> fetchObjectField(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        Field[] objFields = object.getClass().getDeclaredFields();
        HashMap<String, Object> fields = new HashMap<String, Object>(objFields.length * 2);
        for (Field field : objFields) {
            Object value = ReflectionOpt.forceGetFieldValue((Object)object, (Field)field);
            fields.put(field.getName(), value);
        }
        return fields;
    }

    public static Map<String, Object> fetchObjectDatabaseField(Object object, TableMapInfo tableInfo) {
        List<SimpleTableField> tableFields = tableInfo.getColumns();
        if (tableFields == null) {
            return null;
        }
        HashMap<String, Object> fields = new HashMap<String, Object>(tableFields.size() + 6);
        for (SimpleTableField column : tableFields) {
            Object value = tableInfo.getObjectFieldValue(object, column);
            if (value == null) continue;
            if ("boolean".equals(column.getFieldType())) {
                value = BooleanBaseOpt.castObjectToBoolean((Object)value, (Boolean)false) != false ? "T" : "F";
            }
            fields.put(column.getPropertyName(), value);
        }
        return fields;
    }

    private static <T> T insideFetchFieldsFormResultSet(ResultSet rs, T object, TableMapInfo mapInfo) throws SQLException, IOException {
        ResultSetMetaData resMeta = rs.getMetaData();
        int fieldCount = resMeta.getColumnCount();
        for (int i = 1; i <= fieldCount; ++i) {
            String columnName = resMeta.getColumnName(i);
            SimpleTableField filed = mapInfo.findFieldByColumn(columnName);
            if (filed == null) continue;
            OrmUtils.putResultSetObjectToField(object, mapInfo, filed, rs.getObject(i));
        }
        return OrmUtils.makeObjectValueByGenerator(object, mapInfo, null, GeneratorTime.READ);
    }

    private static <T> T insideFetchFieldsFormResultSet(ResultSet rs, T object, TableMapInfo mapInfo, TableField[] fields) throws SQLException, IOException {
        int fieldCount = rs.getMetaData().getColumnCount();
        if (fieldCount > fields.length) {
            fieldCount = fields.length;
        }
        for (int i = 0; i < fieldCount; ++i) {
            OrmUtils.putResultSetObjectToField(object, mapInfo, (SimpleTableField)fields[i], rs.getObject(i + 1));
        }
        return OrmUtils.makeObjectValueByGenerator(object, mapInfo, null, GeneratorTime.READ);
    }

    static <T> T fetchObjectFormResultSet(ResultSet rs, Class<T> clazz, TableField[] fields) throws SQLException, IllegalAccessException, InstantiationException, IOException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(clazz);
        if (mapInfo == null) {
            return null;
        }
        if (rs.next()) {
            return OrmUtils.insideFetchFieldsFormResultSet(rs, clazz.newInstance(), mapInfo, fields);
        }
        return null;
    }

    static <T> T fetchFieldsFormResultSet(ResultSet rs, T object, TableMapInfo mapInfo, SimpleTableField[] fields) throws SQLException, IOException {
        if (rs.next()) {
            object = OrmUtils.insideFetchFieldsFormResultSet(rs, object, mapInfo, fields);
        }
        return object;
    }

    static <T> T fetchObjectFormResultSet(ResultSet rs, Class<T> clazz) throws SQLException, IllegalAccessException, InstantiationException, IOException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(clazz);
        if (mapInfo == null) {
            return null;
        }
        if (rs.next()) {
            return OrmUtils.insideFetchFieldsFormResultSet(rs, clazz.newInstance(), mapInfo);
        }
        return null;
    }

    static <T> T fetchFieldsFormResultSet(ResultSet rs, T object, TableMapInfo mapInfo) throws SQLException, IOException {
        if (rs.next()) {
            object = OrmUtils.insideFetchFieldsFormResultSet(rs, object, mapInfo);
        }
        return object;
    }

    static <T> List<T> fetchObjectListFormResultSet(ResultSet rs, Class<T> clazz, TableField[] fields) throws SQLException, IllegalAccessException, InstantiationException, IOException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(clazz);
        if (mapInfo == null) {
            return null;
        }
        int fieldCount = rs.getMetaData().getColumnCount();
        if (fieldCount > fields.length) {
            fieldCount = fields.length;
        }
        ArrayList<T> listObj = new ArrayList<T>();
        while (rs.next()) {
            T object = clazz.newInstance();
            for (int i = 0; i < fieldCount; ++i) {
                OrmUtils.putResultSetObjectToField(object, mapInfo, (SimpleTableField)fields[i], rs.getObject(i + 1));
            }
            listObj.add(OrmUtils.makeObjectValueByGenerator(object, mapInfo, null, GeneratorTime.READ));
        }
        return listObj;
    }

    static <T> List<T> fetchObjectListFormResultSet(ResultSet rs, Class<T> clazz) throws SQLException, IllegalAccessException, InstantiationException, IOException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(clazz);
        if (mapInfo == null) {
            return null;
        }
        ResultSetMetaData resMeta = rs.getMetaData();
        int fieldCount = resMeta.getColumnCount();
        SimpleTableField[] fields = new SimpleTableField[fieldCount + 1];
        for (int i = 1; i <= fieldCount; ++i) {
            String columnName = resMeta.getColumnName(i);
            fields[i] = mapInfo.findFieldByColumn(columnName);
        }
        ArrayList<T> listObj = new ArrayList<T>();
        while (rs.next()) {
            T object = clazz.newInstance();
            for (int i = 1; i <= fieldCount; ++i) {
                if (fields[i] == null) continue;
                OrmUtils.putResultSetObjectToField(object, mapInfo, fields[i], rs.getObject(i));
            }
            listObj.add(OrmUtils.makeObjectValueByGenerator(object, mapInfo, null, GeneratorTime.READ));
        }
        return listObj;
    }
}

