/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.utils;

import com.centit.support.database.utils.DatabaseAccessException;
import java.io.IOException;
import java.sql.SQLException;

public class PersistenceException
extends RuntimeException {
    private static final long serialVersionUID = 4050482305178810162L;
    public static final int UNKNOWN_EXCEPTION = -1;
    public static final int NULL_EXCEPTION = 2;
    public static final int BLANK_EXCEPTION = 3;
    public static final int FORMAT_DATE_EXCEPTION = 4;
    public static final int FORMAT_NUMBER_EXCEPTION = 5;
    public static final int DATABASE_OPERATE_EXCEPTION = 6;
    public static final int DATABASE_OUT_SYNC_EXCEPTION = 7;
    public static final int DATABASE_SQL_EXCEPTION = 8;
    public static final int DATABASE_IO_EXCEPTION = 9;
    public static final int NOSUCHFIELD_EXCEPTION = 10;
    public static final int INSTANTIATION_EXCEPTION = 11;
    public static final int ILLEGALACCESS_EXCEPTION = 12;
    public static final int ORM_METADATA_EXCEPTION = 14;
    private int exceptionCode;

    public PersistenceException(int exceptionCode, String message, Throwable exception) {
        super(message, exception);
        this.exceptionCode = exceptionCode;
    }

    public PersistenceException(int exceptionCode, String message) {
        super(message);
        this.exceptionCode = exceptionCode;
    }

    public PersistenceException(int exceptionCode, Throwable exception) {
        super(exception);
        this.exceptionCode = exceptionCode;
    }

    public PersistenceException(Throwable exception) {
        super(exception);
        this.exceptionCode = -1;
    }

    public PersistenceException(SQLException exception) {
        super(exception);
        this.exceptionCode = 8;
    }

    public PersistenceException(String sql, SQLException e) {
        super(sql + " raise " + e.getMessage(), e.getCause());
        this.exceptionCode = 8;
    }

    public PersistenceException(DatabaseAccessException exception) {
        super(exception);
        this.exceptionCode = 8;
    }

    public PersistenceException(IOException exception) {
        super(exception);
        this.exceptionCode = 9;
    }

    public PersistenceException(String message) {
        super(message);
        this.exceptionCode = -1;
    }

    public int getExceptionCode() {
        return this.exceptionCode;
    }

    public void setExceptionCode(int exceptionCode) {
        this.exceptionCode = exceptionCode;
    }
}

