/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.ddl;

import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import java.sql.Connection;

public class MySqlDDLOperations
extends GeneralDDLOperations {
    public MySqlDDLOperations() {
    }

    public MySqlDDLOperations(Connection conn) {
        super(conn);
    }

    @Override
    protected void appendPkSql(TableInfo tableInfo, StringBuilder sbCreate) {
        if (tableInfo.getPkColumns() != null && tableInfo.getPkColumns().size() > 0) {
            sbCreate.append(" primary key ");
            this.appendPkColumnSql(tableInfo, sbCreate);
        }
    }

    @Override
    public String makeRenameColumnSql(String tableCode, String columnCode, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        sbsql.append(" CHANGE ");
        sbsql.append(columnCode);
        sbsql.append(" ");
        sbsql.append(column.getColumnName());
        sbsql.append(" ");
        sbsql.append(column.getColumnType());
        if (column.getMaxLength() > 0) {
            sbsql.append("(").append(column.getMaxLength()).append(")");
        } else if (column.getPrecision() > 0) {
            sbsql.append("(").append(column.getPrecision());
            if (column.getScale() > 0) {
                sbsql.append(",").append(column.getScale());
            }
            sbsql.append(")");
        }
        return sbsql.toString();
    }
}

