/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.metadata.DatabaseMetadata;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.SimpleTableReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DB2Metadata
implements DatabaseMetadata {
    protected static final Logger logger = LoggerFactory.getLogger(DB2Metadata.class);
    private static final String sqlGetTabColumns = "select a.name,a.coltype,a.length, a.scale, a.nulls from sysibm.systables b , sysibm.syscolumns a where a.tbcreator= ? and a.tbname= ? and b.name=a.tbname and b.creator=a.tbcreator";
    private static final String sqlPKInfo = "select constname, colname from sysibm.syskeycoluse where tbcreator=? and tbname=? order by colseq";
    private static final String sqlFKInfo = "select tbname, relname, colcount, fkcolnames, pkcolnames from sysibm.sysrels where refkeyname= ?";
    private static final String sqlFKColumn = "select a.name,a.coltype,a.length, a.scale, a.nulls from sysibm.systables b , sysibm.syscolumns a where a.tbcreator= ? and a.tbname= ? and a.name= ? and b.name=a.tbname and b.creator=a.tbcreator";
    private String sDBSchema;
    private Connection dbc;

    @Override
    public void setDBConfig(Connection dbc) {
        this.dbc = dbc;
    }

    @Override
    public String getDBSchema() {
        return this.sDBSchema;
    }

    @Override
    public void setDBSchema(String schema) {
        if (schema != null) {
            this.sDBSchema = schema.toUpperCase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleTableInfo getTableMetadata(String tabName) {
        SimpleTableInfo tab = new SimpleTableInfo(tabName);
        Statement pStmt = null;
        ResultSet rs = null;
        try {
            tab.setSchema(this.dbc.getSchema().toUpperCase());
            pStmt = this.dbc.prepareStatement(sqlGetTabColumns);
            pStmt.setString(1, this.sDBSchema);
            pStmt.setString(2, tabName);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                SimpleTableField field = new SimpleTableField();
                field.setColumnName(rs.getString("name"));
                field.setColumnType(rs.getString("coltype"));
                field.setMaxLength(rs.getInt("length"));
                field.setPrecision(field.getMaxLength());
                field.setScale(rs.getInt("scale"));
                field.setNullEnable(rs.getString("nulls"));
                field.mapToMetadata();
                tab.getColumns().add(field);
            }
            rs.close();
            pStmt.close();
            pStmt = this.dbc.prepareStatement(sqlPKInfo);
            pStmt.setString(1, this.sDBSchema);
            pStmt.setString(2, tabName);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                tab.setPkName(rs.getString("constname"));
                tab.getPkColumns().add(rs.getString("colname"));
            }
            rs.close();
            pStmt.close();
            pStmt = this.dbc.prepareStatement(sqlFKInfo);
            pStmt.setString(1, tab.getPkName());
            rs = pStmt.executeQuery();
            while (rs.next()) {
                SimpleTableReference ref = new SimpleTableReference();
                ref.setParentTableName(tabName);
                ref.setTableName(rs.getString("tbname"));
                ref.setReferenceCode(rs.getString("relname"));
                int nColCount = rs.getInt("colcount");
                String sFColNames = rs.getString("fkcolnames").trim();
                String[] p = sFColNames.split("\\s+");
                String sPColNames = rs.getString("pkcolnames").trim();
                String[] pK = sPColNames.split("\\s+");
                if (nColCount != p.length) {
                    System.out.println("\u5916\u952e" + ref.getReferenceCode() + "\u5b57\u6bb5\u5206\u9694\u51fa\u9519\uff01");
                }
                for (int i = 0; i < p.length; ++i) {
                    SimpleTableField field = new SimpleTableField();
                    field.setColumnName(p[i]);
                    ref.getFkColumns().add(field);
                    if (i >= pK.length) continue;
                    ref.getReferenceColumns().put(pK[i], p[i]);
                }
                tab.getReferences().add(ref);
            }
            rs.close();
            pStmt.close();
            for (SimpleTableReference ref : tab.getReferences()) {
                for (SimpleTableField field : ref.getFkColumns()) {
                    pStmt = this.dbc.prepareStatement(sqlFKColumn);
                    pStmt.setString(1, this.sDBSchema);
                    pStmt.setString(2, ref.getTableName());
                    pStmt.setString(3, field.getColumnName());
                    rs = pStmt.executeQuery();
                    if (rs.next()) {
                        field.setColumnType(rs.getString("coltype"));
                        field.setMaxLength(rs.getInt("length"));
                        field.setPrecision(field.getMaxLength());
                        field.setScale(rs.getInt("scale"));
                        field.setNullEnable(rs.getString("nulls"));
                        field.mapToMetadata();
                    }
                    rs.close();
                    pStmt.close();
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return tab;
    }
}

