/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.ddl;

import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.utils.QueryUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class OracleDDLOperations
extends GeneralDDLOperations {
    public OracleDDLOperations() {
    }

    public OracleDDLOperations(Connection conn) {
        super(conn);
    }

    @Override
    public String makeCreateSequenceSql(String sequenceName) {
        return "create sequence " + QueryUtils.cleanSqlStatement(sequenceName);
    }

    @Override
    public String makeModifyColumnSql(String tableCode, TableField oldColumn, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        sbsql.append(" modify ").append(column.getColumnName()).append(" ");
        if (!StringUtils.equalsIgnoreCase((CharSequence)oldColumn.getColumnType(), (CharSequence)column.getColumnType()) || oldColumn.getMaxLength() != column.getMaxLength() || oldColumn.getPrecision() != column.getPrecision()) {
            this.appendColumnTypeSQL(column, sbsql);
        }
        if (oldColumn.isMandatory() != column.isMandatory()) {
            sbsql.append(column.isMandatory() ? " not null" : " null");
        }
        return sbsql.toString();
    }

    @Override
    public String makeAddColumnSql(String tableCode, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        sbsql.append(" add ");
        this.appendColumnSQL(column, sbsql);
        return sbsql.toString();
    }

    @Override
    public List<String> makeReconfigurationColumnSqls(String tableCode, String columnCode, TableField column) {
        ArrayList<String> sqls = new ArrayList<String>();
        SimpleTableField tempColumn = new SimpleTableField();
        tempColumn.setColumnName(columnCode + "_1");
        sqls.add(this.makeRenameColumnSql(tableCode, columnCode, tempColumn));
        sqls.add(this.makeAddColumnSql(tableCode, column));
        if ("String".equals(column.getJavaType())) {
            sqls.add("update " + tableCode + " set " + column.getColumnName() + " = to_char(" + columnCode + ")");
        }
        if ("Date".equals(column.getJavaType())) {
            sqls.add("update " + tableCode + " set " + column.getColumnName() + " = to_date(" + columnCode + ")");
        }
        if ("Long".equals(column.getJavaType()) || "Double".equals(column.getJavaType())) {
            sqls.add("update " + tableCode + " set " + column.getColumnName() + " = to_number(" + columnCode + ")");
        }
        sqls.add(this.makeDropColumnSql(tableCode, columnCode + "_1"));
        return sqls;
    }
}

