/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.ddl;

import com.centit.support.database.ddl.DB2DDLOperations;
import com.centit.support.database.ddl.DDLOperations;
import com.centit.support.database.ddl.H2DDLOperations;
import com.centit.support.database.ddl.MySqlDDLOperations;
import com.centit.support.database.ddl.OracleDDLOperations;
import com.centit.support.database.ddl.SqlSvrDDLOperations;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.QueryUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class GeneralDDLOperations
implements DDLOperations {
    protected Connection conn;

    public GeneralDDLOperations() {
    }

    public GeneralDDLOperations(Connection conn) {
        this.conn = conn;
    }

    public void setConnect(Connection conn) {
        this.conn = conn;
    }

    public static GeneralDDLOperations createDDLOperations(DBType dbtype) throws SQLException {
        switch (dbtype) {
            case Oracle: {
                return new OracleDDLOperations();
            }
            case DB2: {
                return new DB2DDLOperations();
            }
            case SqlServer: {
                return new SqlSvrDDLOperations();
            }
            case MySql: {
                return new MySqlDDLOperations();
            }
            case H2: {
                return new H2DDLOperations();
            }
        }
        throw new SQLException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + dbtype.toString());
    }

    public static GeneralDDLOperations createDDLOperations(Connection conn) throws SQLException {
        DBType dbtype = DBType.mapDBType(conn.getMetaData().getURL());
        GeneralDDLOperations dllOperations = GeneralDDLOperations.createDDLOperations(dbtype);
        dllOperations.setConnect(conn);
        return dllOperations;
    }

    public static final boolean checkLabelName(CharSequence seq) {
        if (seq == null || seq.length() == 0) {
            return false;
        }
        int strLen = seq.length();
        char c = seq.charAt(0);
        if (!(c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        for (int i = 1; i < strLen; ++i) {
            c = seq.charAt(i);
            if (c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static final Pair<Integer, String> checkTableWellDefined(TableInfo tableInfo) {
        if (!GeneralDDLOperations.checkLabelName(tableInfo.getTableName())) {
            return new ImmutablePair((Object)-1, (Object)("\u8868\u540d" + tableInfo.getTableName() + "\u683c\u5f0f\u4e0d\u6b63\u786e\uff01"));
        }
        for (TableField tableField : tableInfo.getColumns()) {
            if (!GeneralDDLOperations.checkLabelName(tableField.getColumnName())) {
                return new ImmutablePair((Object)-2, (Object)("\u5b57\u6bb5\u540d" + tableField.getColumnName() + "\u683c\u5f0f\u4e0d\u6b63\u786e\uff01"));
            }
            if (!StringUtils.isBlank((CharSequence)tableField.getColumnType())) continue;
            return new ImmutablePair((Object)-3, (Object)("\u5b57\u6bb5" + tableField.getColumnName() + "\u6ca1\u6709\u6307\u5b9a\u7c7b\u578b\uff01"));
        }
        if (tableInfo.getPkColumns() == null || tableInfo.getPkColumns().size() == 0) {
            return new ImmutablePair((Object)-4, (Object)"\u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e\uff01");
        }
        return new ImmutablePair((Object)0, (Object)"ok\uff01");
    }

    @Override
    public String makeCreateSequenceSql(String sequenceName) {
        return "INSERT INTO simulate_sequence (seqname, currvalue , increment) VALUES (" + QueryUtils.buildStringForQuery(sequenceName) + ", 0, 1)";
    }

    @Override
    public String makeCreateTableSql(TableInfo tableInfo) {
        StringBuilder sbCreate = new StringBuilder("create table ");
        sbCreate.append(tableInfo.getTableName()).append(" (");
        this.appendColumnsSQL(tableInfo, sbCreate);
        this.appendPkSql(tableInfo, sbCreate);
        sbCreate.append(")");
        return sbCreate.toString();
    }

    protected void appendPkSql(TableInfo tableInfo, StringBuilder sbCreate) {
        if (tableInfo.getPkColumns() != null && tableInfo.getPkColumns().size() > 0) {
            sbCreate.append(" constraint ");
            if (StringUtils.isBlank((CharSequence)tableInfo.getPkName())) {
                sbCreate.append("pk_" + tableInfo.getTableName());
            } else {
                sbCreate.append(tableInfo.getPkName());
            }
            sbCreate.append(" primary key ");
            this.appendPkColumnSql(tableInfo, sbCreate);
        }
    }

    protected void appendPkColumnSql(TableInfo tableInfo, StringBuilder sbCreate) {
        sbCreate.append("(");
        int i = 0;
        for (String pkfield : tableInfo.getPkColumns()) {
            if (i > 0) {
                sbCreate.append(", ");
            }
            sbCreate.append(pkfield);
            ++i;
        }
        sbCreate.append(")");
    }

    protected void appendColumnsSQL(TableInfo tableInfo, StringBuilder sbCreate) {
        for (TableField tableField : tableInfo.getColumns()) {
            this.appendColumnSQL(tableField, sbCreate);
            if (StringUtils.isNotBlank((CharSequence)tableField.getDefaultValue())) {
                sbCreate.append(" default ").append(tableField.getDefaultValue());
            }
            sbCreate.append(",");
        }
    }

    protected void appendColumnTypeSQL(TableField field, StringBuilder sbCreate) {
        sbCreate.append(field.getColumnType());
        if ("varchar".equalsIgnoreCase(field.getColumnType()) || "varchar2".equalsIgnoreCase(field.getColumnType())) {
            if (field.getMaxLength() > 0) {
                sbCreate.append("(").append(field.getMaxLength()).append(")");
            } else {
                sbCreate.append("(64)");
            }
        } else if ("number".equalsIgnoreCase(field.getColumnType()) || "decimal".equalsIgnoreCase(field.getColumnType())) {
            if (field.getPrecision() > 0) {
                sbCreate.append("(").append(field.getPrecision());
            } else {
                sbCreate.append("(").append(24);
            }
            if (field.getScale() > 0) {
                sbCreate.append(",").append(field.getScale());
            }
            sbCreate.append(")");
        }
    }

    protected void appendColumnSQL(TableField field, StringBuilder sbCreate) {
        sbCreate.append(field.getColumnName()).append(" ");
        this.appendColumnTypeSQL(field, sbCreate);
        if (field.isMandatory()) {
            sbCreate.append(" not null");
        }
    }

    @Override
    public String makeDropTableSql(String tableCode) {
        return "drop table " + tableCode;
    }

    @Override
    public String makeAddColumnSql(String tableCode, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        sbsql.append(" add column ");
        this.appendColumnSQL(column, sbsql);
        return sbsql.toString();
    }

    @Override
    public String makeDropColumnSql(String tableCode, String columnCode) {
        return "alter table " + tableCode + " drop COLUMN " + columnCode;
    }

    @Override
    public String makeRenameColumnSql(String tableCode, String columnCode, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        sbsql.append(" rename COLUMN ");
        sbsql.append(columnCode);
        sbsql.append(" to ");
        sbsql.append(column.getColumnName());
        return sbsql.toString();
    }

    @Override
    public List<String> makeReconfigurationColumnSqls(String tableCode, String columnCode, TableField column) {
        ArrayList<String> sqls = new ArrayList<String>();
        SimpleTableField tempColumn = new SimpleTableField();
        tempColumn.setColumnName(columnCode + "_1");
        sqls.add(this.makeRenameColumnSql(tableCode, columnCode, tempColumn));
        sqls.add(this.makeAddColumnSql(tableCode, column));
        sqls.add("update tableCode set " + column.getColumnName() + " = " + columnCode);
        sqls.add(this.makeDropColumnSql(tableCode, columnCode + "_1"));
        return sqls;
    }

    @Override
    public void createSequence(String sequenceName) throws SQLException {
        DatabaseAccess.doExecuteSql(this.conn, this.makeCreateSequenceSql(sequenceName));
    }

    @Override
    public void createTable(TableInfo tableInfo) throws SQLException {
        DatabaseAccess.doExecuteSql(this.conn, this.makeCreateTableSql(tableInfo));
    }

    @Override
    public void dropTable(String tableCode) throws SQLException {
        DatabaseAccess.doExecuteSql(this.conn, this.makeDropTableSql(tableCode));
    }

    @Override
    public void addColumn(String tableCode, TableField column) throws SQLException {
        DatabaseAccess.doExecuteSql(this.conn, this.makeAddColumnSql(tableCode, column));
    }

    @Override
    public void modifyColumn(String tableCode, TableField oldColumn, TableField column) throws SQLException {
        DatabaseAccess.doExecuteSql(this.conn, this.makeModifyColumnSql(tableCode, oldColumn, column));
    }

    @Override
    public void dropColumn(String tableCode, String columnCode) throws SQLException {
        DatabaseAccess.doExecuteSql(this.conn, this.makeDropColumnSql(tableCode, columnCode));
    }

    @Override
    public void renameColumn(String tableCode, String columnCode, TableField column) throws SQLException {
        DatabaseAccess.doExecuteSql(this.conn, this.makeRenameColumnSql(tableCode, columnCode, column));
    }

    @Override
    public void reconfigurationColumn(String tableCode, String columnCode, TableField column) throws SQLException {
        List<String> sqList = this.makeReconfigurationColumnSqls(tableCode, columnCode, column);
        if (sqList == null) {
            return;
        }
        for (String sql : sqList) {
            DatabaseAccess.doExecuteSql(this.conn, sql);
        }
    }
}

