/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.ddl;

import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.utils.QueryUtils;
import java.sql.Connection;
import org.apache.commons.lang3.StringUtils;

public class DB2DDLOperations
extends GeneralDDLOperations {
    public DB2DDLOperations() {
    }

    public DB2DDLOperations(Connection conn) {
        super(conn);
    }

    @Override
    public String makeCreateSequenceSql(String sequenceName) {
        return "CREATE SEQUENCE " + QueryUtils.cleanSqlStatement(sequenceName) + " AS INTEGER START WITH 1 INCREMENT BY 1";
    }

    @Override
    public String makeModifyColumnSql(String tableCode, TableField oldColumn, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        if (!StringUtils.equalsIgnoreCase((CharSequence)oldColumn.getColumnType(), (CharSequence)column.getColumnType()) || oldColumn.getMaxLength() != column.getMaxLength() || oldColumn.getPrecision() != column.getPrecision()) {
            sbsql.append(" alter column ").append(column.getColumnName()).append(" set data type ");
            this.appendColumnTypeSQL(column, sbsql);
        }
        if (oldColumn.isMandatory() != column.isMandatory()) {
            sbsql.append(" alter column ").append(column.getColumnName()).append(column.isMandatory() ? " set not null" : " drop not null");
        }
        return sbsql.toString();
    }
}

