/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.transaction;

import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DbcpConnectPools;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectThreadWrapper
implements Serializable {
    private final Map<DataSourceDescription, Connection> connectPools = new ConcurrentHashMap<DataSourceDescription, Connection>(4);

    public Connection fetchConnect(DataSourceDescription description) throws SQLException {
        Connection conn = this.connectPools.get(description);
        if (conn == null) {
            conn = DbcpConnectPools.getDbcpConnect((DataSourceDescription)description);
            this.connectPools.put(description, conn);
        }
        return conn;
    }

    public void commitAllWork() throws SQLException {
        if (this.connectPools.size() == 0) {
            return;
        }
        for (Connection conn : this.connectPools.values()) {
            conn.commit();
        }
    }

    public void rollbackAllWork() throws SQLException {
        if (this.connectPools.size() == 0) {
            return;
        }
        for (Connection conn : this.connectPools.values()) {
            conn.rollback();
        }
    }

    public void releaseAllConnect() {
        if (this.connectPools.size() == 0) {
            return;
        }
        for (Connection conn : this.connectPools.values()) {
            DbcpConnectPools.closeConnect((Connection)conn);
        }
        this.connectPools.clear();
    }
}

