package com.centit.tablestore.service;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.po.ProjectFollower;
import com.centit.tablestore.po.ProjectInfo;
import com.centit.tablestore.po.ProjectTeam;
import com.centit.tablestore.po.TableStruct;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

public interface ProjectInfoService {

    void createNewProject(ProjectInfo projectInfo);

    void updateProjectInfo(ProjectInfo projectInfo);

    void deleteProjectInfo(String projectId);

    ProjectInfo getProjectInfo(String projectId);

    JSONArray listUserProjects(String userCode, boolean onlyPublic, PageDesc pageDesc);

    JSONArray listFollowerProjects(String userCode, PageDesc pageDesc);

    Map<String, Object> getUserStatInfo(String userCode);

    JSONArray listUserCreateProjects(String userCode, PageDesc pageDesc);

    void addProjectMember(String optUser, String projectId, String memberCode);

    void deleteProjectMember(String optUser, String projectId, String memberCode);

    void addFollowerProject(ProjectFollower follower);

    void deleteFollowerProject(String optUser, String projectId);

    boolean hasFollowedProject(String projectId, String userCode);

    boolean checkMember(String projectId, String userCode);

    List<ProjectTeam> listProjectMember(String optUser, String projectId);

    ProjectInfo forkProject(CentitUserDetails userDetails, String projectId);

    String makeCreateSql(String projectId, DBType dbType);

    void mergeProjectTables(String projectId, CentitUserDetails ud, List<TableStruct> tableStructs);

    JSONObject exportProject(String projectId, DBType dbtype);

    InputStream exportProjectAsExcel(String projectId, DBType dbtype);
}
