package com.centit.tablestore.po;

import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.DBType;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

@Data
public class TableIndexInfo {
    String indexName;

    String indexType;// 索引类型 NORMAL、UNIQUE、BITMAP、HASH、FULLTEXT", //FBI IOT Cluster

    String indexComment;// "索引说明",

    List<String> indexFields; // 索引字段

    public String buildCreateIndexSql(String tableName, final DBType dbType){
        StringBuilder sqlBuilder = new StringBuilder();
        //TODO case indexType
        String it = StringUtils.isBlank(indexType)? "NORMAL" : indexType.toUpperCase();
        switch (it) {
            case "UNIQUE":
                sqlBuilder.append("create unique index ").append(indexName).append(" on \r\n  ")
                        .append(tableName).append(" (").append(
                                StringBaseOpt.objectToString(indexFields)).append(" )");
                break;
            case "BITMAP":
                if(dbType == DBType.Oracle) {
                    sqlBuilder.append("create bitmap index ").append(indexName).append(" on \r\n  ")
                            .append(tableName).append(" (").append(
                                    StringBaseOpt.objectToString(indexFields)).append(" )");
                } else {
                    sqlBuilder.append("-- 仅Oracle 支持 BITMAP 索引");
                }
                break;
            case "HASH":
                if(dbType == DBType.MySql) {
                    sqlBuilder.append("create index ").append(indexName).append(" using hash on \r\n  ")
                            .append(tableName).append(" (").append(
                                    StringBaseOpt.objectToString(indexFields)).append(" )");
                } else {
                    sqlBuilder.append("-- 仅MySQL 支持 HASH 索引");
                }
                break;
            case "FULLTEXT":
                if(dbType == DBType.MySql) {
                    sqlBuilder.append("create fulltext index ").append(indexName).append(" on \r\n  ")
                            .append(tableName).append(" (").append(
                                    StringBaseOpt.objectToString(indexFields)).append(" ) WITH PARSER ngram");
                } else {
                    sqlBuilder.append("-- 仅MySQL 支持 FULLTEXT 索引");
                }
                break;
            case "NORMAL":
            default:
                sqlBuilder.append("create index ").append(indexName).append(" on \r\n  ")
                    .append(tableName).append(" (").append(
                            StringBaseOpt.objectToString(indexFields)).append(" )");
            break;
        }

        return sqlBuilder.toString();
    }
}
