package com.centit.tablestore.po;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Id;

/**
 * 项目团队
 */
@Data
@Embeddable
public class ProjectTeamId implements java.io.Serializable {
    private static final long serialVersionUID = 1L;

    @Id
    @Column(name = "PROJECT_ID")
    @ApiModelProperty(value = "项目ID")
    private String projectId;

    //userCode
    @Id
    @Column(name = "PROJECT_MEMBER")
    @ApiModelProperty(value = "项目成员")
    private String projectMember;

    public ProjectTeamId() {
    }


    public ProjectTeamId(String projectId, String userCode) {
        this.projectId = projectId;
        this.projectMember = userCode;
    }
}
