package com.centit.tablestore.po;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Id;

/**
 * 项目团队
 */
@Data
@Embeddable
public class ProjectFollowerId implements java.io.Serializable {
    private static final long serialVersionUID = 1L;

    @Id
    @Column(name = "PROJECT_ID")
    @ApiModelProperty(value = "项目ID")
    private String projectId;

    //userCode
    @Id
    @Column(name = "PROJECT_FOLLOWER")
    @ApiModelProperty(value = "关注人员")
    private String projectFollower;

    public ProjectFollowerId() {
    }


    public ProjectFollowerId(String projectId, String userCode) {
        this.projectId = projectId;
        this.projectFollower = userCode;
    }
}
