package com.centit.tablestore.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.tablestore.po.ProjectFollower;
import com.centit.tablestore.po.ProjectFollowerId;
import org.springframework.stereotype.Repository;

import java.util.Map;

@Repository
public class ProjectFollowerDao extends BaseDaoImpl<ProjectFollower, ProjectFollowerId> {

    @Override
    public Map<String, String> getFilterField() {
            return null;
    }


    public boolean hasFollowed(String projectId, String userCode){
        return NumberBaseOpt.castObjectToInteger(
                DatabaseOptUtils.getScalarObjectQuery(this,
                        "select count(1) as projectSum from TS_PROJECT_FOLLOWER a " +
                                "where a.PROJECT_ID = ? and a.PROJECT_FOLLOWER = ?",
                        new Object[]{projectId, userCode}), 0) > 0;
    }
}
