/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryUtils;
import com.centit.tablestore.dao.ProjectInfoDao;
import com.centit.tablestore.dao.ProjectTeamDao;
import com.centit.tablestore.dao.TableStructDao;
import com.centit.tablestore.po.ProjectInfo;
import com.centit.tablestore.po.TableStruct;
import com.centit.tablestore.service.TableStructService;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tableStructService")
@Transactional
public class TableStructServiceImpl
implements TableStructService {
    @Autowired
    protected TableStructDao tableStructDao;
    @Autowired
    protected ProjectInfoDao projectInfoDao;
    @Autowired
    protected ProjectTeamDao projectTeamDao;

    @Override
    public void saveTableStruct(TableStruct tableStruct) {
        if (!this.projectTeamDao.checkMember(tableStruct.getProjectId(), tableStruct.getCreatorCode())) {
            throw new ObjectException(403, "\u7528\u6237 " + tableStruct.getCreatorCode() + " \u65e0\u6743\u64cd\u4f5c " + tableStruct.getProjectId() + " \u9879\u76ee\u3002");
        }
        if (this.tableStructDao.isTableExist(tableStruct.getProjectId(), tableStruct.getTableName())) {
            throw new ObjectException(611, "\u8868\u6216\u8005\u89c6\u56fe " + tableStruct.getTableName() + " \u5df2\u5b58\u5728\u3002");
        }
        this.tableStructDao.saveNewObject(tableStruct);
    }

    @Override
    public void updateTableStruct(TableStruct tableStruct) {
        TableStruct dbStruct = this.tableStructDao.getTableByName(tableStruct.getProjectId(), tableStruct.getTableName());
        if (dbStruct == null) {
            dbStruct = (TableStruct)this.tableStructDao.getObjectById(tableStruct.getTableId());
        }
        if (!StringUtils.equals((CharSequence)dbStruct.getTableId(), (CharSequence)tableStruct.getTableId())) {
            throw new ObjectException(611, "\u8868\u6216\u8005\u89c6\u56fe " + tableStruct.getTableName() + " \u5df2\u5b58\u5728\u3002");
        }
        this.tableStructDao.updateObject(tableStruct);
    }

    private List<SimpleTableField> findTableColumns(Map<String, List<SimpleTableField>> allTables, String tableName) {
        if (StringUtils.isBlank((CharSequence)tableName)) {
            if (allTables.size() == 1) {
                return allTables.values().iterator().next();
            }
            return null;
        }
        return allTables.get(tableName.toUpperCase());
    }

    private SimpleTableField searchTableColumn(Map<String, List<SimpleTableField>> allTables, String tableName, String columnName) {
        List<SimpleTableField> columns = this.findTableColumns(allTables, tableName);
        if (columns != null) {
            return this.findTableColumn(columns, columnName);
        }
        for (List<SimpleTableField> cols : allTables.values()) {
            SimpleTableField column = this.findTableColumn(cols, columnName);
            if (column == null) continue;
            return column;
        }
        return null;
    }

    private SimpleTableField findTableColumn(List<SimpleTableField> columns, String columnName) {
        for (SimpleTableField column : columns) {
            if (!StringUtils.equalsAnyIgnoreCase((CharSequence)columnName, (CharSequence[])new CharSequence[]{column.getColumnName()})) continue;
            return column;
        }
        return null;
    }

    @Override
    public TableStruct updateViewSql(TableStruct tableStruct) {
        String viewSql = tableStruct.extraViewSql();
        List oldColumns = tableStruct.toTableInfo(DBType.MySql).getColumns();
        Pair viewQueryStruct = QueryUtils.extraFieldAndTable((String)viewSql);
        if (viewQueryStruct == null || viewQueryStruct.getLeft() == null || viewQueryStruct.getRight() == null) {
            return tableStruct;
        }
        HashMap<String, List<SimpleTableField>> fromTables = new HashMap<String, List<SimpleTableField>>();
        for (Map.Entry table : ((Map)viewQueryStruct.getRight()).entrySet()) {
            TableStruct struct = this.tableStructDao.getTableByName(tableStruct.getProjectId(), (String)table.getKey());
            if (struct == null || struct.getMetadataJson() == null) continue;
            fromTables.put(((String)table.getValue()).toUpperCase(), struct.toTableInfo(DBType.MySql).getColumns());
        }
        LinkedHashMap<Object, SimpleTableField> newColumns = new LinkedHashMap<Object, SimpleTableField>();
        for (Pair field : (List)viewQueryStruct.getLeft()) {
            String fieldFormula;
            String tableName;
            String fileDesc = (String)field.getValue();
            int n = fileDesc.indexOf(46);
            if (n > 0) {
                tableName = fileDesc.substring(0, n).trim();
                fieldFormula = fileDesc.substring(n + 1).trim();
            } else {
                tableName = "";
                fieldFormula = fileDesc;
            }
            if ("*".equals(fieldFormula)) {
                List<SimpleTableField> tableColumns = this.findTableColumns(fromTables, tableName);
                if (tableColumns == null || tableColumns.size() <= 0) continue;
                for (SimpleTableField field1 : tableColumns) {
                    SimpleTableField oldViewCol = this.findTableColumn(oldColumns, field1.getColumnName());
                    SimpleTableField column = new SimpleTableField();
                    if (oldViewCol != null) {
                        BeanUtils.copyProperties((Object)oldViewCol, (Object)column);
                    } else {
                        BeanUtils.copyProperties((Object)field1, (Object)column);
                    }
                    newColumns.put(field1.getColumnName(), column);
                }
                continue;
            }
            SimpleTableField column = new SimpleTableField();
            SimpleTableField oldViewCol = this.findTableColumn(oldColumns, (String)field.getKey());
            if (oldViewCol != null) {
                BeanUtils.copyProperties((Object)oldViewCol, (Object)column);
            } else {
                SimpleTableField tempCol = this.searchTableColumn(fromTables, tableName, fieldFormula);
                if (tempCol != null) {
                    BeanUtils.copyProperties((Object)tempCol, (Object)column);
                }
            }
            column.setColumnName((String)field.getKey());
            column.setColumnComment(fileDesc);
            newColumns.put(field.getKey(), column);
        }
        tableStruct.setTableColumns(newColumns.values());
        return tableStruct;
    }

    @Override
    public TableStruct updateFromSql(TableStruct tableStruct) {
        String createSql = tableStruct.extraCreateSql();
        if (StringUtils.isBlank((CharSequence)createSql)) {
            return tableStruct;
        }
        SimpleTableInfo tableInfo = GeneralDDLOperations.parseDDL((String)createSql);
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getTableName())) {
            tableStruct.setTableName(tableInfo.getTableName());
        }
        SimpleTableInfo table = tableStruct.toTableInfo(DBType.MySql);
        for (SimpleTableField column : tableInfo.getColumns()) {
            SimpleTableField col = table.findFieldByColumn(column.getColumnName());
            if (col != null) {
                col.setFieldLabelName(column.getFieldLabelName());
                col.setColumnComment(column.getColumnComment());
                col.setColumnType(column.getColumnType());
                col.setMaxLength(column.getMaxLength().intValue());
                col.setScale(column.getScale());
                col.setMandatory(column.isMandatory());
                col.setPrimaryKey(column.isPrimaryKey());
                col.setDefaultValue(col.getDefaultValue());
                continue;
            }
            table.addColumn(column);
        }
        tableStruct.setTableColumns(table.getColumns());
        return tableStruct;
    }

    @Override
    public void deleteTableStruct(String tableId) {
        this.tableStructDao.deleteObjectById(tableId);
    }

    @Override
    public TableStruct getTableStruct(String tableId) {
        return (TableStruct)this.tableStructDao.getObjectById(tableId);
    }

    @Override
    public TableStruct forkTable(CentitUserDetails userDetails, String tableId, String projectId) {
        if (!this.projectTeamDao.checkMember(projectId, userDetails.getUserCode())) {
            throw new ObjectException(403, "\u7528\u6237 " + userDetails.getUserCode() + " \u65e0\u6743\u64cd\u4f5c " + projectId + " \u9879\u76ee\u3002");
        }
        TableStruct ts = (TableStruct)this.tableStructDao.getObjectById(tableId);
        if (ts == null) {
            throw new ObjectException(611, "\u8868 " + tableId + " \u4e0d\u5b58\u5728\u3002");
        }
        ProjectInfo projectInfo = (ProjectInfo)this.projectInfoDao.getObjectById(ts.getProjectId());
        projectInfo.setTableForkedTimes(projectInfo.getTableForkedTimes() + 1L);
        this.projectInfoDao.updateSortScore(projectInfo, 0);
        ts.setTableId(UuidOpt.getUuidAsString22());
        ts.setCreatorCode(userDetails.getUserCode());
        ts.setCreatorName(userDetails.getUserInfo().getUserName());
        return this.tableStructDao.mergeTable(ts, projectId);
    }

    @Override
    public List<TableStruct> listProjectTables(String projectId, Map<String, Object> filterMap, PageDesc pageDesc) {
        filterMap.put("projectId", projectId);
        return this.tableStructDao.listObjectsByProperties(filterMap, pageDesc);
    }

    @Override
    public JSONArray statTables(String keyWord) {
        return this.tableStructDao.statTables(keyWord);
    }

    @Override
    public JSONArray searchTables(String keyWord, String industryCategory, PageDesc pageDesc) {
        return this.tableStructDao.searchTables(keyWord, industryCategory, pageDesc);
    }

    @Override
    public String makeCreateSql(String tableId, DBType dbType) {
        TableStruct ts = (TableStruct)this.tableStructDao.getObjectById(tableId);
        if (ts == null) {
            return null;
        }
        return ts.buildCreateTableSql(dbType);
    }
}

