/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.DBType;
import com.centit.support.file.FileIOOpt;
import com.centit.support.report.ExcelReportUtil;
import com.centit.tablestore.dao.ProjectInfoDao;
import com.centit.tablestore.dao.ProjectModuleDao;
import com.centit.tablestore.dao.ProjectTeamDao;
import com.centit.tablestore.dao.TableStructDao;
import com.centit.tablestore.po.ProjectInfo;
import com.centit.tablestore.po.ProjectModule;
import com.centit.tablestore.po.TableStruct;
import com.centit.tablestore.service.ProjectModuleService;
import com.centit.tablestore.service.impl.ProjectInfoServiceImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="projectModuleService")
@Transactional
public class ProjectModuleServiceImpl
implements ProjectModuleService {
    @Autowired
    protected ProjectModuleDao projectModuleDao;
    @Autowired
    protected ProjectInfoDao projectInfoDao;
    @Autowired
    protected TableStructDao tableStructDao;
    @Autowired
    protected ProjectTeamDao projectTeamDao;

    @Override
    public void saveProjectModule(ProjectModule projectModule) {
        this.projectModuleDao.saveNewObject(projectModule);
    }

    @Override
    public void updateProjectModule(ProjectModule projectModule) {
        this.projectModuleDao.updateObject(projectModule);
    }

    @Override
    public void deleteProjectModule(String moduleId) {
        this.projectModuleDao.deleteObjectById(moduleId);
    }

    @Override
    public ProjectModule getProjectModule(String moduleId) {
        return (ProjectModule)this.projectModuleDao.getObjectById(moduleId);
    }

    @Override
    public List<ProjectModule> listProjectModules(String projectId) {
        return this.projectModuleDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"projectId", projectId}));
    }

    @Override
    public List<TableStruct> listModuleTables(String moduleId) {
        Object views;
        ProjectModule pm = (ProjectModule)this.projectModuleDao.getObjectById(moduleId);
        if (pm == null || pm.getModuleDesign() == null) {
            return null;
        }
        Object tables = pm.getModuleDesign().get("tables");
        ArrayList<String> tableIds = new ArrayList<String>(64);
        if (tables instanceof List) {
            for (Object table : (List)tables) {
                String oldTalbeId;
                Map tableMap;
                Object tableInfo;
                if (!(table instanceof Map) || !((tableInfo = (tableMap = (Map)table).get("info")) instanceof JSONObject) || !StringUtils.isNotBlank((CharSequence)(oldTalbeId = StringBaseOpt.castObjectToString((Object)((JSONObject)tableInfo).get("tableId"))))) continue;
                tableIds.add(oldTalbeId);
            }
        }
        if ((views = pm.getModuleDesign().get("views")) instanceof List) {
            for (Object view : (List)views) {
                String oldTalbeId;
                Map viewMap;
                Object viewInfo;
                if (!(view instanceof Map) || !((viewInfo = (viewMap = (Map)view).get("info")) instanceof JSONObject) || !StringUtils.isNotBlank((CharSequence)(oldTalbeId = StringBaseOpt.castObjectToString((Object)((JSONObject)viewInfo).get("viewId"))))) continue;
                tableIds.add(oldTalbeId);
            }
        }
        if (tableIds.size() > 0) {
            return this.tableStructDao.listTablesByIds(tableIds);
        }
        return null;
    }

    @Override
    public ProjectModule forkModule(CentitUserDetails userDetails, String moduleId, String projectId) {
        String userCode = userDetails.getUserCode();
        String userName = userDetails.getUserInfo().getUserName();
        if (!this.projectTeamDao.checkMember(projectId, userCode)) {
            throw new ObjectException(403, "\u7528\u6237 " + userCode + " \u65e0\u6743\u64cd\u4f5c " + projectId + " \u9879\u76ee\u3002");
        }
        ProjectModule pm = (ProjectModule)this.projectModuleDao.getObjectById(moduleId);
        ProjectInfo projectInfo = (ProjectInfo)this.projectInfoDao.getObjectById(pm.getProjectId());
        projectInfo.setTableForkedTimes(projectInfo.getTableForkedTimes() + 2L);
        this.projectInfoDao.updateSortScore(projectInfo, 0);
        pm.setModuleId(UuidOpt.getUuidAsString22());
        pm.setProjectId(projectId);
        pm.setCreatorCode(userCode);
        JSONObject moduleDesign = pm.getModuleDesign();
        if (moduleDesign != null) {
            Object views;
            Object tables = moduleDesign.get("tables");
            if (tables instanceof List) {
                for (Object table : (List)tables) {
                    Map tableMap;
                    Object tableInfo;
                    if (!(table instanceof Map) || !((tableInfo = (tableMap = (Map)table).get("info")) instanceof JSONObject)) continue;
                    String oldTalbeId = StringBaseOpt.castObjectToString((Object)((JSONObject)tableInfo).get("tableId"));
                    String newTableId = UuidOpt.getUuidAsString22();
                    TableStruct ts = (TableStruct)this.tableStructDao.getObjectById(oldTalbeId);
                    if (ts != null) {
                        ts.setTableId(newTableId);
                        ts.setCreatorCode(userCode);
                        ts.setCreatorName(userName);
                        this.tableStructDao.mergeTable(ts, projectId);
                    }
                    ((JSONObject)tableInfo).put((Object)"tableId", (Object)newTableId);
                }
            }
            if ((views = moduleDesign.get("views")) instanceof List) {
                for (Object view : (List)views) {
                    Map viewMap;
                    Object viewInfo;
                    if (!(view instanceof Map) || !((viewInfo = (viewMap = (Map)view).get("info")) instanceof JSONObject)) continue;
                    String oldTalbeId = StringBaseOpt.castObjectToString((Object)((JSONObject)viewInfo).get("viewId"));
                    String newTableId = UuidOpt.getUuidAsString22();
                    TableStruct ts = (TableStruct)this.tableStructDao.getObjectById(oldTalbeId);
                    if (ts != null) {
                        ts.setTableId(newTableId);
                        ts.setCreatorCode(userCode);
                        ts.setCreatorName(userName);
                        this.tableStructDao.mergeTable(ts, projectId);
                    }
                    ((JSONObject)viewInfo).put((Object)"viewId", (Object)newTableId);
                }
            }
        }
        this.projectModuleDao.saveNewObject(pm);
        return pm;
    }

    @Override
    public String makeCreateSql(String moduleId, DBType dbType) {
        ProjectModule module = (ProjectModule)this.projectModuleDao.getObjectById(moduleId);
        List<String> tables = module.extraReferenceTables("VT");
        StringBuilder sqlBuilder = new StringBuilder("/*==========================================*/\r\n/* Created on:   ").append(DatetimeOpt.currentDatetime()).append("                        */\r\n/*==========================================*/\r\n");
        StringBuilder viewSqlBuilder = new StringBuilder();
        if (tables != null) {
            for (String ts : tables) {
                TableStruct struct = (TableStruct)this.tableStructDao.getObjectById(ts);
                if (struct == null) continue;
                if ("V".equals(struct.getTableType())) {
                    viewSqlBuilder.append("/*===  ").append(struct.getTableLabelName()).append("  =======*/\r\n").append(struct.buildCreateTableSql(dbType)).append("\r\n\r\n");
                    continue;
                }
                sqlBuilder.append("/*===  ").append(struct.getTableLabelName()).append("  =======*/\r\n").append(struct.buildCreateTableSql(dbType)).append("\r\n\r\n");
            }
        }
        sqlBuilder.append((CharSequence)viewSqlBuilder);
        return sqlBuilder.toString();
    }

    @Override
    public JSONObject exportModule(String moduleId, DBType dbtype) {
        ProjectModule module = (ProjectModule)this.projectModuleDao.getObjectById(moduleId);
        if (module == null) {
            return null;
        }
        JSONObject project = new JSONObject();
        project.put((Object)"projectInfo", (Object)this.projectInfoDao.getObjectById(module.getProjectId()));
        JSONArray jaModules = new JSONArray();
        jaModules.add((Object)module.toModuleJson());
        project.put((Object)"modules", (Object)jaModules);
        List<String> tables = module.extraReferenceTables("VT");
        if (tables != null && tables.size() > 0) {
            JSONArray jaTables = new JSONArray();
            for (String ts : tables) {
                TableStruct table = (TableStruct)this.tableStructDao.getObjectById(ts);
                if (table == null) continue;
                table.mapColumnsType(dbtype);
                jaTables.add((Object)table.toTableJson());
            }
            project.put((Object)"tables", (Object)jaTables);
        }
        return project;
    }

    @Override
    public InputStream exportModuleAsExcel(String moduleId, DBType dbtype) {
        try {
            JSONObject jsonModule = this.exportModule(moduleId, dbtype);
            InputStream inputStream = ProjectInfoServiceImpl.class.getResourceAsStream("/template/tables.xlsx");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ExcelReportUtil.exportExcel((InputStream)inputStream, (OutputStream)byteArrayOutputStream, (Map)jsonModule);
            return FileIOOpt.castObjectToInputStream((Object)byteArrayOutputStream);
        }
        catch (IOException e) {
            return null;
        }
    }
}

