/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.controller;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.po.ProjectInfo;
import com.centit.tablestore.po.TableStruct;
import com.centit.tablestore.service.TableStructService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u8868\u7ed3\u6784\u7ef4\u62a4\u63a5\u53e3", tags={"\u8868\u7ed3\u6784\u7ef4\u62a4\u63a5\u53e3"})
@RestController
@RequestMapping(value={"table"})
public class TableController
extends BaseController {
    @Autowired
    protected TableStructService tableStructService;

    @ApiOperation(value="\u83b7\u53d6\u9879\u76ee\u6240\u6709\u8868", notes="\u83b7\u53d6\u9879\u76ee\u6240\u6709\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class), @ApiImplicitParam(name="projectId", type="path", value="\u8868\u7ed3\u6784ID")})
    @GetMapping(value={"/list/{projectId}"})
    @WrapUpResponseBody
    public PageQueryResult<TableStruct> list(@PathVariable String projectId, PageDesc pageDesc, HttpServletRequest request) {
        Map filterMap = TableController.collectRequestParameters((HttpServletRequest)request);
        List<TableStruct> objs = this.tableStructService.listProjectTables(projectId, filterMap, pageDesc);
        return PageQueryResult.createResult(objs, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u8868")
    @ApiImplicitParam(name="tableId", type="path", value="\u8868\u7ed3\u6784ID")
    @GetMapping(value={"/{tableId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public TableStruct getTableStruct(@PathVariable String tableId) {
        return this.tableStructService.getTableStruct(tableId);
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u8868\u7ed3\u6784", notes="\u5220\u9664\u5355\u4e2a\u8868\u7ed3\u6784\uff0c\u4e0d\u4f1a\u5220\u9664\u8868")
    @ApiImplicitParam(name="tableId", type="path", value="\u8868\u7ed3\u6784ID")
    @DeleteMapping(value={"/{tableId}"})
    @WrapUpResponseBody
    public void deleteTableStruct(@PathVariable String tableId) {
        this.tableStructService.deleteTableStruct(tableId);
    }

    @ApiOperation(value="\u65b0\u5efa\u8868\u7ed3\u6784\u6570\u636e")
    @PostMapping
    @WrapUpResponseBody
    public TableStruct saveTableStruct(@RequestBody TableStruct tableStruct, HttpServletRequest request) {
        CentitUserDetails ud = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (ud == null) {
            throw new ObjectException(403, "Session\u8fc7\u671f\u6216\u8005\u7528\u6237\u6ca1\u6709\u767b\u5f55\u3002");
        }
        tableStruct.setCreatorCode(ud.getUserCode());
        tableStruct.setCreatorName(ud.getUserInfo().getUserName());
        this.tableStructService.saveTableStruct(tableStruct);
        return tableStruct;
    }

    @ApiOperation(value="\u65b0\u5efa\u8868\u7ed3\u6784\u6570\u636e")
    @PostMapping(value={"/updateViewSql"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public TableStruct updateViewSql(@RequestBody TableStruct tableStruct) {
        return this.tableStructService.updateViewSql(tableStruct);
    }

    @ApiOperation(value="\u4fee\u6539\u8868\u7ed3\u6784\u6570\u636e")
    @PutMapping
    @WrapUpResponseBody
    public void updateTableStruct(@RequestBody TableStruct TableStruct2) {
        this.tableStructService.updateTableStruct(TableStruct2);
    }

    @ApiOperation(value="\u6839\u636e\u521b\u5efa\u8868\u7684sql\u8bed\u53e5\u5bfc\u5165\u5b57\u6bb5")
    @PostMapping(value={"/updateFromSql"})
    @WrapUpResponseBody
    public TableStruct addColumnFromSql(@RequestBody TableStruct TableStruct2) {
        return this.tableStructService.updateFromSql(TableStruct2);
    }

    @ApiOperation(value="fork\u8868\u7ed3\u6784\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", type="path", value="\u8868\u7ed3\u6784ID"), @ApiImplicitParam(name="projectId", type="path", value="\u76ee\u6807\u9879\u76eeID\uff0c\u5fc5\u987b\u662f\u5f53\u524d\u7528\u6237\u53ef\u4ee5\u64cd\u4f5c\u7684\u9879\u76ee")})
    @PostMapping(value={"/fork/{tableId}/{projectId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public TableStruct forkTableInfo(@PathVariable String tableId, @PathVariable String projectId, HttpServletRequest request) {
        CentitUserDetails ud = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (ud == null) {
            throw new ObjectException(403, "Session\u8fc7\u671f\u6216\u8005\u7528\u6237\u6ca1\u6709\u767b\u5f55\u3002");
        }
        return this.tableStructService.forkTable(ud, tableId, projectId);
    }

    @ApiOperation(value="\u751f\u6210\u521b\u5efa\u8868\u7ed3\u6784\u7684\u811a\u672c", notes="\u751f\u6210\u521b\u5efa\u8868\u7ed3\u6784\u7684\u811a\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", type="path", value="\u8868\u7ed3\u6784ID"), @ApiImplicitParam(name="dbtype", type="query", value="\u6570\u636e\u7c7b\u522b")})
    @GetMapping(value={"/sql/{tableId}"})
    @WrapUpResponseBody
    public String createSql(@PathVariable String tableId, String dbtype) {
        return this.tableStructService.makeCreateSql(tableId, DBType.mapDBType((String)dbtype, (DBType)DBType.MySql));
    }

    @ApiOperation(value="\u5168\u6587\u68c0\u7d22\u8868", notes="\u5168\u6587\u68c0\u7d22\u8868\u3001\u7528\u4e8e\u9996\u9875\u7684\u68c0\u7d22")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class), @ApiImplicitParam(name="keywords", type="query", value="\u8868\u7ed3\u6784ID"), @ApiImplicitParam(name="catalog", type="query", value="\u8868\u7ed3\u6784ID")})
    @GetMapping(value={"/search"})
    @WrapUpResponseBody
    public PageQueryResult<Object> search(String keywords, String catalog, PageDesc pageDesc) {
        JSONArray objs = this.tableStructService.searchTables(keywords, catalog, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)objs, (PageDesc)pageDesc, (Class[])new Class[]{TableStruct.class});
    }

    @ApiOperation(value="\u68c0\u7d22\u8868\u7edf\u8ba1\u4fe1\u606f", notes="\u5168\u6587\u68c0\u7d22\u8868\u53ea\u8fd4\u56de\u7edf\u8ba1\u4fe1\u606f\uff0c\u7528\u4e8e\u641c\u7d22\u7ed3\u679c\u5206\u7c7b")
    @ApiImplicitParam(name="keywords", type="query", value="\u8868\u7ed3\u6784ID")
    @GetMapping(value={"/stat"})
    @WrapUpResponseBody
    public JSONArray stat(String keywords) {
        JSONArray objs = this.tableStructService.statTables(keywords);
        return DictionaryMapUtils.mapJsonArray((JSONArray)objs, (Class[])new Class[]{ProjectInfo.class});
    }
}

