/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.controller;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.po.ProjectHistory;
import com.centit.tablestore.service.ProjectHistoryService;
import com.centit.tablestore.service.ProjectInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5386\u53f2\u7248\u672c\u7ba1\u7406", tags={"\u5386\u53f2\u7248\u672c\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/history"})
public class ProjectHistoryController
extends BaseController {
    @Autowired
    private ProjectHistoryService projectHistoryService;
    @Autowired
    protected ProjectInfoService projectInfoService;

    @ApiOperation(value="\u65b0\u589e\u7248\u672c\u4fe1\u606f; \u5b58\u50a8\u5f53\u524d\u7248\u672c\uff01")
    @ApiImplicitParam(name="includeContent", type="query", value="\u662f\u5426\u5df2\u5305\u542b\u5185\u5bb9\u4fe1\u606f")
    @PostMapping
    @WrapUpResponseBody
    public String createHistoryVersion(@RequestBody ProjectHistory historyVersion, String includeContent) {
        if (!BooleanBaseOpt.castObjectToBoolean((Object)includeContent, (Boolean)false).booleanValue()) {
            JSONObject jsonObject = this.projectInfoService.exportProject(historyVersion.getProjectId(), DBType.MySql);
            historyVersion.setStructContent(jsonObject);
        }
        this.projectHistoryService.saveProjectHistory(historyVersion);
        return historyVersion.getHistoryId();
    }

    @ApiOperation(value="\u4fee\u6539\u7248\u672c\u4fe1\u606f")
    @PutMapping
    @WrapUpResponseBody
    public void updateHistory(@RequestBody ProjectHistory historyVersion) {
        this.projectHistoryService.updateProjectHistory(historyVersion);
    }

    @ApiOperation(value="\u5220\u9664\u7248\u672c\u4fe1\u606f")
    @DeleteMapping(value={"/{historyId}"})
    @WrapUpResponseBody
    public void deleteHistory(@PathVariable String historyId) {
        this.projectHistoryService.deleteProjectHistory(historyId);
    }

    @ApiOperation(value="\u67e5\u8be2\u7248\u672c\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/list"})
    @WrapUpResponseBody
    public PageQueryResult<ProjectHistory> listHistory(HttpServletRequest request, PageDesc pageDesc) {
        List<ProjectHistory> list = this.projectHistoryService.listProjectHistory(BaseController.collectRequestParameters((HttpServletRequest)request), pageDesc);
        return PageQueryResult.createResult(list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u7248\u672c\u4fe1\u606f")
    @GetMapping(value={"/{historyId}"})
    @WrapUpResponseBody
    public ProjectHistory getHistory(@PathVariable String historyId) {
        return this.projectHistoryService.getProjectHistory(historyId);
    }

    @ApiOperation(value="\u56de\u9000\u5230\u67d0\u4e2a\u5177\u4f53\u7684\u7248\u672c")
    @PostMapping(value={"/restore"})
    @WrapUpResponseBody
    public void restoreHistoryVersion(@RequestBody ProjectHistory historyVersion, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(403, "Session\u8fc7\u671f\u6216\u8005\u7528\u6237\u6ca1\u6709\u767b\u5f55\u3002");
        }
        this.projectHistoryService.restoreProjectHistory(historyVersion.getHistoryId(), userCode);
    }

    @ApiOperation(value="\u5bfc\u51fa\u5386\u53f2\u8868\u7ed3\u6784\u4fe1\u606f", notes="\u5bfc\u51fa\u5386\u53f2\u8868\u7ed3\u6784\u4fe1\u606f")
    @ApiImplicitParam(name="historyId", type="path", value="\u5386\u53f2\u7248\u672cID")
    @GetMapping(value={"/export/{historyId}"})
    public void exportProject(@PathVariable String historyId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ProjectHistory historyInfo = this.projectHistoryService.getProjectHistory(historyId);
        if (historyInfo == null) {
            throw new ObjectException(604, "\u5386\u53f2\u7248\u672c\uff1a" + historyId + " \u4e0d\u5b58\u5728\uff01");
        }
        JSONObject json = historyInfo.getStructContent();
        String fileName = historyInfo.getHistoryLabel() + ".json";
        ByteArrayInputStream bis = new ByteArrayInputStream(json.toJSONString(new JSONWriter.Feature[0]).getBytes(StandardCharsets.UTF_8));
        UploadDownloadUtils.downloadFile((InputStream)bis, (String)fileName, (HttpServletRequest)request, (HttpServletResponse)response);
    }
}

