/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.task;

import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileTaskInfo;
import com.centit.fileserver.common.FileTaskOpeator;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.pretreat.FilePretreatUtils;
import com.centit.fileserver.service.FileInfoManager;
import com.centit.fileserver.task.FileStoreOpt;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.file.FileMD5Maker;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PdfWatermarkOpt
extends FileStoreOpt
implements FileTaskOpeator {
    private static final Logger logger = LoggerFactory.getLogger(PdfWatermarkOpt.class);
    @Autowired
    private FileInfoManager fileInfoManager;

    public String getOpeatorName() {
        return "watermark";
    }

    public FileTaskInfo attachTaskInfo(FileInfo fileInfo, long fileSize, Map<String, Object> pretreatInfo) {
        if (StringUtils.isNotBlank((CharSequence)StringBaseOpt.castObjectToString((Object)pretreatInfo.get("watermark")))) {
            FileTaskInfo taskInfo = new FileTaskInfo(this.getOpeatorName());
            taskInfo.copy((FileBaseInfo)fileInfo);
            taskInfo.setFileSize(Long.valueOf(fileSize));
            taskInfo.putOptParam("watermark", (Object)StringBaseOpt.castObjectToString((Object)pretreatInfo.get("watermark")));
            return taskInfo;
        }
        return null;
    }

    private void doWatermark(FileInfo fileInfo, long fileSize, Map<String, Object> pretreatInfo) {
        String originalTempFilePath = SystemTempFileUtils.getTempFilePath((String)fileInfo.getFileMd5(), (long)fileSize);
        try {
            String waterMarkPdfTempFile = FilePretreatUtils.addWatermarkForPdf(fileInfo, originalTempFilePath, pretreatInfo);
            if (null != waterMarkPdfTempFile) {
                File waterMarkPdfFile = new File(waterMarkPdfTempFile);
                String waterMarkFileMd5 = FileMD5Maker.makeFileMD5((File)waterMarkPdfFile);
                fileInfo.setAttachedFileMd5(waterMarkFileMd5);
                fileInfo.setAttachedType("pdf");
                FileInfo pdfFileInfo = new FileInfo();
                pdfFileInfo.copy((Object)fileInfo);
                pdfFileInfo.setFileMd5(waterMarkFileMd5);
                this.save(waterMarkPdfTempFile, pdfFileInfo, new File(waterMarkPdfTempFile).length());
                this.fileInfoManager.updateObject((Serializable)fileInfo);
                logger.info("\u6dfb\u52a0\u6c34\u5370\u5b8c\u6210");
            }
        }
        catch (IOException e) {
            logger.error("\u6dfb\u52a0\u6c34\u5370\u51fa\u9519\uff01", (Throwable)e);
        }
    }

    public int runTaskInfo(FileInfo fileInfo, long fileSize, Map<String, Object> pretreatInfo) {
        String waterMarkStr = StringBaseOpt.castObjectToString((Object)pretreatInfo.get("watermark"));
        if (StringUtils.isNotBlank((CharSequence)waterMarkStr) && StringUtils.equalsAnyIgnoreCase((CharSequence)fileInfo.getFileType(), (CharSequence[])new CharSequence[]{"pdf"})) {
            this.doWatermark(fileInfo, fileSize, pretreatInfo);
            return 1;
        }
        return 0;
    }

    public void doFileTask(FileTaskInfo fileOptTaskInfo) {
        String fileId = fileOptTaskInfo.getFileId();
        long fileSize = fileOptTaskInfo.getFileSize();
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        this.doWatermark(fileInfo, fileSize, fileOptTaskInfo.getTaskOptParams());
    }
}

