/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.service.impl;

import com.centit.fileserver.dao.FileUploadAuthorizedDao;
import com.centit.fileserver.po.FileUploadAuthorized;
import com.centit.fileserver.service.FileUploadAuthorizedManager;
import com.centit.framework.jdbc.service.BaseEntityManagerImpl;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.UuidOpt;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FileUploadAuthorizedManagerImpl
extends BaseEntityManagerImpl<FileUploadAuthorized, String, FileUploadAuthorizedDao>
implements FileUploadAuthorizedManager {
    @Autowired
    @NotNull
    protected void setBaseDao(FileUploadAuthorizedDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public int checkAuthorization(String uploadToken) {
        if (StringUtils.isBlank((CharSequence)uploadToken)) {
            return -1;
        }
        FileUploadAuthorized authorized = (FileUploadAuthorized)((FileUploadAuthorizedDao)this.baseDao).getObjectById(uploadToken);
        if (authorized == null) {
            return -1;
        }
        return authorized.getRestUploadFiles();
    }

    @Override
    @Transactional
    public FileUploadAuthorized createNewAuthorization(int maxUploadFiles) {
        FileUploadAuthorized authorized = new FileUploadAuthorized();
        authorized.setUploadToken(UuidOpt.getUuidAsString32());
        authorized.setMaxUploadFiles(maxUploadFiles);
        authorized.setRestUploadFiles(maxUploadFiles);
        authorized.setCraeteTime(DatetimeOpt.currentUtilDate());
        ((FileUploadAuthorizedDao)this.baseDao).saveNewObject(authorized);
        return authorized;
    }

    @Override
    @Transactional
    public int consumeAuthorization(String uploadToken) {
        if (StringUtils.isBlank((CharSequence)uploadToken)) {
            return -1;
        }
        FileUploadAuthorized authorized = (FileUploadAuthorized)((FileUploadAuthorizedDao)this.baseDao).getObjectById(uploadToken);
        if (authorized == null) {
            return -1;
        }
        authorized.setRestUploadFiles(authorized.getRestUploadFiles() - 1);
        authorized.setLastUploadTime(DatetimeOpt.currentUtilDate());
        ((FileUploadAuthorizedDao)this.baseDao).updateObject(authorized);
        return authorized.getRestUploadFiles();
    }
}

