/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.service.impl;

import com.alibaba.fastjson2.JSONObject;
import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileInfoOpt;
import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.po.FileStoreInfo;
import com.centit.fileserver.service.FileInfoManager;
import com.centit.fileserver.service.FileStoreInfoManager;
import com.centit.fileserver.task.FileOptTaskExecutor;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.search.document.FileDocument;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESIndexer;
import com.centit.search.service.IndexerSearcherFactory;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileMD5Maker;
import com.centit.support.file.FileSystemOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="fileInfoOpt")
public class FileInfoOptServerImpl
implements FileInfoOpt {
    protected Logger logger = LoggerFactory.getLogger(FileInfoOptServerImpl.class);
    @Value(value="${fileserver.pretreatment.sync:true}")
    protected boolean pretreatmentAsSync;
    @Autowired
    protected FileInfoManager fileInfoManager;
    @Autowired
    private FileStoreInfoManager fileStoreInfoManager;
    @Autowired
    FileOptTaskExecutor fileOptTaskExecutor;
    @Autowired
    FileStore fileStore;
    @Autowired(required=false)
    private ESServerConfig esServerConfig;

    public ESIndexer fetchDocumentIndexer() {
        if (this.esServerConfig == null) {
            return null;
        }
        return IndexerSearcherFactory.obtainIndexer((ESServerConfig)this.esServerConfig, FileDocument.class);
    }

    public String saveFile(FileBaseInfo fileBaseInfo, long fileSize, InputStream is) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.copy((Object)fileBaseInfo);
        JSONObject pretreatInfo = JSONObject.from((Object)fileInfo);
        FileSystemOpt.createDirect((String)SystemTempFileUtils.getTempDirectory());
        String tempFilePath = SystemTempFileUtils.getRandomTempFilePath();
        try {
            if (FileSystemOpt.existFile((String)tempFilePath)) {
                FileSystemOpt.deleteFile((String)tempFilePath);
            }
            fileSize = FileIOOpt.writeInputStreamToFile((InputStream)is, (String)tempFilePath);
            File tempFile = new File(tempFilePath);
            String fileMd5 = FileMD5Maker.makeFileMD5((File)tempFile);
            boolean isValid = fileSize != 0L;
            String renamePath = SystemTempFileUtils.getTempFilePath((String)fileMd5, (long)fileSize);
            tempFile.renameTo(new File(renamePath));
            if (isValid && !StringUtils.isBlank((CharSequence)fileInfo.getFileName())) {
                FileInfo dbFile;
                fileInfo.setFileMd5(fileMd5);
                String fileName = fileInfo.getFileName();
                if (!Charset.forName("GBK").newEncoder().canEncode(fileName)) {
                    fileName = new String(fileName.getBytes("iso-8859-1"), "utf-8");
                }
                fileInfo.setFileSize(fileSize);
                fileInfo.setFileName(fileName);
                fileInfo.setFileMd5(fileMd5);
                if (fileInfo.getFileId() == null) {
                    fileInfo.setFileId(UuidOpt.getUuidAsString());
                }
                if ((dbFile = this.fileInfoManager.getDuplicateFile(fileInfo)) == null) {
                    this.fileInfoManager.saveNewObject((Serializable)fileInfo);
                    String fileId = fileInfo.getFileId();
                    try {
                        this.fileStoreInfoManager.saveTempFileInfo(fileInfo, renamePath, fileSize);
                        if (this.pretreatmentAsSync) {
                            this.fileOptTaskExecutor.runOptTask(fileInfo, fileInfo.getFileSize(), (Map<String, Object>)pretreatInfo);
                        } else {
                            this.fileOptTaskExecutor.addOptTask(fileInfo, fileSize, (Map<String, Object>)pretreatInfo);
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    return fileId;
                }
                return dbFile.getFileId();
            }
            FileSystemOpt.deleteFile((String)tempFilePath);
            throw new ObjectException(800, "\u6587\u4ef6\u4e0a\u4f20\u51fa\u9519\uff0cfileName\u53c2\u6570\u5fc5\u987b\u4f20\uff0c\u5982\u679c\u4f20\u4e86token\u548csize\u53c2\u6570\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\uff0c\u5e76\u786e\u8ba4\u9009\u62e9\u7684\u6587\u4ef6\uff01");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ObjectException(800, "\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25, " + e.getMessage(), (Throwable)e);
        }
    }

    public String saveFile(String sourFilePath, FileBaseInfo fileInfo, long fileSize) throws IOException {
        return this.saveFile(fileInfo, fileSize, new FileInputStream(sourFilePath));
    }

    public boolean checkFile(String fileId) {
        if (StringUtils.isNotBlank((CharSequence)fileId)) {
            FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
            if (fileInfo == null) {
                return false;
            }
            FileStoreInfo storeInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
            if (storeInfo == null) {
                return false;
            }
            return this.fileStore.checkFile(storeInfo.getFileStorePath());
        }
        return false;
    }

    public String matchFileStoreUrl(FileBaseInfo fileInfo, long fileSize) {
        return this.fileStore.matchFileStoreUrl(fileInfo, fileSize);
    }

    public String getFileAccessUrl(String fileId) {
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        FileStoreInfo fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
        return this.fileStore.getFileAccessUrl(fileStoreInfo.getFileStorePath());
    }

    public long getFileSize(String fileId) {
        try {
            FileBaseInfo fi = this.getFileInfo(fileId);
            FileStoreInfo fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fi.getFileMd5()));
            return fileStoreInfo != null ? fileStoreInfo.getFileSize() : -1L;
        }
        catch (Exception e) {
            return -2L;
        }
    }

    public InputStream loadFileStream(String fileId) throws IOException {
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        FileStoreInfo fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
        if ("E".equals(fileStoreInfo.getIsTemp())) {
            return null;
        }
        return fileStoreInfo.isTemp() != false ? new FileInputStream(fileStoreInfo.getFileStorePath()) : this.fileStore.loadFileStream(fileStoreInfo.getFileStorePath());
    }

    public File getFile(String fileId) throws IOException {
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        FileStoreInfo fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
        if ("E".equals(fileStoreInfo.getIsTemp())) {
            return null;
        }
        return fileStoreInfo.isTemp() != false ? new File(fileStoreInfo.getFileStorePath()) : this.fileStore.getFile(fileStoreInfo.getFileStorePath());
    }

    public boolean deleteFile(String fileId) {
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        if (fileInfo != null) {
            this.fileInfoManager.deleteObjectById((Serializable)((Object)fileId));
            if (this.esServerConfig != null) {
                return this.fetchDocumentIndexer().deleteDocument(fileId);
            }
            this.fileStoreInfoManager.decreaseFileReference(fileInfo.getFileMd5());
            return true;
        }
        return false;
    }

    public FileBaseInfo getFileInfo(String fileId) {
        return (FileBaseInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
    }
}

