/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.service.impl;

import com.centit.fileserver.common.FileLibraryInfo;
import com.centit.fileserver.dao.FileFavoriteDao;
import com.centit.fileserver.dao.FileInfoDao;
import com.centit.fileserver.dao.FileStoreInfoDao;
import com.centit.fileserver.po.FileFavorite;
import com.centit.fileserver.po.FileFolderInfo;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.po.FileStoreInfo;
import com.centit.fileserver.service.FileFavoriteManager;
import com.centit.fileserver.service.FileFolderInfoManager;
import com.centit.fileserver.service.FileLibraryInfoManager;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.jdbc.service.BaseEntityManagerImpl;
import com.centit.support.database.utils.PageDesc;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class FileFavoriteManagerImpl
extends BaseEntityManagerImpl<FileFavorite, String, FileFavoriteDao>
implements FileFavoriteManager {
    @Autowired
    private FileFavoriteDao fileFavoriteDao;
    @Autowired
    private FileInfoDao fileInfoDao;
    @Autowired
    private FileStoreInfoDao fileStoreInfoDao;
    @Autowired
    private FileFolderInfoManager fileFolderInfoMag;
    @Autowired
    private FileLibraryInfoManager fileLibraryInfoManager;

    @Override
    public void updateFileFavorite(FileFavorite fileFavorite) {
        this.fileFavoriteDao.updateObject(fileFavorite);
    }

    @Override
    public void createFileFavorite(FileFavorite fileFavorite) {
        this.fileFavoriteDao.saveNewObject(fileFavorite);
    }

    @Override
    public List<FileFavorite> listFileFavorite(String topUnit, Map<String, Object> param, PageDesc pageDesc) {
        param.put("withFile", "1");
        List list = this.fileFavoriteDao.listObjectsByProperties(param, pageDesc);
        list.forEach(e -> {
            FileInfo fileInfo = (FileInfo)this.fileInfoDao.getObjectById(e.getFileId());
            if (fileInfo != null) {
                e.setFileName(fileInfo.getFileName());
                e.setFileType(fileInfo.getFileType());
                e.setUploadUser(CodeRepositoryUtil.getUserName((String)topUnit, (String)fileInfo.getFileOwner()));
                e.setLibraryId(fileInfo.getLibraryId());
                e.setParentFolder(fileInfo.getParentFolder());
                e.setShowPath(this.getShowPath(topUnit, fileInfo.getFileShowPath(), fileInfo.getLibraryId()));
                FileStoreInfo fileStoreInfo = (FileStoreInfo)this.fileStoreInfoDao.getObjectById(fileInfo.getFileMd5());
                if (fileStoreInfo != null) {
                    e.setFileSize(fileStoreInfo.getFileSize());
                }
            }
        });
        return list;
    }

    @Override
    public String getShowPath(String topUnit, String fileShowPath, String libraryId) {
        if (StringUtils.isBlank((CharSequence)fileShowPath)) {
            return fileShowPath;
        }
        String[] paths = StringUtils.split((String)fileShowPath, (String)"/");
        StringBuilder showPath = new StringBuilder();
        for (String path : paths) {
            showPath.append("/");
            if (!"-1".equals(path)) {
                FileFolderInfo fileFolderInfo = this.fileFolderInfoMag.getFileFolderInfo(path);
                if (fileFolderInfo != null) {
                    showPath.append(fileFolderInfo.getFolderName());
                    continue;
                }
                showPath.append(path);
                continue;
            }
            FileLibraryInfo fileLibraryInfo = this.fileLibraryInfoManager.getFileLibrary(topUnit, libraryId);
            if (fileLibraryInfo != null) {
                showPath.append(fileLibraryInfo.getLibraryName());
                continue;
            }
            showPath.append(path);
        }
        return showPath.toString();
    }

    @Override
    public FileFavorite getFileFavorite(String favoriteId) {
        return (FileFavorite)this.fileFavoriteDao.fetchObjectReferences(this.fileFavoriteDao.getObjectById(favoriteId));
    }

    @Override
    public void deleteFileFavorite(String favoriteId) {
        this.fileFavoriteDao.deleteObjectById(favoriteId);
    }
}

