/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.pretreat;

import com.centit.support.file.FileSystemOpt;
import com.centit.support.file.FileType;
import com.centit.support.office.OfdUtils;
import com.centit.support.office.OfficeToPdf;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractOfficeToPdf {
    public static final String DOC = "doc";
    public static final String DOCX = "docx";
    public static final String XLS = "xls";
    public static final String XLSX = "xlsx";
    public static final String PPT = "ppt";
    public static final String PPTX = "pptx";
    public static final String PDF = "pdf";
    public static final String TXT = "txt";
    public static final String OFD = "ofd";
    private static Log logger = LogFactory.getLog(AbstractOfficeToPdf.class);

    private AbstractOfficeToPdf() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean office2Pdf(String inputFile, String pdfFile) throws Exception {
        return AbstractOfficeToPdf.office2Pdf(FileType.getFileExtName((String)inputFile), inputFile, pdfFile);
    }

    public static boolean canTransToPdf(String fileType) {
        if (StringUtils.isBlank((CharSequence)fileType)) {
            return false;
        }
        return StringUtils.equalsAnyIgnoreCase((CharSequence)fileType, (CharSequence[])new CharSequence[]{DOCX, OFD, XLS, XLSX, PPT, PPTX});
    }

    public static boolean office2Pdf(String suffix, String inputFile, String pdfFile) throws Exception {
        File file = new File(inputFile);
        if (!file.exists()) {
            logger.error((Object)(file.getAbsolutePath() + " not exists"));
            return false;
        }
        if (PDF.equalsIgnoreCase(suffix)) {
            try {
                FileSystemOpt.fileCopy((String)inputFile, (String)pdfFile);
                return true;
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return false;
            }
        }
        if (DOC.equalsIgnoreCase(suffix) || DOCX.equalsIgnoreCase(suffix)) {
            return OfficeToPdf.word2Pdf((String)inputFile, (String)pdfFile, (String)suffix);
        }
        if (PPT.equalsIgnoreCase(suffix) || PPTX.equalsIgnoreCase(suffix)) {
            return OfficeToPdf.ppt2Pdf((String)inputFile, (String)pdfFile, (String)suffix);
        }
        if (XLS.equalsIgnoreCase(suffix) || XLSX.equalsIgnoreCase(suffix)) {
            return OfficeToPdf.excel2Pdf((String)inputFile, (String)pdfFile);
        }
        if (OFD.equalsIgnoreCase(suffix)) {
            return OfdUtils.ofd2Pdf((String)inputFile, (String)pdfFile);
        }
        return false;
    }
}

