/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.controller;

import com.centit.fileserver.common.FileLibraryInfo;
import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.po.FileFolderInfo;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.po.FileShowInfo;
import com.centit.fileserver.po.FileStoreInfo;
import com.centit.fileserver.service.FileFolderInfoManager;
import com.centit.fileserver.service.FileInfoManager;
import com.centit.fileserver.service.FileLibraryInfoManager;
import com.centit.fileserver.service.FileStoreInfoManager;
import com.centit.fileserver.service.LocalFileManager;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.algorithm.ZipCompressor;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileSystemOpt;
import com.centit.support.file.FileType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/folder"})
@Api(value="FILE_FOLDER_INFO", tags={"\u6587\u4ef6\u5939\u4fe1\u606f"})
public class FileFolderInfoController
extends BaseController {
    private static final long MAX_ZIP_FILE_SIZE = 0x100000000L;
    @Autowired
    private FileInfoManager fileInfoManager;
    @Autowired
    private LocalFileManager localFileManager;
    @Autowired
    private FileStoreInfoManager fileStoreInfoManager;
    @Autowired
    protected FileStore fileStore;
    @Autowired
    private FileFolderInfoManager fileFolderInfoMag;
    @Autowired
    private FileLibraryInfoManager fileLibraryInfoManager;

    @RequestMapping(value={"/prev/{folderId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u8be2\u6587\u4ef6\u5939\u6240\u6709\u4e0a\u7ea7\u6587\u4ef6\u5939\u63a5\u53e3")
    @WrapUpResponseBody
    public List<FileFolderInfo> list(@PathVariable String folderId, HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        FileFolderInfo fileFolderInfo = this.fileFolderInfoMag.getFileFolderInfo(folderId);
        String[] paths = StringUtils.split((String)fileFolderInfo.getFolderPath(), (String)"/");
        ArrayList<FileFolderInfo> fileFolderInfos = new ArrayList<FileFolderInfo>();
        fileFolderInfos.add(fileFolderInfo);
        fileFolderInfos.add(this.getFileFolderInfo(this.fileLibraryInfoManager.getFileLibrary(topUnit, fileFolderInfo.getLibraryId())));
        for (String path : paths) {
            if ("-1".equals(path)) continue;
            fileFolderInfos.add(this.fileFolderInfoMag.getFileFolderInfo(path));
        }
        return fileFolderInfos;
    }

    @RequestMapping(value={"/{libraryId}/{folderId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6309\u5e93\u67e5\u8be2\u6240\u6709\u6587\u4ef6\u5939\u53ca\u6587\u4ef6\u5939\u4fe1\u606f\u5217\u8868")
    @WrapUpResponseBody
    public List<FileShowInfo> list(@PathVariable String libraryId, @PathVariable String folderId, HttpServletRequest request) {
        boolean queryFile;
        Map searchColumn = CollectionsOpt.createHashMap((Object[])new Object[]{"libraryId", libraryId, "parentFolder", folderId});
        searchColumn.put("favoriteUser", WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        List<FileFolderInfo> fileFolderInfos = this.fileFolderInfoMag.listFileFolderInfo(searchColumn, null);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        boolean bl = queryFile = !StringUtils.isBlank((CharSequence)request.getParameter("fileName"));
        if (queryFile) {
            searchColumn.put("fileName", request.getParameter("fileName"));
        }
        List<FileShowInfo> fileShowInfos = this.localFileManager.listFolderFiles(topUnit, searchColumn);
        if (!queryFile) {
            for (FileFolderInfo fileFolderInfo : fileFolderInfos) {
                FileShowInfo fileShowInfo = this.fileFolderToFileShow(topUnit, fileFolderInfo);
                fileShowInfos.add(fileShowInfo);
            }
        }
        return fileShowInfos;
    }

    @RequestMapping(value={"/downloadZip/{folderId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u5c06\u6587\u4ef6\u5939\u6253\u5305\u6210zip\u6587\u4ef6\u4e0b\u8f7d")
    public void downloadAsZipStream(@PathVariable String folderId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        FileFolderInfo folderInfo = this.fileFolderInfoMag.getFileFolderInfo(folderId);
        response.setContentType(FileType.mapExtNameToMimeType((String)"zip"));
        response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(folderInfo.getFolderName(), "UTF-8") + ".zip");
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        ZipOutputStream out = ZipCompressor.convertToZipOutputStream((OutputStream)response.getOutputStream());
        this.addFolder(topUnit, out, "", folderId, 0L);
        out.close();
        OperationLogCenter.log((OperationLog)OperationLog.create().operation("FileServerLog").user(WebOptUtils.getCurrentUserCode((HttpServletRequest)request)).unit(folderInfo.getLibraryId()).topUnit(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request)).correlation(WebOptUtils.getCorrelationId((HttpServletRequest)request)).loginIp(WebOptUtils.getRequestAddr((HttpServletRequest)request)).method("\u6587\u4ef6\u5939\u6253\u5305\u4e0b\u8f7d").tag(folderId).content(folderInfo.getFolderName()));
    }

    @RequestMapping(value={"/zip/{folderId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u5c06\u6587\u4ef6\u5939\u6253\u5305\u6210zip, \u5e76\u8fd4\u56de\u4e34\u65f6\u6587\u4ef6\u7684\u8def\u5f84")
    @WrapUpResponseBody
    public String downloadAsZip(@PathVariable String folderId, HttpServletRequest request) throws UnsupportedEncodingException {
        FileFolderInfo folderInfo = this.fileFolderInfoMag.getFileFolderInfo(folderId);
        String tempFileId = UuidOpt.getUuidAsString32();
        String zipFile = SystemTempFileUtils.getTempFilePath((String)tempFileId);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        this.compressFolder(topUnit, zipFile, folderId);
        OperationLogCenter.log((OperationLog)OperationLog.create().operation("FileServerLog").user(WebOptUtils.getCurrentUserCode((HttpServletRequest)request)).unit(folderInfo.getLibraryId()).topUnit(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request)).correlation(WebOptUtils.getCorrelationId((HttpServletRequest)request)).loginIp(WebOptUtils.getRequestAddr((HttpServletRequest)request)).method("\u6587\u4ef6\u5939\u6253\u5305\u4e0b\u8f7d").tag(folderId).content(folderInfo.getFolderName()).newObject((Object)zipFile));
        return tempFileId + "?name=" + URLEncoder.encode(folderInfo.getFolderName(), "UTF-8") + ".zip";
    }

    @RequestMapping(value={"/{folderId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u6587\u4ef6\u5939\u4fe1\u606f")
    @WrapUpResponseBody
    public FileFolderInfo getFileFolderInfo(@PathVariable String folderId) {
        return this.fileFolderInfoMag.getFileFolderInfo(folderId);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ApiOperation(value="\u65b0\u589e\u6587\u4ef6\u5939\u4fe1\u606f")
    @WrapUpResponseBody
    public FileFolderInfo createFileFolderInfo(@RequestBody FileFolderInfo fileFolderInfo, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)fileFolderInfo.getLibraryId())) {
            throw new ObjectException("\u5e93id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] folderNames = StringUtils.split((String)fileFolderInfo.getFolderName(), (String)"/");
        String folderPath = fileFolderInfo.getFolderPath();
        String parentId = fileFolderInfo.getFolderId();
        String libraryId = fileFolderInfo.getLibraryId();
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        for (int i = 0; i < folderNames.length; ++i) {
            List<FileFolderInfo> fileFolderInfos = this.fileFolderInfoMag.listFileFolderInfo(CollectionsOpt.createHashMap((Object[])new Object[]{"folderPath", folderPath, "folderName", folderNames[i], "libraryId", libraryId}), null);
            if (fileFolderInfos == null || fileFolderInfos.size() == 0) {
                fileFolderInfo.setFolderId(null);
                fileFolderInfo.setFolderName(folderNames[i]);
                fileFolderInfo.setFolderPath(folderPath);
                fileFolderInfo.setParentFolder(parentId);
                fileFolderInfo.setLibraryId(libraryId);
                fileFolderInfo.setCreateUser(userCode);
                this.fileFolderInfoMag.createFileFolderInfo(fileFolderInfo);
            } else {
                fileFolderInfo = fileFolderInfos.get(0);
            }
            folderPath = folderPath + "/" + fileFolderInfo.getFolderId();
            parentId = fileFolderInfo.getFolderId();
        }
        return fileFolderInfo;
    }

    @RequestMapping(value={"/{folderId}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u6587\u4ef6\u5939\u4fe1\u606f")
    @WrapUpResponseBody
    public void deleteFileFolderInfo(@PathVariable String folderId) {
        this.fileFolderInfoMag.deleteFileFolderInfo(folderId);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @ApiOperation(value="\u66f4\u65b0\u6587\u4ef6\u5939\u4fe1\u606f")
    @WrapUpResponseBody
    public void updateFileFolderInfo(@RequestBody FileFolderInfo fileFolderInfo, HttpServletRequest request, HttpServletResponse response) {
        fileFolderInfo.setUpdateUser(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        JsonResultUtils.writeSingleDataJson((Object)this.fileFolderInfoMag.updateFileFolderInfo(fileFolderInfo), (HttpServletResponse)response);
    }

    private FileFolderInfo getFileFolderInfo(FileLibraryInfo fileLibraryInfo) {
        FileFolderInfo fileFolderInfo1 = new FileFolderInfo();
        fileFolderInfo1.setFolderName(fileLibraryInfo.getLibraryName());
        fileFolderInfo1.setFolderId(fileLibraryInfo.getLibraryId());
        fileFolderInfo1.setIsCreateFolder(fileLibraryInfo.getIsCreateFolder());
        fileFolderInfo1.setIsUpload(fileLibraryInfo.getIsUpload());
        fileFolderInfo1.setFolderPath("/");
        fileFolderInfo1.setParentFolder("0");
        return fileFolderInfo1;
    }

    private FileShowInfo fileFolderToFileShow(String topUnit, FileFolderInfo fileFolderInfo) {
        FileShowInfo fileShowInfo = new FileShowInfo();
        fileShowInfo.setFileName(fileFolderInfo.getFolderName());
        fileShowInfo.setFileShowPath(fileFolderInfo.getFolderPath());
        fileShowInfo.setFolder(true);
        fileShowInfo.setFolderId(fileFolderInfo.getFolderId());
        fileShowInfo.setParentPath(fileFolderInfo.getParentFolder());
        fileShowInfo.setCreateFolder(fileFolderInfo.getIsCreateFolder());
        fileShowInfo.setUploadFile(fileFolderInfo.getIsUpload());
        fileShowInfo.setCreateTime(fileFolderInfo.getCreateTime());
        fileShowInfo.setOwnerName(CodeRepositoryUtil.getUserName((String)topUnit, (String)fileFolderInfo.getCreateUser()));
        return fileShowInfo;
    }

    private void addFolder(String topUnit, ZipOutputStream out, String basedir, String folderId, long currSize) throws IOException {
        List<FileFolderInfo> fileFolderInfos;
        List<FileShowInfo> fileList = this.localFileManager.listFolderFiles(topUnit, CollectionsOpt.createHashMap((Object[])new Object[]{"parentFolder", folderId}));
        if (fileList != null) {
            for (FileShowInfo file : fileList) {
                String tempFile;
                FileInfo fi = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)file.getAccessToken()));
                FileStoreInfo fsi = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fi.getFileMd5()));
                InputStream inputStream = this.fileStore.loadFileStream(fsi.getFileStorePath());
                if (inputStream == null && FileSystemOpt.existFile((String)(tempFile = SystemTempFileUtils.getTempFilePath((String)fsi.getFileMd5(), (long)fsi.getFileSize())))) {
                    inputStream = Files.newInputStream(Paths.get(tempFile, new String[0]), new OpenOption[0]);
                }
                if (inputStream != null) {
                    ZipCompressor.compressFile((InputStream)inputStream, (String)fi.getFileName(), (ZipOutputStream)out, (String)basedir);
                }
                if (currSize < 0L || (currSize += fsi.getFileSize().longValue()) <= 0x100000000L) continue;
                throw new ObjectException("zip\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u7ea6\u5b9a\u7684\u6700\u5927\u503c\uff01");
            }
        }
        if ((fileFolderInfos = this.fileFolderInfoMag.listFileFolderInfo(CollectionsOpt.createHashMap((Object[])new Object[]{"parentFolder", folderId}), null)) != null) {
            for (FileFolderInfo fileFolderInfo : fileFolderInfos) {
                this.addFolder(topUnit, out, basedir + fileFolderInfo.getFolderName() + "/", fileFolderInfo.getFolderId(), currSize);
            }
        }
    }

    private void compressFolder(String topUnit, String zipFilePathName, String folderId) {
        try {
            File zipFile = new File(zipFilePathName);
            FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
            ZipOutputStream out = ZipCompressor.convertToZipOutputStream((OutputStream)fileOutputStream);
            this.addFolder(topUnit, out, "", folderId, 0L);
            out.close();
        }
        catch (Exception e) {
            throw new ObjectException((Throwable)e);
        }
    }
}

