/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.task;

import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileTaskInfo;
import com.centit.fileserver.common.FileTaskOpeator;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.pretreat.FilePretreatUtils;
import com.centit.fileserver.service.FileInfoManager;
import com.centit.fileserver.task.FileStoreOpt;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.file.FileMD5Maker;
import com.centit.support.file.FileSystemOpt;
import com.centit.support.file.FileType;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ZipFileOpt
extends FileStoreOpt
implements FileTaskOpeator {
    private static final Logger logger = LoggerFactory.getLogger(ZipFileOpt.class);
    @Autowired
    private FileInfoManager fileInfoManager;

    public String getOpeatorName() {
        return "zip";
    }

    private void doZipFile(FileInfo fileInfo, long fileSize, String encryptPass) {
        String originalTempFilePath = SystemTempFileUtils.getTempFilePath((String)fileInfo.getFileMd5(), (long)fileSize);
        try {
            String encryptedZipFile;
            String string = encryptedZipFile = StringUtils.isBlank((CharSequence)encryptPass) ? FilePretreatUtils.zipFile(fileInfo, originalTempFilePath) : FilePretreatUtils.zipFileAndEncrypt(fileInfo, originalTempFilePath, encryptPass);
            if (null != encryptedZipFile) {
                fileInfo.setFileMd5(FileMD5Maker.makeFileMD5((File)new File(encryptedZipFile)));
                fileInfo.setFileName(FileType.truncateFileExtName((String)fileInfo.getFileName()) + ".zip");
                fileInfo.setFileType("zip");
                this.save(encryptedZipFile, fileInfo, new File(encryptedZipFile).length());
                this.fileInfoManager.updateObject((Serializable)fileInfo);
                logger.info("zip\u52a0\u5bc6\u538b\u7f29\u6587\u4ef6\u5b8c\u6210");
            }
        }
        catch (Exception e) {
            logger.error("zip\u52a0\u5bc6\u538b\u7f29\u6587\u4ef6\u65f6\u51fa\u9519\uff01", (Throwable)e);
        }
        FileSystemOpt.deleteFile((String)originalTempFilePath);
    }

    public void doFileTask(FileTaskInfo fileOptTaskInfo) {
        String fileId = fileOptTaskInfo.getFileId();
        long fileSize = fileOptTaskInfo.getFileSize();
        String encryptPass = StringBaseOpt.castObjectToString((Object)fileOptTaskInfo.getOptParam("password"));
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        this.doZipFile(fileInfo, fileSize, encryptPass);
    }

    public FileTaskInfo attachTaskInfo(FileInfo fileInfo, long fileSize, Map<String, Object> pretreatInfo) {
        if ("Z".equalsIgnoreCase(StringBaseOpt.castObjectToString((Object)pretreatInfo.get("encryptType")))) {
            FileTaskInfo zipTaskInfo = new FileTaskInfo(this.getOpeatorName());
            zipTaskInfo.copy((FileBaseInfo)fileInfo);
            zipTaskInfo.setFileSize(Long.valueOf(fileSize));
            zipTaskInfo.putOptParam("password", pretreatInfo.get("password"));
            return zipTaskInfo;
        }
        return null;
    }

    public int runTaskInfo(FileInfo fileInfo, long fileSize, Map<String, Object> pretreatInfo) {
        if ("Z".equalsIgnoreCase(StringBaseOpt.castObjectToString((Object)pretreatInfo.get("encryptType")))) {
            this.doZipFile(fileInfo, fileSize, StringBaseOpt.castObjectToString((Object)pretreatInfo.get("password")));
            return 1;
        }
        return 0;
    }
}

