/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.task;

import com.alibaba.fastjson2.JSON;
import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileTaskInfo;
import com.centit.fileserver.common.FileTaskOpeator;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.service.FileInfoManager;
import com.centit.fileserver.task.FileStoreOpt;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.support.algorithm.StringBaseOpt;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SaveFileOpt
extends FileStoreOpt
implements FileTaskOpeator {
    private static final Logger logger = LoggerFactory.getLogger(SaveFileOpt.class);
    @Autowired
    private FileInfoManager fileInfoManager;

    public String getOpeatorName() {
        return "save";
    }

    public void doFileTask(FileTaskInfo fileOptTaskInfo) {
        String fileMd5 = fileOptTaskInfo.getFileMd5();
        long fileSize = fileOptTaskInfo.getFileSize();
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileOptTaskInfo.getFileId()));
        if (null == fileInfo) {
            OperationLogCenter.log((OperationLog)OperationLog.create().operation("FileServerLog").user("admin").level("1").topUnit("system").method("SaveFileOpt").tag(fileMd5).content("\u6587\u4ef6\u5b58\u50a8\u5931\u8d25" + fileOptTaskInfo.getFileId() + "\u6ca1\u6709\u5bf9\u5e94fileInfo").oldObject((Object)fileOptTaskInfo));
            logger.error("\u6587\u4ef6\u5b58\u50a8\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)fileOptTaskInfo));
            return;
        }
        String tempFilePath = SystemTempFileUtils.getTempFilePath((String)fileMd5, (long)fileSize);
        this.save(tempFilePath, fileInfo, fileSize);
        logger.info("\u5b58\u50a8\u6587\u4ef6\u5b8c\u6210");
    }

    public FileTaskInfo attachTaskInfo(FileInfo fileInfo, long fileSize, Map<String, Object> pretreatInfo) {
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)StringBaseOpt.castObjectToString((Object)pretreatInfo.get("encryptType")), (CharSequence[])new CharSequence[]{"A", "S", "M", "G", "Z"})) {
            return null;
        }
        FileTaskInfo saveFileTaskInfo = new FileTaskInfo(this.getOpeatorName());
        saveFileTaskInfo.copy((FileBaseInfo)fileInfo);
        saveFileTaskInfo.setFileSize(Long.valueOf(fileSize));
        return saveFileTaskInfo;
    }

    public int runTaskInfo(FileInfo fileInfo, long fileSize, Map<String, Object> pretreatInfo) {
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)StringBaseOpt.castObjectToString((Object)pretreatInfo.get("encryptType")), (CharSequence[])new CharSequence[]{"A", "S", "M", "G", "Z"})) {
            return 0;
        }
        String tempFilePath = SystemTempFileUtils.getTempFilePath((String)fileInfo.getFileMd5(), (long)fileSize);
        this.save(tempFilePath, fileInfo, fileSize);
        return 1;
    }
}

