/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.service.impl;

import com.centit.fileserver.common.FileLibraryInfo;
import com.centit.fileserver.common.OperateFileLibrary;
import com.centit.fileserver.dao.FileLibraryInfoDao;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.service.FileLibraryInfoManager;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.jdbc.service.BaseEntityManagerImpl;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.framework.model.basedata.WorkGroup;
import com.centit.support.algorithm.CollectionsOpt;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="fileLibraryInfoManager")
@Transactional(rollbackFor={Exception.class})
public class FileLibraryInfoManagerImpl
extends BaseEntityManagerImpl<FileLibraryInfo, String, FileLibraryInfoDao>
implements FileLibraryInfoManager,
OperateFileLibrary {
    private static final Logger logger = LoggerFactory.getLogger(FileLibraryInfoManager.class);
    private static final char SEPARATOR = '/';
    private static final String WORKGROUP_ROLECODE_MEMBER = "\u7ec4\u5458";
    @Autowired
    private FileLibraryInfoDao fileLibraryInfoDao;
    @Value(value="${extend.library.enable:false}")
    protected boolean topEnable;
    @Value(value="${extend.library.unitcode:root}")
    protected String topUnit;

    @Override
    public void updateFileLibrary(FileLibraryInfo fileLibraryInfo) {
        this.fileLibraryInfoDao.updateObject((Serializable)fileLibraryInfo);
        this.fileLibraryInfoDao.saveObjectReferences((Serializable)fileLibraryInfo);
    }

    @Override
    public void createFileLibrary(FileLibraryInfo fileLibraryInfo) {
        if (fileLibraryInfo.getWorkGroups() != null) {
            fileLibraryInfo.getWorkGroups().forEach(e -> {
                if (StringUtils.isBlank((CharSequence)e.getCreator())) {
                    e.setCreator(fileLibraryInfo.getCreateUser());
                }
                if (StringUtils.isBlank((CharSequence)e.getWorkGroupParameter().getRoleCode())) {
                    e.getWorkGroupParameter().setRoleCode(WORKGROUP_ROLECODE_MEMBER);
                }
            });
        }
        this.fileLibraryInfoDao.saveNewObject((Serializable)fileLibraryInfo);
        this.fileLibraryInfoDao.saveObjectReferences((Serializable)fileLibraryInfo);
    }

    @Override
    public List<FileLibraryInfo> listFileLibrary(String topUnit, String userCode, String libraryType) {
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accessUser", userCode);
        map.put("libraryType", libraryType);
        StringBuilder sqlBuilder = new StringBuilder("where 1=1 and ( (library_type=:libraryType and library_id in (select group_id from work_group where user_code=:accessUser) )");
        Set<String> units = this.getUnits(topUnit, userCode);
        if (units != null && units.size() > 0) {
            map.put("ownUnits", units);
            sqlBuilder.append(" or (library_type='O' and own_unit in (:ownUnits) )");
        }
        sqlBuilder.append(")");
        List libraryInfos = this.fileLibraryInfoDao.listObjectsByFilter(sqlBuilder.toString(), map);
        libraryInfos.add(this.initPersonLibrary(topUnit, userCode));
        return libraryInfos.stream().sorted(Comparator.comparing(FileLibraryInfo::getLibraryType, Comparator.reverseOrder())).collect(Collectors.toList());
    }

    @Override
    public List<UnitInfo> listUnitPathsByUserCode(String topUnit, String userCode) {
        ArrayList<UnitInfo> result = new ArrayList<UnitInfo>(10);
        for (String unit : this.getUnits(topUnit, userCode)) {
            if (CodeRepositoryUtil.getUnitInfoByCode((String)topUnit, (String)unit) == null) continue;
            result.add(CodeRepositoryUtil.getUnitInfoByCode((String)topUnit, (String)unit));
        }
        return result;
    }

    @Override
    public FileLibraryInfo initPersonLibrary(String topUnit, String userCode) {
        List fileLibraryInfos = this.fileLibraryInfoDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"ownUser", userCode, "libraryType", "P"}));
        if (null == fileLibraryInfos || fileLibraryInfos.size() == 0) {
            FileLibraryInfo fileLibraryInfo = new FileLibraryInfo();
            fileLibraryInfo.setCreateUser(userCode);
            fileLibraryInfo.setOwnUser(userCode);
            fileLibraryInfo.setLibraryName("\u6211\u7684\u6587\u4ef6");
            fileLibraryInfo.setLibraryType("P");
            fileLibraryInfo.setIsCreateFolder("T");
            fileLibraryInfo.setIsUpload("T");
            this.createFileLibrary(fileLibraryInfo);
            return fileLibraryInfo;
        }
        return (FileLibraryInfo)fileLibraryInfos.get(0);
    }

    @Override
    public void initUnitLibrary(String topUnit, String unitCode, String userCode) {
        List fileLibraryInfos = this.fileLibraryInfoDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"ownUnit", unitCode, "libraryType", "O"}));
        if (null == fileLibraryInfos || fileLibraryInfos.size() == 0) {
            FileLibraryInfo fileLibraryInfo = this.getUnitLibraryInfo(topUnit, unitCode, userCode);
            this.createFileLibrary(fileLibraryInfo);
        }
    }

    private FileLibraryInfo getUnitLibraryInfo(String topUnit, String unitCode, String userCode) {
        FileLibraryInfo fileLibraryInfo = new FileLibraryInfo();
        fileLibraryInfo.setCreateUser(userCode);
        fileLibraryInfo.setOwnUser(userCode);
        fileLibraryInfo.setOwnUnit(unitCode);
        fileLibraryInfo.setLibraryName(CodeRepositoryUtil.getUnitName((String)topUnit, (String)unitCode));
        fileLibraryInfo.setLibraryType("O");
        fileLibraryInfo.setIsCreateFolder("T");
        fileLibraryInfo.setIsUpload("T");
        this.fileLibraryInfoDao.saveNewObject((Serializable)fileLibraryInfo);
        return fileLibraryInfo;
    }

    @Override
    public Set<String> getUnits(String topUnit, String userCode) {
        if (userCode == null || topUnit == null) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        List uulist = CodeRepositoryUtil.listUserUnits((String)topUnit, (String)userCode);
        if (uulist != null && uulist.size() > 0) {
            for (UserUnit uu : uulist) {
                UnitInfo unitInfo = CodeRepositoryUtil.getUnitInfoByCode((String)topUnit, (String)uu.getUnitCode());
                if (unitInfo == null) continue;
                String[] temp = StringUtils.split((String)unitInfo.getUnitPath(), (char)'/');
                treeSet.addAll(Arrays.asList(temp));
            }
        }
        if (this.topEnable) {
            treeSet.add(topUnit);
        }
        return treeSet;
    }

    @Override
    public FileLibraryInfo getFileLibrary(String topUnit, String libraryId) {
        FileLibraryInfo fileLibraryInfo = (FileLibraryInfo)this.fileLibraryInfoDao.getObjectWithReferences(libraryId);
        if (fileLibraryInfo == null) {
            return null;
        }
        if (!StringUtils.isBlank((CharSequence)fileLibraryInfo.getOwnUser())) {
            fileLibraryInfo.setOwnName(CodeRepositoryUtil.getUserName((String)topUnit, (String)fileLibraryInfo.getOwnUser()));
        }
        return fileLibraryInfo;
    }

    @Override
    public void deleteFileLibrary(String libraryId) {
        this.fileLibraryInfoDao.deleteObjectById(libraryId);
    }

    @Override
    public boolean checkAuth(String topUnit, FileInfo fileInfo, String userCode, String authCode) {
        Set<String> unitPath = this.getUnits(topUnit, userCode);
        if (!("undefined".equals(userCode) || StringUtils.isBlank((CharSequence)userCode) || StringUtils.isBlank((CharSequence)fileInfo.getLibraryId()))) {
            FileLibraryInfo fileLibraryInfo = this.getFileLibrary(topUnit, fileInfo.getLibraryId());
            switch (fileLibraryInfo.getLibraryType()) {
                case "P": {
                    if (!userCode.equals(fileLibraryInfo.getOwnUser())) break;
                    return true;
                }
                case "O": {
                    for (String s : unitPath) {
                        if (!s.contains(fileLibraryInfo.getOwnUnit())) continue;
                        return true;
                    }
                    break;
                }
                case "I": 
                case "T": {
                    if (userCode.equals(fileLibraryInfo.getOwnUser())) {
                        return true;
                    }
                    if (fileLibraryInfo.getWorkGroups() == null) break;
                    for (WorkGroup workGroup : fileLibraryInfo.getWorkGroups()) {
                        if (!userCode.equals(workGroup.getWorkGroupParameter().getUserCode())) continue;
                        return true;
                    }
                    break;
                }
            }
        }
        if (!StringUtils.isBlank((CharSequence)authCode) && !"undefined".equals(authCode)) {
            return authCode.equals(fileInfo.getAuthCode());
        }
        return false;
    }

    public FileLibraryInfo insertFileLibrary(FileLibraryInfo fileLibrary) {
        this.fileLibraryInfoDao.mergeObject((Serializable)fileLibrary);
        return fileLibrary;
    }
}

