/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.po;

import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="FILE_STORE_INFO")
public class FileStoreInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="FILE_MD5")
    private String fileMd5;
    @Column(name="FILE_SIZE")
    private Long fileSize;
    @Column(name="FILE_STORE_PATH")
    private String fileStorePath;
    @Column(name="FILE_REFERENCE_COUNT")
    private Long fileReferenceCount;
    @Column(name="IS_TEMP")
    private String isTemp;
    @Column(name="CREATE_TIME")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, occasion=GeneratorTime.NEW, value="today()")
    private Date createTime;

    public FileStoreInfo() {
    }

    public FileStoreInfo(String fileMd5, Long fileSize, String fileStorePath, Long fileReferenceCount, Boolean isTemp) {
        this.fileMd5 = fileMd5;
        this.fileSize = fileSize;
        this.fileStorePath = fileStorePath;
        this.fileReferenceCount = fileReferenceCount;
        this.isTemp = isTemp != false ? "T" : "F";
    }

    public Boolean isTemp() {
        return this.isTemp != null && "T".equals(this.isTemp);
    }

    public String getFileMd5() {
        return this.fileMd5;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public String getFileStorePath() {
        return this.fileStorePath;
    }

    public Long getFileReferenceCount() {
        return this.fileReferenceCount;
    }

    public String getIsTemp() {
        return this.isTemp;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setFileMd5(String fileMd5) {
        this.fileMd5 = fileMd5;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public void setFileStorePath(String fileStorePath) {
        this.fileStorePath = fileStorePath;
    }

    public void setFileReferenceCount(Long fileReferenceCount) {
        this.fileReferenceCount = fileReferenceCount;
    }

    public void setIsTemp(String isTemp) {
        this.isTemp = isTemp;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileStoreInfo)) {
            return false;
        }
        FileStoreInfo other = (FileStoreInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$fileSize = this.getFileSize();
        Long other$fileSize = other.getFileSize();
        if (this$fileSize == null ? other$fileSize != null : !((Object)this$fileSize).equals(other$fileSize)) {
            return false;
        }
        Long this$fileReferenceCount = this.getFileReferenceCount();
        Long other$fileReferenceCount = other.getFileReferenceCount();
        if (this$fileReferenceCount == null ? other$fileReferenceCount != null : !((Object)this$fileReferenceCount).equals(other$fileReferenceCount)) {
            return false;
        }
        String this$fileMd5 = this.getFileMd5();
        String other$fileMd5 = other.getFileMd5();
        if (this$fileMd5 == null ? other$fileMd5 != null : !this$fileMd5.equals(other$fileMd5)) {
            return false;
        }
        String this$fileStorePath = this.getFileStorePath();
        String other$fileStorePath = other.getFileStorePath();
        if (this$fileStorePath == null ? other$fileStorePath != null : !this$fileStorePath.equals(other$fileStorePath)) {
            return false;
        }
        String this$isTemp = this.getIsTemp();
        String other$isTemp = other.getIsTemp();
        if (this$isTemp == null ? other$isTemp != null : !this$isTemp.equals(other$isTemp)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileStoreInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $fileSize = this.getFileSize();
        result = result * 59 + ($fileSize == null ? 43 : ((Object)$fileSize).hashCode());
        Long $fileReferenceCount = this.getFileReferenceCount();
        result = result * 59 + ($fileReferenceCount == null ? 43 : ((Object)$fileReferenceCount).hashCode());
        String $fileMd5 = this.getFileMd5();
        result = result * 59 + ($fileMd5 == null ? 43 : $fileMd5.hashCode());
        String $fileStorePath = this.getFileStorePath();
        result = result * 59 + ($fileStorePath == null ? 43 : $fileStorePath.hashCode());
        String $isTemp = this.getIsTemp();
        result = result * 59 + ($isTemp == null ? 43 : $isTemp.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    public String toString() {
        return "FileStoreInfo(fileMd5=" + this.getFileMd5() + ", fileSize=" + this.getFileSize() + ", fileStorePath=" + this.getFileStorePath() + ", fileReferenceCount=" + this.getFileReferenceCount() + ", isTemp=" + this.getIsTemp() + ", createTime=" + this.getCreateTime() + ")";
    }
}

