/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.dao;

import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.po.FileShowInfo;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class FileInfoDao
extends BaseDaoImpl<FileInfo, String> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("groupId", "EQUAL");
        filterField.put("isValid", "EQUAL");
        filterField.put("files", " fileId in (?) ");
        filterField.put("fileName", "EQUAL");
        filterField.put("fileShowPath", "EQUAL");
        filterField.put("fileState", "EQUAL");
        filterField.put("pathLike", "file_show_path like :pathLike");
        return filterField;
    }

    private static String trimFilePath(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return "";
        }
        String tfp = filePath.trim();
        if (tfp.endsWith("/") || tfp.endsWith("\\")) {
            return tfp.substring(0, tfp.length() - 1);
        }
        return tfp;
    }

    public Set<String> listUserDirectories(String userCode, String fileShowPath) {
        HashSet<String> dirs = new HashSet<String>();
        DBType dbt = DBType.mapDBType((Connection)this.getConnection());
        List objects = null;
        if (StringUtils.isBlank((CharSequence)fileShowPath)) {
            String sqlsenOralce = "select distinct subStr( CONCAT(FILE_SHOW_PATH,'/'), 1,instr( CONCAT(FILE_SHOW_PATH,'/'),'/')-1) from FILE_INFO where FILE_OWNER = :uc and OS_ID='FILE_SVR' and OPT_ID='LOCAL_FILE' and FILE_SHOW_PATH is not null and FILE_SHOW_PATH<>'/'";
            String sqlsenMysql = "select distinct subString( CONCAT(FILE_SHOW_PATH,'/'), 1,instr( CONCAT(FILE_SHOW_PATH,'/'),'/')-1) from FILE_INFO where FILE_OWNER = :uc and OS_ID='FILE_SVR' and OPT_ID='LOCAL_FILE' and FILE_SHOW_PATH is not null and FILE_SHOW_PATH<>'' and FILE_SHOW_PATH<>'/'";
            objects = DatabaseOptUtils.listObjectsByNamedSql((BaseDaoImpl)this, (String)(dbt == DBType.MySql ? sqlsenMysql : sqlsenOralce), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"uc", userCode}));
        } else {
            String fsp = FileInfoDao.trimFilePath(fileShowPath) + "/";
            String sqlsenOralce = "select distinct subStr(CONCAT(FILE_SHOW_PATH,'/'), length(:fsp)+1, instr( subStr(CONCAT(FILE_SHOW_PATH,'/'),length(:fsp)+1),'/')-1) from FILE_INFO where FILE_OWNER = :uc and OS_ID='FILE_SVR' and OPT_ID='LOCAL_FILE' and FILE_SHOW_PATH like :fspmatch";
            String sqlsenMysql = "select distinct subString(CONCAT(FILE_SHOW_PATH,'/'), length(:fsp)+1, instr( subString(CONCAT(FILE_SHOW_PATH,'/'),length(:fsp)+1),'/')-1) from FILE_INFO where FILE_OWNER = :uc and OS_ID='FILE_SVR' and OPT_ID='LOCAL_FILE' and FILE_SHOW_PATH like :fspmatch";
            objects = DatabaseOptUtils.listObjectsByNamedSql((BaseDaoImpl)this, (String)(dbt == DBType.MySql ? sqlsenMysql : sqlsenOralce), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"fsp", fsp, "uc", userCode, "fspmatch", fsp + "%"}));
        }
        if (objects != null) {
            for (Object obj : objects) {
                String sd = StringBaseOpt.objectToString(obj);
                if (!StringUtils.isNotBlank((CharSequence)sd)) continue;
                dirs.add(sd);
            }
        }
        return dirs;
    }

    public Set<String> listUnitDirectories(String unitCode, String fileShowPath) {
        HashSet<String> dirs = new HashSet<String>();
        DBType dbt = DBType.mapDBType((Connection)this.getConnection());
        List objects = null;
        if (StringUtils.isBlank((CharSequence)fileShowPath)) {
            String sqlsenOralce = "select distinct subStr(CONCAT(FILE_SHOW_PATH,'/'), 1,instr( CONCAT(FILE_SHOW_PATH,'/'),'/')-1) from FILE_INFO where FILE_UNIT = :uc and OS_ID='FILE_SVR' and OPT_ID='LOCAL_FILE' and FILE_SHOW_PATH is not null and FILE_SHOW_PATH<>'/'";
            String sqlsenMysql = "select distinct subString(CONCAT(FILE_SHOW_PATH,'/'), 1,instr( CONCAT(FILE_SHOW_PATH,'/'),'/')-1) from FILE_INFO where FILE_UNIT = :uc and OS_ID='FILE_SVR' and OPT_ID='LOCAL_FILE' and FILE_SHOW_PATH is not null and FILE_SHOW_PATH<>'' and FILE_SHOW_PATH<>'/'";
            objects = DatabaseOptUtils.listObjectsByNamedSql((BaseDaoImpl)this, (String)(dbt == DBType.MySql ? sqlsenMysql : sqlsenOralce), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"uc", unitCode}));
        } else {
            String fsp = FileInfoDao.trimFilePath(fileShowPath) + "/";
            String sqlsenOralce = "select distinct subStr(CONCAT(FILE_SHOW_PATH,'/'), length(:fsp)+1, instr( subStr(CONCAT(FILE_SHOW_PATH,'/'),length(:fsp)+1),'/')-1) from FILE_INFO where FILE_UNIT = :uc and OS_ID='FILE_SVR' and OPT_ID='LOCAL_FILE' and FILE_SHOW_PATH like :fspmatch";
            String sqlsenMysql = "select distinct subString(CONCAT(FILE_SHOW_PATH,'/'), length(:fsp)+1, instr( subString(CONCAT(FILE_SHOW_PATH,'/'),length(:fsp)+1),'/')-1) from FILE_INFO where FILE_UNIT = :uc and OS_ID='FILE_SVR' and OPT_ID='LOCAL_FILE' and FILE_SHOW_PATH like :fspmatch";
            objects = DatabaseOptUtils.listObjectsByNamedSql((BaseDaoImpl)this, (String)(dbt == DBType.MySql ? sqlsenMysql : sqlsenOralce), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"fsp", fsp, "uc", unitCode, "fspmatch", fsp + "%"}));
        }
        if (objects != null) {
            for (Object obj : objects) {
                String sd = StringBaseOpt.objectToString(obj);
                if (!StringUtils.isNotBlank((CharSequence)sd)) continue;
                dirs.add(sd);
            }
        }
        return dirs;
    }

    public List<FileShowInfo> listFolderFiles(String topUnit, Map<String, Object> searchColumn) {
        String sqlsen = "select a.file_name,b.file_id,a.file_sum,b.ENCRYPT_TYPE,b.create_time,c.file_size,b.file_show_path,d.favorite_id,b.file_type,b.download_times,b.file_owner from (select a.FILE_NAME,parent_folder,library_id, count(1) as FILE_SUM, max(a.CREATE_TIME) as CREATE_TIME from FILE_INFO a  where file_state='N'  [:parentFolder | and parent_folder=:parentFolder] [:libraryId | and library_id=:libraryId]  [:fileName | and file_name=:fileName]group by FILE_NAME,parent_folder,library_id) a join file_info b on a.file_name=b.file_name and a.create_time=b.create_time and a.library_id=b.library_id and a.parent_folder=b.parent_folder join FILE_STORE_INFO c on b.FILE_MD5=c.FILE_MD5 left join file_favorite d on b.file_id=d.file_id [:favoriteUser | and d.favorite_user=:favoriteUser] where 1=1  [:fileName | and b.file_name=:fileName]";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)sqlsen, searchColumn);
        List objects = DatabaseOptUtils.listObjectsByNamedSql((BaseDaoImpl)this, (String)qap.getQuery(), (Map)qap.getParams());
        ArrayList<FileShowInfo> files = new ArrayList<FileShowInfo>();
        if (objects != null) {
            for (Object[] objs : objects) {
                FileShowInfo file = new FileShowInfo();
                file.setCatalogType("p");
                file.setFileType(StringBaseOpt.objectToString((Object)objs[8]));
                file.setFileName(StringBaseOpt.objectToString((Object)objs[0]));
                file.setAccessToken(StringBaseOpt.objectToString((Object)objs[1]));
                file.setVersions(NumberBaseOpt.castObjectToInteger((Object)objs[2]));
                file.setEncrypt(StringUtils.equals((CharSequence)StringBaseOpt.objectToString((Object)objs[3]), (CharSequence)"D"));
                file.setCreateTime(DatetimeOpt.castObjectToDate((Object)objs[4]));
                file.setFileSize(NumberBaseOpt.castObjectToLong((Object)objs[5]));
                file.setFileShowPath(StringBaseOpt.objectToString((Object)objs[6]));
                file.setFavoriteId(StringBaseOpt.objectToString((Object)objs[7]));
                file.setDownloadTimes(NumberBaseOpt.castObjectToInteger((Object)objs[9]));
                file.setOwnerName(CodeRepositoryUtil.getUserName((String)topUnit, (String)StringBaseOpt.objectToString((Object)objs[10])));
                files.add(file);
            }
        }
        return files;
    }

    public List<FileShowInfo> listUserFiles(String userCode, String fileShowPath) {
        List objects = null;
        if (StringUtils.isBlank((CharSequence)fileShowPath) || StringUtils.equals((CharSequence)fileShowPath, (CharSequence)".")) {
            String sqlsen = "select a.FILE_NAME, max(a.FILE_ID) as FILE_ID, count(1) as FILE_SUM, min(a.ENCRYPT_TYPE) as ENCRYPT_TYPE, max(a.CREATE_TIME) as CREATE_TIME, max(b.FILE_SIZE) as FILE_SIZE,max(a.file_type) fileType  from FILE_INFO a join FILE_STORE_INFO b on a.FILE_MD5=b.FILE_MD5 where FILE_OWNER = :uc and OS_ID='FILE_SVR' and OPT_ID='LOCAL_FILE' and (FILE_SHOW_PATH is null or FILE_SHOW_PATH='' or FILE_SHOW_PATH='/') group by FILE_NAME";
            objects = DatabaseOptUtils.listObjectsByNamedSql((BaseDaoImpl)this, (String)sqlsen, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"uc", userCode}));
        } else {
            String fsp = FileInfoDao.trimFilePath(fileShowPath);
            String sqlsen = "select a.FILE_NAME, max(a.FILE_ID) as FILE_ID, count(1) as FILE_SUM, min(a.ENCRYPT_TYPE) as ENCRYPT_TYPE, max(a.CREATE_TIME) as CREATE_TIME, max(b.FILE_SIZE) as FILE_SIZE,max(a.file_type) fileType  from FILE_INFO a join FILE_STORE_INFO b on a.FILE_MD5=b.FILE_MD5 where FILE_OWNER = :uc and OS_ID='FILE_SVR' and OPT_ID='LOCAL_FILE' and (FILE_SHOW_PATH=:fsp or FILE_SHOW_PATH=:fsp2) group by FILE_NAME";
            objects = DatabaseOptUtils.listObjectsByNamedSql((BaseDaoImpl)this, (String)sqlsen, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"uc", userCode, "fsp", fsp, "fsp2", fsp + "/"}));
        }
        ArrayList<FileShowInfo> files = new ArrayList<FileShowInfo>();
        if (objects != null) {
            for (Object[] objs : objects) {
                FileShowInfo file = new FileShowInfo();
                file.setFileShowPath(fileShowPath);
                file.setCatalogType("p");
                file.setFileType(StringBaseOpt.objectToString((Object)objs[6]));
                file.setFileName(StringBaseOpt.objectToString((Object)objs[0]));
                file.setAccessToken(StringBaseOpt.objectToString((Object)objs[1]));
                file.setVersions(NumberBaseOpt.castObjectToInteger((Object)objs[2]));
                file.setEncrypt(StringUtils.equals((CharSequence)StringBaseOpt.objectToString((Object)objs[3]), (CharSequence)"D"));
                if (objs[4] instanceof Date) {
                    file.setCreateTime((Date)objs[4]);
                }
                file.setFileSize(NumberBaseOpt.castObjectToLong((Object)objs[5]));
                files.add(file);
            }
        }
        return files;
    }

    public List<FileShowInfo> listUnitFiles(String unitCode, String fileShowPath) {
        List objects = null;
        if (StringUtils.isBlank((CharSequence)fileShowPath) || StringUtils.equals((CharSequence)fileShowPath, (CharSequence)"/")) {
            String sqlsen = "select a.FILE_NAME, max(a.FILE_ID) as FILE_ID ,count(1) as FILE_SUM, min(a.ENCRYPT_TYPE) as ENCRYPT_TYPE, max(a.CREATE_TIME) as CREATE_TIME, max(b.FILE_SIZE) as FILE_SIZE from FILE_INFO a join FILE_STORE_INFO b on a.FILE_MD5=b.FILE_MD5 where FILE_UNIT = :uc and OS_ID='FILE_SVR' and OPT_ID='LOCAL_FILE' and (FILE_SHOW_PATH is null or FILE_SHOW_PATH='' or FILE_SHOW_PATH='/') group by FILE_NAME";
            objects = DatabaseOptUtils.listObjectsByNamedSql((BaseDaoImpl)this, (String)sqlsen, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"uc", unitCode}));
        } else {
            String fsp = FileInfoDao.trimFilePath(fileShowPath);
            String sqlsen = "select a.FILE_NAME, max(a.FILE_ID) as FILE_ID ,count(1) as FILE_SUM, min(a.ENCRYPT_TYPE) as ENCRYPT_TYPE, max(a.CREATE_TIME) as CREATE_TIME, max(b.FILE_SIZE) as FILE_SIZE from FILE_INFO a join FILE_STORE_INFO b on a.FILE_MD5=b.FILE_MD5 where FILE_UNIT = :uc and OS_ID='FILE_SVR' and OPT_ID='LOCAL_FILE' and (FILE_SHOW_PATH=:fsp or FILE_SHOW_PATH=:fsp2) group by FILE_NAME";
            objects = DatabaseOptUtils.listObjectsByNamedSql((BaseDaoImpl)this, (String)sqlsen, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"uc", unitCode, "fsp", fsp, "fsp2", fsp + "/"}));
        }
        ArrayList<FileShowInfo> files = new ArrayList<FileShowInfo>();
        if (objects != null) {
            for (Object[] objs : objects) {
                FileShowInfo file = new FileShowInfo();
                file.setFileShowPath(fileShowPath);
                file.setCatalogType("d");
                file.setFileType("f");
                file.setFileName(StringBaseOpt.objectToString((Object)objs[0]));
                file.setAccessToken(StringBaseOpt.objectToString((Object)objs[1]));
                file.setVersions(NumberBaseOpt.castObjectToInteger((Object)objs[2]));
                file.setEncrypt(StringUtils.equals((CharSequence)StringBaseOpt.objectToString((Object)objs[3]), (CharSequence)"D"));
                if (objs[4] instanceof Date) {
                    file.setCreateTime((Date)objs[4]);
                }
                file.setFileSize(NumberBaseOpt.castObjectToLong((Object)objs[5]));
                files.add(file);
            }
        }
        return files;
    }

    public List<FileShowInfo> listUserFileVersions(String userCode, String fileShowPath, String fileName) {
        String sqlsen;
        List objects = null;
        if (StringUtils.isBlank((CharSequence)fileShowPath) || StringUtils.equals((CharSequence)fileShowPath, (CharSequence)".")) {
            sqlsen = "select a.FILE_ID, a.ENCRYPT_TYPE, a.CREATE_TIME, b.FILE_SIZE,c.favorite_id,a.file_type,a.download_times from FILE_INFO a join FILE_STORE_INFO b on a.FILE_MD5=b.FILE_MD5 left join file_favorite c on a.file_id=c.file_id and c.favorite_user=:favoriteUser where FILE_OWNER = :uc and file_state='N' and (FILE_SHOW_PATH is null or FILE_SHOW_PATH='' or FILE_SHOW_PATH='/') and FILE_NAME=:fn order by a.CREATE_TIME desc";
            objects = DatabaseOptUtils.listObjectsByNamedSql((BaseDaoImpl)this, (String)sqlsen, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"favoriteUser", userCode, "fn", fileName}));
        } else {
            fileShowPath = "/" + fileShowPath;
            sqlsen = "select a.FILE_ID, a.ENCRYPT_TYPE, a.CREATE_TIME, b.FILE_SIZE,c.favorite_id,a.file_type,a.download_times from FILE_INFO a join FILE_STORE_INFO b on a.FILE_MD5=b.FILE_MD5 left join file_favorite c on a.file_id=c.file_id and c.favorite_user=:favoriteUser where  file_state='N' and FILE_SHOW_PATH=:fsp and FILE_NAME=:fn order by a.CREATE_TIME desc";
            objects = DatabaseOptUtils.listObjectsByNamedSql((BaseDaoImpl)this, (String)sqlsen, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"favoriteUser", userCode, "fsp", fileShowPath, "fn", fileName}));
        }
        ArrayList<FileShowInfo> files = new ArrayList<FileShowInfo>();
        if (objects != null) {
            for (Object[] objs : objects) {
                FileShowInfo file = new FileShowInfo();
                file.setFileShowPath(fileShowPath);
                file.setCatalogType("p");
                file.setFileType(StringBaseOpt.objectToString((Object)objs[5]));
                file.setFileName(fileName);
                file.setAccessToken(StringBaseOpt.objectToString((Object)objs[0]));
                file.setVersions(1);
                file.setEncrypt(StringUtils.equals((CharSequence)StringBaseOpt.objectToString((Object)objs[1]), (CharSequence)"D"));
                if (objs[2] instanceof Date) {
                    file.setCreateTime((Date)objs[2]);
                }
                file.setFileSize(NumberBaseOpt.castObjectToLong((Object)objs[3]));
                file.setFavoriteId(StringBaseOpt.objectToString((Object)objs[4]));
                file.setDownloadTimes(NumberBaseOpt.castObjectToInteger((Object)objs[6]));
                files.add(file);
            }
        }
        return files;
    }

    public List<FileShowInfo> listUnitFileVersions(String unitCode, String fileShowPath, String fileName) {
        String sqlsen;
        List objects = null;
        if (StringUtils.isBlank((CharSequence)fileShowPath) || StringUtils.equals((CharSequence)fileShowPath, (CharSequence)".")) {
            sqlsen = "select a.FILE_ID, a.ENCRYPT_TYPE, a.CREATE_TIME, b.FILE_SIZE from FILE_INFO a join FILE_STORE_INFO b on a.FILE_MD5=b.FILE_MD5 where FILE_UNIT = :uc and OS_ID='FILE_SVR' and OPT_ID='LOCAL_FILE' and (FILE_SHOW_PATH is null or FILE_SHOW_PATH='' or FILE_SHOW_PATH='/') and FILE_NAME=:fn and FILE_STATE='A'";
            objects = DatabaseOptUtils.listObjectsByNamedSql((BaseDaoImpl)this, (String)sqlsen, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"uc", unitCode, "fn", fileName}));
        } else {
            sqlsen = "select a.FILE_ID, a.ENCRYPT_TYPE, a.CREATE_TIME, b.FILE_SIZE from FILE_INFO a join FILE_STORE_INFO b on a.FILE_MD5=b.FILE_MD5 where FILE_UNIT = :uc and OS_ID='FILE_SVR' and OPT_ID='LOCAL_FILE' and FILE_SHOW_PATH=:fsp and FILE_NAME=:fn and FILE_STATE='A'";
            objects = DatabaseOptUtils.listObjectsByNamedSql((BaseDaoImpl)this, (String)sqlsen, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"uc", unitCode, "fsp", fileShowPath, "fn", fileName}));
        }
        ArrayList<FileShowInfo> files = new ArrayList<FileShowInfo>();
        if (objects != null) {
            for (Object[] objs : objects) {
                FileShowInfo file = new FileShowInfo();
                file.setFileShowPath(fileShowPath);
                file.setCatalogType("d");
                file.setFileType("f");
                file.setFileName(fileName);
                file.setAccessToken(StringBaseOpt.objectToString((Object)objs[0]));
                file.setVersions(1);
                file.setEncrypt(StringUtils.equals((CharSequence)StringBaseOpt.objectToString((Object)objs[1]), (CharSequence)"D"));
                if (objs[2] instanceof Date) {
                    file.setCreateTime((Date)objs[2]);
                }
                file.setFileSize(NumberBaseOpt.castObjectToLong((Object)objs[3]));
                files.add(file);
            }
        }
        return files;
    }

    public List<FileInfo> listFileStoreInfo(String libraryCode, String fileShowPath, String fileName) {
        List objects = null;
        if (StringUtils.isBlank((CharSequence)fileShowPath) || StringUtils.equals((CharSequence)fileShowPath, (CharSequence)".")) {
            String hqlsen = "where FILE_UNIT = ? and (FILE_SHOW_PATH is null or FILE_SHOW_PATH='' or FILE_SHOW_PATH='/') and FILE_NAME = ? order by CREATE_TIME desc";
            objects = this.listObjectsByFilter(hqlsen, new Object[]{libraryCode, fileName});
        } else {
            String hqlsen = "where FILE_UNIT = ? and FILE_SHOW_PATH = ? and FILE_NAME = ? order by CREATE_TIME desc";
            objects = this.listObjectsByFilter(hqlsen, new Object[]{libraryCode, fileShowPath, fileName});
        }
        return objects;
    }

    public FileInfo getListVersionFileByPath(String libraryCode, String parentFolder, String fileName) {
        List objects = null;
        String hqlsen = "where FILE_UNIT = ? and parent_folder = ? and FILE_NAME = ? order by CREATE_TIME  desc";
        objects = this.listObjectsByFilter(hqlsen, new Object[]{libraryCode, parentFolder, fileName});
        return objects != null && objects.size() > 0 ? (FileInfo)objects.get(0) : null;
    }
}

