/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.po.FileFavorite;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.po.FileStoreInfo;
import com.centit.fileserver.service.FileFavoriteManager;
import com.centit.fileserver.service.FileInfoManager;
import com.centit.fileserver.service.FileStoreInfoManager;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.search.document.FileDocument;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESIndexer;
import com.centit.search.service.Impl.ESSearcher;
import com.centit.search.service.IndexerSearcherFactory;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JSONOpt;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/files"})
@Api(value="\u6587\u4ef6\u7ba1\u7406", tags={"\u6587\u4ef6\u7ba1\u7406"})
public class FileManagerController
extends BaseController {
    private Logger logger = LoggerFactory.getLogger(FileManagerController.class);
    @Autowired
    private FileInfoManager fileInfoManager;
    @Autowired
    private FileStoreInfoManager fileStoreInfoManager;
    @Autowired
    protected FileStore fileStore;
    @Autowired(required=false)
    private ESServerConfig esServerConfig;
    @Autowired(required=false)
    private FileFavoriteManager fileFavoriteManager;

    public ESSearcher fetchDocumentSearcher() {
        if (this.esServerConfig == null) {
            return null;
        }
        return IndexerSearcherFactory.obtainSearcher((ESServerConfig)this.esServerConfig, FileDocument.class);
    }

    public ESIndexer fetchDocumentIndexer() {
        if (this.esServerConfig == null) {
            return null;
        }
        return IndexerSearcherFactory.obtainIndexer((ESServerConfig)this.esServerConfig, FileDocument.class);
    }

    @RequestMapping(value={"/{fileId}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="\u6839\u636e\u6587\u4ef6\u7684id\u903b\u8f91\u5220\u9664\u6587\u4ef6(\u540c\u65f6\u5220\u9664\u6587\u4ef6\u548c\u6570\u636e\u5e93\u8bb0\u5f55)")
    public void delete(@PathVariable(value="fileId") String fileId, HttpServletRequest request, HttpServletResponse response) {
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        if (fileInfo != null) {
            this.fileInfoManager.deleteObjectById((Serializable)((Object)fileId));
            if (this.esServerConfig == null) {
                this.fetchDocumentIndexer().deleteDocument(fileId);
            }
            this.fileStoreInfoManager.decreaseFileReference(fileInfo.getFileMd5());
            OperationLogCenter.log((OperationLog)OperationLog.create().operation("FileServerLog").user(WebOptUtils.getCurrentUserCode((HttpServletRequest)request)).unit(fileInfo.getLibraryId()).topUnit(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request)).correlation(WebOptUtils.getCorrelationId((HttpServletRequest)request)).loginIp(WebOptUtils.getRequestAddr((HttpServletRequest)request)).method("\u5220\u9664\u6587\u4ef6").tag(fileInfo.getFileMd5()).content(fileInfo.getFileName()).oldObject((Object)fileInfo));
            JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + fileId), (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/force/{fileId}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="\u6839\u636e\u6587\u4ef6\u7684id\u7269\u7406\u5220\u9664\u6587\u4ef6(\u540c\u65f6\u5220\u9664\u6587\u4ef6\u548c\u6570\u636e\u5e93\u8bb0\u5f55)")
    public void deleteForce(@PathVariable(value="fileId") String fileId, HttpServletResponse response) {
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        if (fileInfo != null) {
            FileStoreInfo fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
            String path = fileStoreInfo.getFileStorePath();
            try {
                this.fileStore.deleteFile(path);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                JsonResultUtils.writeErrorMessageJson((String)e.getMessage(), (HttpServletResponse)response);
                return;
            }
            fileInfo.setFileState("D");
            this.fileInfoManager.updateObject((Serializable)fileInfo);
            JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + fileId), (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/{fileId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u6587\u4ef6\u7684id\u83b7\u53d6\u6587\u4ef6\u5b58\u50a8\u4fe1\u606f")
    public void getFileStoreInfo(@PathVariable(value="fileId") String fileId, HttpServletRequest request, HttpServletResponse response) {
        FileInfo fileInfo;
        fileInfo.setFileState("N".equals((fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId))).getFileState()) ? "\u6b63\u5e38" : "\u5220\u9664");
        if (fileInfo.getEncryptType() == null) {
            fileInfo.setEncryptType("\u672a\u52a0\u5bc6");
        } else {
            switch (fileInfo.getEncryptType()) {
                case "A": {
                    fileInfo.setEncryptType("AES\u52a0\u5bc6\u6587\u4ef6");
                    break;
                }
                case "Z": {
                    fileInfo.setEncryptType("Zip\u538b\u7f29\u6587\u4ef6");
                    break;
                }
                default: {
                    fileInfo.setEncryptType("\u672a\u52a0\u5bc6");
                }
            }
        }
        fileInfo.setIndexState("I".equals(fileInfo.getIndexState()) ? "\u5168\u6587\u68c0\u7d22" : "\u672a\u68c0\u7d22");
        FileStoreInfo fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
        if (fileStoreInfo != null) {
            fileInfo.setFileSize(fileStoreInfo.getFileSize().longValue());
        }
        if (fileInfo != null) {
            JsonResultUtils.writeSingleDataJson((Object)fileInfo, (HttpServletResponse)response);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + fileId), (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/size/{fileStoreUrl}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u6587\u4ef6\u7684id\u83b7\u53d6\u6587\u4ef6\u5b58\u50a8\u4fe1\u606f")
    @WrapUpResponseBody
    public Long getFileSizeByStoreUrl(@PathVariable(value="fileStoreUrl") String fileStoreUrl) {
        try {
            return this.fileStore.getFileSize(fileStoreUrl);
        }
        catch (IOException e) {
            this.logger.error("\u83b7\u53d6\u6587\u4ef6\u957f\u5ea6\u5f02\u5e38,\u6587\u4ef6\u50a8\u5b58\u8def\u5f84" + fileStoreUrl + ",\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    @RequestMapping(value={"/matchFileStoreUrl/{fileSize}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u5b58\u50a8url")
    @WrapUpResponseBody
    public String matchFileStoreUrl(@PathVariable(value="fileSize") String fileSize, @Valid FileInfo fileInfo) {
        return this.fileStore.matchFileStoreUrl((FileBaseInfo)fileInfo, NumberBaseOpt.castObjectToLong((Object)fileSize, (Long)0L).longValue());
    }

    private void updateFileStoreInfo(String fileId, FileInfo fileInfo, HttpServletResponse response) {
        FileInfo dbFileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        if (dbFileInfo != null) {
            dbFileInfo.copyNotNullProperty(fileInfo);
            dbFileInfo.setFileName(fileInfo.getFileName());
            if (StringUtils.isBlank((CharSequence)fileInfo.getFileId())) {
                dbFileInfo.setFileId(null);
                this.fileInfoManager.saveNewFile(dbFileInfo);
            } else {
                this.fileInfoManager.updateObject((Serializable)fileInfo);
            }
            JsonResultUtils.writeSingleDataJson((Object)fileInfo, (HttpServletResponse)response);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + fileInfo.getFileId()), (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/{fileId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6839\u636e\u6587\u4ef6\u7684id\u4fee\u6539\u6587\u4ef6\u5b58\u50a8\u4fe1\u606f\uff0c\u6587\u4ef6\u4fe1\u606f\u6309\u7167\u8868\u5355\u7684\u5f62\u5f0f\u4f20\u9001")
    public void postFileStoreInfo(@PathVariable(value="fileId") String fileId, @Valid FileInfo fileInfo, HttpServletResponse response) {
        this.updateFileStoreInfo(fileId, fileInfo, response);
    }

    @RequestMapping(value={"/j/{fileId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6839\u636e\u6587\u4ef6\u7684id\u4fee\u6539\u6587\u4ef6\u5b58\u50a8\u4fe1\u606f\uff0c\u6587\u4ef6\u4fe1\u606f\u6309\u7167json\u7684\u5f62\u5f0f\u4f20\u9001")
    public void jsonpostFileStoreInfo(@PathVariable(value="fileId") String fileId, @RequestBody FileInfo fileInfo, HttpServletResponse response) {
        this.updateFileStoreInfo(fileId, fileInfo, response);
    }

    @RequestMapping(method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u76f8\u5173\u7684\u6761\u4ef6\u67e5\u8be2\u6587\u4ef6")
    public void listStoredFiles(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        if ("".equals(request.getParameter("files"))) {
            return;
        }
        Map queryParamsMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        if (queryParamsMap.get("files") != null) {
            queryParamsMap.put("files", Arrays.asList(queryParamsMap.get("files").toString().split(",")));
        }
        JSONArray listObjects = this.fileInfoManager.listStoredFiles(queryParamsMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/oss"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u4e2d\u7684\u6240\u6709OS")
    public void listOperationSystem(HttpServletRequest request, HttpServletResponse response) {
        List osinfoList = CodeRepositoryUtil.listOsInfo((String)WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        JsonResultUtils.writeSingleDataJson((Object)osinfoList, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/optids/{osId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u6240\u6709\u64cd\u4f5c")
    public void listOptsByOs(@PathVariable(value="osId") String osId, HttpServletResponse response) {
        JSONArray listObjects = this.fileInfoManager.listOptsByOs(osId);
        JsonResultUtils.writeSingleDataJson((Object)listObjects, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/owner/{osId}/{optId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u6240\u6709\u6587\u4ef6\u5c5e\u4e3b")
    public void listFileOwners(@PathVariable(value="osId") String osId, @PathVariable(value="optId") String optId, HttpServletResponse response) {
        JSONArray listObjects = this.fileInfoManager.listFileOwners(osId, optId);
        JsonResultUtils.writeSingleDataJson((Object)listObjects, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/files/{osId}/{optId}/{owner}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u6240\u6709\u6587\u4ef6")
    public void listFilesByOwner(@PathVariable(value="osId") String osId, @PathVariable(value="optId") String optId, @PathVariable(value="owner") String owner, HttpServletResponse response) {
        JSONArray listObjects = this.fileInfoManager.listFilesByOwner(osId, optId, owner);
        JsonResultUtils.writeSingleDataJson((Object)listObjects, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/authcode/{fileId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u6587\u4ef6\u7684id\u83b7\u53d6\u9a8c\u8bc1\u7801")
    @WrapUpResponseBody
    public Map<String, Object> getAuthCode(@PathVariable(value="fileId") String fileId, HttpServletRequest request) {
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        if (StringUtils.isBlank((CharSequence)fileInfo.getAuthCode())) {
            fileInfo.setAuthCode(StringUtils.substring((String)UuidOpt.getUuidAsString(), (int)-4));
            this.fileInfoManager.updateObject((Serializable)fileInfo);
        }
        OperationLogCenter.log((OperationLog)OperationLog.create().operation("FileServerLog").user(WebOptUtils.getCurrentUserCode((HttpServletRequest)request)).unit(fileInfo.getLibraryId()).topUnit(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request)).correlation(WebOptUtils.getCorrelationId((HttpServletRequest)request)).loginIp(WebOptUtils.getRequestAddr((HttpServletRequest)request)).method("\u5206\u4eab").tag(fileId).content(fileInfo.getFileName()).newObject((Object)fileInfo));
        return CollectionsOpt.createHashMap((Object[])new Object[]{"authcode", fileInfo.getAuthCode(), "uri", "/checkauth/" + fileId});
    }

    @RequestMapping(value={"/checkauth/{fileId}/{authCode}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u68c0\u67e5\u9a8c\u8bc1\u7801")
    @WrapUpResponseBody
    public JSONObject checkAuthCode(@PathVariable(value="fileId") String fileId, @PathVariable(value="authCode") String authCode) {
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        if (fileInfo.getAuthCode().equals(authCode)) {
            return this.fileInfoManager.listStoredFiles(CollectionsOpt.createHashMap((Object[])new Object[]{"files", fileId}), null).getJSONObject(0);
        }
        return JSONOpt.objectToJSONObject((Object)"");
    }

    @ApiOperation(value="\u5168\u6587\u68c0\u7d22")
    @ApiImplicitParams(value={@ApiImplicitParam(name="libraryIds", value="\u5e93ids", required=true, paramType="query", dataType="String", allowMultiple=true), @ApiImplicitParam(name="query", value="\u68c0\u7d22\u5173\u952e\u5b57", required=true, paramType="query", dataType="String")})
    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Map<String, Object>> searchObject(String[] libraryIds, String query, HttpServletRequest request, PageDesc pageDesc) {
        Pair res;
        if (this.esServerConfig == null) {
            throw new ObjectException(612, "\u6ca1\u6709\u6b63\u786e\u914d\u7f6eElastic Search");
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        HashMap<String, String[]> searchQuery = new HashMap<String, String[]>(10);
        if (libraryIds != null) {
            searchQuery.put("optId", libraryIds);
        }
        if ((res = this.fetchDocumentSearcher().search(searchQuery, query, pageDesc.getPageNo(), pageDesc.getPageSize())) == null) {
            throw new ObjectException("ELK\u5f02\u5e38");
        }
        pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)res.getLeft()));
        return PageQueryResult.createResult(this.change(topUnit, (List)res.getRight(), WebOptUtils.getCurrentUserCode((HttpServletRequest)request)), (PageDesc)pageDesc);
    }

    private List<Map<String, Object>> change(String topUnit, List<Map<String, Object>> mapList, String userCode) {
        if (mapList == null || mapList.isEmpty()) {
            return mapList;
        }
        mapList.forEach(e -> {
            e.put("showPath", this.fileFavoriteManager.getShowPath(topUnit, StringBaseOpt.castObjectToString(e.get("optUrl")), StringBaseOpt.castObjectToString(e.get("optId"))));
            List<FileFavorite> list = this.fileFavoriteManager.listFileFavorite(topUnit, CollectionsOpt.createHashMap((Object[])new Object[]{"fileId", e.get("fileId"), "favoriteUser", userCode}), null);
            if (list != null && !list.isEmpty()) {
                e.put("favoriteId", list.get(0).getFavoriteId());
            } else {
                e.put("favoriteId", "");
            }
        });
        return mapList;
    }
}

