/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.po;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.framework.model.basedata.IDataDictionary;
import com.centit.framework.system.po.DataDictionaryId;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

@Entity
@Table(name="F_DATADICTIONARY")
@ApiModel(value="\u6570\u636e\u5b57\u5178\u5bf9\u8c61", description="\u6570\u636e\u5b57\u5178\u7c7b\u522b\u5bf9\u8c61DataDictionary")
public class DataDictionary
implements IDataDictionary,
Serializable {
    private static final long serialVersionUID = -4063651885248484498L;
    @EmbeddedId
    private DataDictionaryId id;
    @Column(name="EXTRA_CODE")
    @Length(max=16, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=16, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String extraCode;
    @Column(name="EXTRA_CODE2")
    @Length(max=16, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=16, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String extraCode2;
    @Column(name="DATA_TAG")
    @ValueGenerator(strategy=GeneratorType.CONSTANT, occasion=GeneratorTime.NEW, value="T")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}")
    @ApiModelProperty(value="\u6807\u5fd7\u7b26\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u957f\u5ea6\u4e3a1", name="dataTag", required=true)
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}") String dataTag;
    @Column(name="DATA_VALUE")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=2048, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u6570\u636e\u503c\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e2048", name="dataValue", required=true)
    private @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=2048, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String dataValue;
    @Transient
    private JSONObject jsonData;
    @Column(name="DATA_STYLE")
    @ValueGenerator(strategy=GeneratorType.CONSTANT, occasion=GeneratorTime.NEW, value="U")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}")
    @Pattern(regexp="[SUF]", message="\u5b57\u6bb5\u53ea\u80fd\u586b\u5199F,S,U")
    @ApiModelProperty(value="\u6570\u636e\u503c\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e1\uff0c\u5b57\u6bb5\u53ea\u80fd\u586b\u5199F,S,U", name="dataStyle", required=true)
    @DictionaryMap(fieldName={"dataStyle"}, value={"CatalogStyleText"})
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}") @Pattern(regexp="[SUF]", message="\u5b57\u6bb5\u53ea\u80fd\u586b\u5199F,S,U") String dataStyle;
    @OrderBy
    @Column(name="DATA_ORDER")
    private Integer dataOrder;
    @Column(name="DATA_DESC")
    @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String dataDesc;
    @Column(name="CREATE_DATE", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date createDate;
    @Column(name="LAST_MODIFY_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date lastModifyDate;

    public DataDictionary() {
        this.id = new DataDictionaryId();
        this.dataTag = "N";
    }

    public DataDictionary(DataDictionaryId id) {
        this.id = id;
        this.dataTag = "N";
    }

    public DataDictionary(DataDictionaryId id, String extracode, String extracode2, String datatag, String datavalue, String datastyle, String datadesc) {
        this.id = id;
        this.extraCode = extracode;
        this.extraCode2 = extracode2;
        this.dataTag = datatag;
        this.dataValue = datavalue;
        this.dataStyle = datastyle;
        this.dataDesc = datadesc;
    }

    public DataDictionaryId getId() {
        return this.id;
    }

    public void setId(DataDictionaryId id) {
        this.id = id;
    }

    public String getDataCode() {
        if (this.id == null) {
            return null;
        }
        return this.id.getDataCode();
    }

    public void setDataCode(String datacode) {
        if (this.id == null) {
            this.id = new DataDictionaryId();
        }
        this.id.setDataCode(datacode);
    }

    public String getCatalogCode() {
        if (this.id == null) {
            return null;
        }
        return this.id.getCatalogCode();
    }

    public void setCatalogCode(String catalogcode) {
        if (this.id == null) {
            this.id = new DataDictionaryId();
        }
        this.id.setCatalogCode(catalogcode);
    }

    public String getExtraCode() {
        return this.extraCode;
    }

    public void setExtraCode(String extracode) {
        this.extraCode = extracode;
    }

    public String getExtraCode2() {
        return this.extraCode2;
    }

    public void setExtraCode2(String extracode2) {
        this.extraCode2 = extracode2;
    }

    public String getDataTag() {
        return this.dataTag;
    }

    public String getState() {
        if (this.dataTag == null) {
            this.dataTag = "N";
        }
        return this.dataTag;
    }

    public void setDataTag(String datastate) {
        this.dataTag = datastate;
    }

    public String getDataValue() {
        return this.dataValue;
    }

    public String getLocalDataValue(String lang) {
        if (this.dataValue == null) {
            return null;
        }
        if (this.jsonData == null) {
            if (this.dataValue.startsWith("{") && this.dataValue.endsWith("}")) {
                this.jsonData = JSON.parseObject((String)this.dataValue);
            } else {
                return this.dataValue;
            }
        }
        String sRet = null;
        if (this.jsonData != null) {
            if (lang == null) {
                sRet = this.jsonData.getString("zh_CN");
            } else {
                sRet = this.jsonData.getString(lang);
                if (sRet == null) {
                    sRet = this.jsonData.getString("zh_CN");
                }
            }
        }
        return sRet;
    }

    public String getFullKey() {
        return this.id.getCatalogCode() + "." + this.id.getDataCode();
    }

    public String toString() {
        return this.dataValue;
    }

    public void setDataValue(String datavalue) {
        this.dataValue = datavalue;
    }

    public String getDataStyle() {
        return this.dataStyle;
    }

    public void setDataStyle(String datastyle) {
        this.dataStyle = datastyle;
    }

    public String getDataDesc() {
        return this.dataDesc;
    }

    public void setDataDesc(String datadesc) {
        this.dataDesc = datadesc;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getLastModifyDate() {
        return this.lastModifyDate;
    }

    public void setLastModifyDate(Date lastModifyDate) {
        this.lastModifyDate = lastModifyDate;
    }

    public String display() {
        return "\u5b57\u5178\u660e\u7ec6\u4fe1\u606f [\u6807\u8bb0=" + this.dataTag + ", \u6807\u5fd7\u7b26=" + this.dataValue + ", \u7c7b\u578b=" + this.dataStyle + ", \u6570\u636e\u63cf\u8ff0=" + this.dataDesc + "]";
    }

    public Integer getDataOrder() {
        return this.dataOrder;
    }

    public void setDataOrder(Integer dataOrder) {
        this.dataOrder = dataOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataDictionary that = (DataDictionary)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

