/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.po.DataCatalog;
import com.centit.framework.system.po.DataDictionary;
import com.centit.framework.system.po.DataDictionaryId;
import com.centit.framework.system.service.DataDictionaryManager;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/dictionary"})
@Api(tags={"\u6846\u67b6\u6570\u636e\u5b57\u5178\u64cd\u4f5c\u63a5\u53e3"}, value="\u6846\u67b6\u6570\u636e\u5b57\u5178\u63a5\u53e3")
public class DataDictionaryController
extends BaseController {
    public static final String F = "F";
    public static final String S = "S";
    public static final String U = "U";
    public static final String T = "T";
    @Value(value="${app.local.multiLang:false}")
    private boolean multiLang;
    @Autowired
    private DataDictionaryManager dataDictionaryManager;

    public String getOptId() {
        return "DICTSET";
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u76ee\u5f55\u5217\u8868", notes="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u76ee\u5f55\u5217\u8868\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="field", value="\u6307\u9700\u8981\u663e\u793a\u7684\u5c5e\u6027\u540d", allowMultiple=true, paramType="query", dataType="array"), @ApiImplicitParam(name="pageDesc", value="\u5206\u9875\u5bf9\u8c61", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<DataCatalog> list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        List<DataCatalog> listObjects = this.dataDictionaryManager.listObjects(searchColumn, pageDesc);
        return PageQueryResult.createResultMapDict(listObjects, (PageDesc)pageDesc, (String[])field);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5b57\u5178\u76ee\u5f55", notes="\u6839\u636e\u6570\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u67e5\u8be2\u5355\u4e2a\u5b57\u5178\u76ee\u5f55\u3002")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{catalogCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getCatalog(@PathVariable String catalogCode) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getCatalogIncludeDataPiece(catalogCode);
        return ResponseData.makeResponseData((Object)dbDataCatalog);
    }

    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u67e5\u8be2\u5b57\u5178\u662f\u5426\u4e0d\u5b58\u5728", notes="\u6839\u636e\u6570\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u67e5\u8be2\u5b57\u5178\u662f\u5426\u4e0d\u5b58\u5728\u3002")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/notexists/{catalogCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public boolean isNotExistsCatalogCode(@PathVariable String catalogCode) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        return null == dbDataCatalog;
    }

    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5b57\u5178\u540d\u5b57\u4ee3\u7801\u67e5\u8be2\u5b57\u5178\u662f\u5426\u5b58\u5728", notes="\u6839\u636e\u6570\u636e\u5b57\u5178\u540d\u5b57\u4ee3\u7801\u67e5\u8be2\u5b57\u5178\u662f\u5426\u5b58\u5728\u3002")
    @ApiImplicitParam(name="catalogName", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u540d\u5b57", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/existcatalogname/{catalogName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public int isExistsCatalogName(@PathVariable String catalogName) {
        return this.dataDictionaryManager.existCatalogName(catalogName);
    }

    @ApiOperation(value="\u6821\u9a8c\u6570\u636e\u4ee3\u7801\u662f\u5426\u5b58\u5728", notes="\u6839\u636e\u6570\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u548c\u6570\u636e\u4ee3\u7801\u5224\u65ad\u5b57\u5178\u662f\u5426\u5b58\u5728")
    @ApiImplicitParams(value={@ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="dataCode", value="\u6570\u636e\u5b57\u5178\u7684\u6570\u636e\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/notexists/dictionary/{catalogCode}/{dataCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public boolean isNotExistsDataCode(@PathVariable String catalogCode, @PathVariable String dataCode) {
        DataDictionary dbDataDictionary = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(catalogCode, dataCode));
        return null == dbDataDictionary;
    }

    @ApiOperation(value="\u65b0\u589e\u5b57\u5178\u7c7b\u522b", notes="\u65b0\u589e\u5b57\u5178\u7c7b\u522b")
    @ApiParam(name="dataCatalog", value="\u65b0\u589e\u5b57\u5178\u7c7b\u522b,\u8f93\u5165\u6846\u6709\u63d0\u793a\u7684\u90fd\u662f\u5fc5\u586b\u9879", required=true)
    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u5b57\u5178\u7c7b\u522b")
    @WrapUpResponseBody
    public void createCatalog(@Valid DataCatalog dataCatalog, HttpServletRequest request) {
        boolean isAdmin = this.isLoginAsAdmin(request);
        if (isAdmin) {
            dataCatalog.setCatalogStyle(S);
        } else {
            dataCatalog.setCatalogStyle(U);
        }
        this.dataDictionaryManager.saveNewObject(dataCatalog);
        if (dataCatalog.getDataDictionaries() != null && dataCatalog.getDataDictionaries().size() > 0) {
            for (DataDictionary d : dataCatalog.getDataDictionaries()) {
                if (StringUtils.isBlank((CharSequence)d.getDataStyle())) {
                    d.setDataStyle(isAdmin ? S : U);
                }
                d.setCatalogCode(dataCatalog.getCatalogCode());
            }
            this.dataDictionaryManager.saveCatalogIncludeDataPiece(dataCatalog, isAdmin);
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u5b57\u5178\u7c7b\u522b", notes="\u66f4\u65b0\u5b57\u5178\u7c7b\u522b\u4fe1\u606f")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @ApiParam(name="dataCatalog", value="\u66f4\u65b0\u5b57\u5178\u7c7b\u522b\u65b0\u7684\u5bf9\u8c61\u4fe1\u606f", required=true)
    @RequestMapping(value={"/{catalogCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u5b57\u5178\u7c7b\u522b")
    @WrapUpResponseBody
    public ResponseData updateCatalog(@PathVariable String catalogCode, @Valid DataCatalog dataCatalog) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        if (null == dbDataCatalog) {
            return ResponseData.makeErrorMessage((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        DataCatalog oldValue = new DataCatalog();
        BeanUtils.copyProperties((Object)dbDataCatalog, (Object)oldValue);
        BeanUtils.copyProperties((Object)dataCatalog, (Object)dbDataCatalog, (String[])new String[]{"catalogStyle", "catalogCode", "dataDictionaries"});
        this.dataDictionaryManager.updateCatalog(dbDataCatalog);
        return ResponseData.successResponse;
    }

    private boolean isLoginAsAdmin(HttpServletRequest request) {
        Object obj = request.getSession().getAttribute("ENTRANCE_TYPE");
        return obj != null && "DEPLOY".equals(obj.toString());
    }

    @ApiOperation(value="\u66f4\u65b0\u5b57\u5178\u76ee\u5f55\u660e\u7ec6", notes="\u66f4\u65b0\u5b57\u5178\u76ee\u5f55\u660e\u7ec6\uff0c\u76ee\u5f55\u660e\u663e\u5bf9\u8c61\u5c31\u662fdataDictionaries[]\u91cc\u9762\u7684\u5c5e\u6027\u7ec4\u6210")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @ApiParam(name="dataCatalog", value="\u66f4\u65b0\u5b57\u5178\u7c7b\u522b\u65b0\u7684\u5bf9\u8c61\u4fe1\u606f", required=true)
    @RequestMapping(value={"/update/{catalogCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u5b57\u5178\u76ee\u5f55\u660e\u7ec6")
    @WrapUpResponseBody
    public ResponseData updateDictionary(@PathVariable String catalogCode, @Valid DataCatalog dataCatalog, HttpServletRequest request) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        if (null == dbDataCatalog) {
            return ResponseData.makeErrorMessage((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        boolean isAdmin = this.isLoginAsAdmin(request);
        String dataStyle = isAdmin ? S : U;
        for (DataDictionary d : dataCatalog.getDataDictionaries()) {
            if (!StringUtils.isBlank((CharSequence)d.getDataStyle())) continue;
            d.setDataStyle(dataStyle);
        }
        dbDataCatalog.addAllDataPiece(dataCatalog.getDataDictionaries());
        this.dataDictionaryManager.updateCatalog(dataCatalog);
        this.dataDictionaryManager.saveCatalogIncludeDataPiece(dbDataCatalog, isAdmin);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u65b0\u589e\u67d0\u4e2a\u5b57\u5178\u76ee\u5f55\u91cc\u7684\u5b57\u5178\u660e\u7ec6", notes="\u65b0\u589e\u67d0\u4e2a\u5b57\u5178\u76ee\u5f55\u91cc\u7684\u5b57\u5178\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="dataCode", value="\u6570\u636e\u5b57\u5178\u7684\u660e\u7ec6\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @ApiParam(name="dataDictionary", value="\u5b57\u5178\u660e\u7ec6\u7684\u5bf9\u8c61\u4fe1\u606f", required=true)
    @RequestMapping(value={"/dictionary/{catalogCode}/{dataCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u6570\u636e\u5b57\u5178")
    @WrapUpResponseBody
    public ResponseData createDictionary(@PathVariable String catalogCode, @PathVariable String dataCode, @Valid DataDictionary dataDictionary, HttpServletRequest request) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        this.dictionaryPreHandler(dbDataCatalog, dataDictionary);
        this.dictionaryPreInsertHandler(dbDataCatalog, dataDictionary, request);
        this.dataDictionaryManager.saveDataDictionaryPiece(dataDictionary);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u66f4\u65b0\u67d0\u4e2a\u5b57\u5178\u76ee\u5f55\u91cc\u7684\u5b57\u5178\u660e\u7ec6", notes="\u66f4\u65b0\u67d0\u4e2a\u5b57\u5178\u76ee\u5f55\u91cc\u7684\u5b57\u5178\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="dataCode", value="\u6570\u636e\u5b57\u5178\u7684\u660e\u7ec6\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @ApiParam(name="dataDictionary", value="\u5b57\u5178\u660e\u7ec6\u7684\u5bf9\u8c61\u4fe1\u606f", required=true)
    @RequestMapping(value={"/dictionary/{catalogCode}/{dataCode}"}, method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u6570\u636e\u5b57\u5178")
    @WrapUpResponseBody
    public ResponseData editDictionary(@PathVariable String catalogCode, @PathVariable String dataCode, @Valid DataDictionary dataDictionary, HttpServletRequest request, HttpServletResponse response) {
        DataDictionary dbDataDictionary = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(catalogCode, dataCode));
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        this.dictionaryPreHandler(dbDataCatalog, dataDictionary);
        this.dictionaryPreUpdateHandler(dbDataCatalog, dbDataDictionary, request);
        BeanUtils.copyProperties((Object)dataDictionary, (Object)dbDataDictionary, (String[])new String[]{"id", "dataStyle"});
        this.dictionaryPreUpdateHandler(dbDataCatalog, dbDataDictionary, request);
        this.dataDictionaryManager.saveDataDictionaryPiece(dbDataDictionary);
        return ResponseData.successResponse;
    }

    protected void dictionaryPreHandler(DataCatalog dataCatalog, DataDictionary dataDictionary) {
        if (T.equalsIgnoreCase(dataCatalog.getCatalogType())) {
            String extraCode = dataDictionary.getExtraCode();
            if (StringUtils.isBlank((CharSequence)extraCode)) {
                throw new ObjectException("extraCode \u5b57\u6bb5\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (extraCode.equals(dataDictionary.getDataCode())) {
                throw new ObjectException("extraCode \u4e0e dataCode \u4e0d\u80fd\u4e00\u81f4");
            }
            DataDictionary dd = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(dataDictionary.getCatalogCode(), extraCode));
            if (null == dd) {
                throw new ObjectException("\u5f53\u524d\u7236\u8282\u70b9\u4e0d\u5b58\u5728");
            }
        }
    }

    protected void dictionaryPreInsertHandler(DataCatalog dataCatalog, DataDictionary dataDictionary, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            dataDictionary.setDataStyle(S);
        } else {
            if (!S.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
                throw new ObjectException("catalogStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 S \u6216 U");
            }
            dataDictionary.setDataStyle(U);
            if (!U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException("dataStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 U");
            }
        }
    }

    protected void dictionaryPreDeleteHandler(DataCatalog dataCatalog, DataDictionary dataDictionary, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            if (!S.equalsIgnoreCase(dataDictionary.getDataStyle()) && !U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException("\u53ea\u80fd\u5220\u9664 catalogStyle\u4e3a S \u6216 U \u7684\u5b57\u5178\u76ee\u5f55");
            }
        } else if (!U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
            throw new ObjectException("dataStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 U");
        }
    }

    protected void dictionaryPreUpdateHandler(DataCatalog dataCatalog, DataDictionary dataDictionary, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            if (F.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException("dataStyle \u4e3a F \u7c7b\u578b\u7684\u6570\u636e\u5b57\u5178\uff0c\u4efb\u4f55\u5730\u65b9\u90fd\u4e0d\u5141\u8bb8\u7f16\u8f91\uff0c\u53ea\u80fd\u6709\u5f00\u53d1\u4eba\u5458\u7ed9\u51fa\u66f4\u65b0\u811a\u672c\u6dfb\u52a0\u3001\u66f4\u6539\u548c\u5220\u9664");
            }
            if (F.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !S.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException("\u53ea\u80fd\u4fee\u6539 dataStyle \u4e3a S \u7684\u6570\u636e\u5b57\u5178");
            }
            if (!S.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
                throw new ObjectException("catalogStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 S \u6216 U");
            }
            if (!S.equalsIgnoreCase(dataDictionary.getDataStyle()) && !U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException("dataStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 S \u6216 U");
            }
        } else if (!U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
            throw new ObjectException("dataStyle \u5b57\u6bb5\u53ea\u53ef\u586b\u5199 U");
        }
    }

    protected void catalogPrDeleteHandler(DataCatalog dataCatalog, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            if (!S.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
                throw new ObjectException("\u53ea\u80fd\u5220\u9664 catalogStyle\u4e3a S \u6216 U \u7684\u5b57\u5178\u76ee\u5f55");
            }
        } else if (!U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
            throw new ObjectException("\u53ea\u53ef\u5220\u9664 catalogStyle \u4e3a U \u7684\u5b57\u5178\u76ee\u5f55");
        }
    }

    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5b57\u5178\u76ee\u5f55\u4ee3\u7801\u5220\u9664\u5b57\u5178\u76ee\u5f55", notes="\u6839\u636e\u6570\u636e\u5b57\u5178\u76ee\u5f55\u4ee3\u7801\u5220\u9664\u5b57\u5178\u76ee\u5f55\u3002")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u76ee\u5f55\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{catalogCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u5b57\u5178\u76ee\u5f55")
    @WrapUpResponseBody
    public ResponseData deleteCatalog(@PathVariable String catalogCode, HttpServletRequest request, HttpServletResponse response) {
        DataCatalog dataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        this.catalogPrDeleteHandler(dataCatalog, request);
        this.dataDictionaryManager.deleteDataDictionary(catalogCode);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u5220\u9664\u5b57\u5178\u660e\u7ec6", notes="\u6839\u636e\u5b57\u5178\u7c7b\u522b\u548c\u5b57\u5178\u660e\u7ec6\u4ee3\u7801\u5220\u9664\u5b57\u5178\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="dataCode", value="\u6570\u636e\u5b57\u5178\u7684\u660e\u7ec6\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/dictionary/{catalogCode}/{dataCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u6570\u636e\u5b57\u5178")
    @WrapUpResponseBody
    public ResponseData deleteDictionary(@PathVariable String catalogCode, @PathVariable String dataCode, HttpServletRequest request, HttpServletResponse response) {
        DataCatalog dataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        DataDictionary dataDictionary = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(catalogCode, dataCode));
        this.dictionaryPreDeleteHandler(dataCatalog, dataDictionary, request);
        this.dataDictionaryManager.deleteDataDictionaryPiece(dataDictionary.getId());
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u7684\u6240\u6709\u660e\u7ec6\u4fe1\u606f", notes="\u6839\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u83b7\u53d6\u5b57\u5178\u7684\u6240\u4ee5\u660e\u7ec6\u4fe1\u606f")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/dictionaryPiece/{catalogCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getDataDictionary(@PathVariable String catalogCode) {
        List<DataDictionary> datas = this.dataDictionaryManager.getDataDictionary(catalogCode);
        return ResponseData.makeResponseData(datas);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u7684\u8be6\u7ec6\u4fe1\u606f", notes="\u6839\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u83b7\u53d6\u5b57\u5178\u7684\u8be6\u7ec6\u4fe1\u606f")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/editDictionary/{catalogCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getDataDictionaryDetail(@PathVariable String catalogCode) {
        List<DataDictionary> datas = this.dataDictionaryManager.getDataDictionary(catalogCode);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("dataDictionary", datas);
        resData.addResponseData("multiLang", (Object)this.multiLang);
        resData.addResponseData("langs", (Object)CodeRepositoryUtil.getLabelValueMap((String)"SUPPORT_LANG"));
        return resData;
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u4ee5\u5b57\u5178\u76ee\u5f55\u4fe1\u606f", notes="\u83b7\u53d6\u6240\u4ee5\u5b57\u5178\u76ee\u5f55\u4fe1\u606f")
    @RequestMapping(value={"/allCatalog"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getAllCatalog() {
        List<DataCatalog> catalogs = this.dataDictionaryManager.listAllDataCatalog();
        return ResponseData.makeResponseData(catalogs);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u4ee5\u5b57\u5178\u76ee\u5f55\u4fe1\u606f\u53ca\u5bf9\u5e94\u7684\u6240\u4ee5\u5b57\u5178\u660e\u7ec6\u4fe1\u606f", notes="\u83b7\u53d6\u6240\u4ee5\u5b57\u5178\u76ee\u5f55\u4fe1\u606f\u53ca\u5bf9\u5e94\u7684\u6240\u4ee5\u5b57\u5178\u660e\u7ec6\u4fe1\u606f")
    @RequestMapping(value={"/wholeDictionary"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getWholeDictionary(HttpServletResponse response) {
        List<DataCatalog> catalogs = this.dataDictionaryManager.listAllDataCatalog();
        List<DataDictionary> dictionarys = this.dataDictionaryManager.getWholeDictionary();
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("catalog", catalogs);
        resData.addResponseData("dictionary", dictionarys);
        return resData;
    }

    @ApiOperation(value="\u5c06\u5b57\u5178\u660e\u7ec6\u4fe1\u606f\u5bfc\u5165\u5230Properties\u6587\u4ef6", notes="\u5c06\u5b57\u5178\u660e\u7ec6\u4fe1\u606f\u5bfc\u5165\u5230Properties\u6587\u4ef6")
    @GetMapping(value={"/dictionaryprop"})
    public ResponseEntity<byte[]> downloadProperties() throws IOException {
        List<DataDictionary> dictionarys = this.dataDictionaryManager.getWholeDictionary();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write("#dictionaryprop_zh_CN.Properties\r\n".getBytes());
        for (DataDictionary dict : dictionarys) {
            out.write((dict.getCatalogCode() + "." + dict.getDataCode() + "=" + dict.getDataValue() + "\r\n").getBytes());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDispositionFormData("attachment", "dictionaryprop_zh_CN.Properties");
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        return new ResponseEntity((Object)out.toByteArray(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

