/*
 * Decompiled with CFR 0.152.
 */
package com.centit.bdbclient;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.bdbclient.AbstractStaticPlatformEnvironment;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.staticsystem.po.DataCatalog;
import com.centit.framework.staticsystem.po.OptDataScope;
import com.centit.framework.staticsystem.po.OptInfo;
import com.centit.framework.staticsystem.po.OptMethod;
import com.centit.framework.staticsystem.po.OsInfo;
import com.centit.framework.staticsystem.po.RoleInfo;
import com.centit.framework.staticsystem.po.RolePower;
import com.centit.framework.staticsystem.po.UnitInfo;
import com.centit.framework.staticsystem.po.UserInfo;
import com.centit.framework.staticsystem.po.UserRole;
import com.centit.framework.staticsystem.po.UserUnit;
import com.centit.framework.system.dao.DataCatalogDao;
import com.centit.framework.system.dao.DataDictionaryDao;
import com.centit.framework.system.po.DataDictionary;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;

public class JsonPlatformEnvironment
extends AbstractStaticPlatformEnvironment {
    private static Log logger = LogFactory.getLog(com.centit.framework.staticsystem.service.impl.JsonPlatformEnvironment.class);
    protected String appHome;
    @Autowired
    private DataDictionaryDao dataDictionaryDao;
    @Autowired
    private DataCatalogDao dataCatalogDao;

    public void setAppHome(String appHome) {
        this.appHome = appHome;
    }

    private void loadConfigFromJSONString(String jsonStr) {
        JSONObject json = JSON.parseObject((String)jsonStr);
        JSONArray tempJa = json.getJSONArray("userInfos");
        if (tempJa != null) {
            List userinfos = tempJa.toJavaList(UserInfo.class);
            CodeRepositoryCache.userInfoRepo.setFreshData((Object)userinfos);
        }
        if ((tempJa = json.getJSONArray("optInfos")) != null) {
            List optinfos = tempJa.toJavaList(OptInfo.class);
            CodeRepositoryCache.optInfoRepo.setFreshData((Object)optinfos);
        }
        if ((tempJa = json.getJSONArray("optMethods")) != null) {
            List optmethods = tempJa.toJavaList(OptMethod.class);
            CodeRepositoryCache.optMethodRepo.setFreshData((Object)optmethods);
        }
        if ((tempJa = json.getJSONArray("optDataScopes")) != null) {
            this.optDataScopes = tempJa.toJavaList(OptDataScope.class);
        }
        if ((tempJa = json.getJSONArray("roleInfos")) != null) {
            List roleinfos = tempJa.toJavaList(RoleInfo.class);
            CodeRepositoryCache.roleInfoRepo.setFreshData((Object)roleinfos);
        }
        if ((tempJa = json.getJSONArray("rolePowers")) != null) {
            List rolepowers = tempJa.toJavaList(RolePower.class);
            CodeRepositoryCache.rolePowerRepo.setFreshData((Object)rolepowers);
        }
        if ((tempJa = json.getJSONArray("userRoles")) != null) {
            List userroles = tempJa.toJavaList(UserRole.class);
            this.allUserRoleRepo.setFreshData((Object)userroles);
        }
        if ((tempJa = json.getJSONArray("unitInfos")) != null) {
            List unitinfos = tempJa.toJavaList(UnitInfo.class);
            CodeRepositoryCache.unitInfoRepo.setFreshData((Object)unitinfos);
        }
        if ((tempJa = json.getJSONArray("userUnits")) != null) {
            List userunits = tempJa.toJavaList(UserUnit.class);
            CodeRepositoryCache.userUnitRepo.setFreshData((Object)userunits);
        }
        if ((tempJa = json.getJSONArray("osInfos")) != null) {
            List osInfos = tempJa.toJavaList(OsInfo.class);
            CodeRepositoryCache.osInfoCache.setFreshData((Object)osInfos);
        }
        if ((tempJa = json.getJSONArray("dataCatalogs")) != null) {
            List datacatalogs = tempJa.toJavaList(DataCatalog.class);
            CodeRepositoryCache.catalogRepo.setFreshData((Object)datacatalogs);
        }
        if ((tempJa = json.getJSONArray("dataDictionaries")) != null) {
            List datadictionaies = tempJa.toJavaList(com.centit.framework.staticsystem.po.DataDictionary.class);
            this.allDictionaryRepo.setFreshData((Object)datadictionaies);
        }
    }

    public String loadJsonStringFormConfigFile(String fileName) throws IOException {
        String jsonFile = this.appHome + "/config" + fileName;
        if (FileSystemOpt.existFile((String)jsonFile)) {
            return FileIOOpt.readStringFromFile((String)jsonFile, (String)"UTF-8");
        }
        return FileIOOpt.readStringFromInputStream((InputStream)new ClassPathResource(fileName).getInputStream(), (String)"UTF-8");
    }

    @Override
    protected synchronized void reloadPlatformData() {
        try {
            String jsonstr = this.loadJsonStringFormConfigFile("/static_system_config.json");
            this.loadConfigFromJSONString(jsonstr);
        }
        catch (IOException e) {
            logger.error((Object)e.getLocalizedMessage());
        }
        this.organizePlatformData();
        try {
            String jsonStr = this.loadJsonStringFormConfigFile("/static_system_user_pwd.json");
            JSONObject json = JSON.parseObject((String)jsonStr);
            for (IUserInfo u : (List)CodeRepositoryCache.userInfoRepo.getCachedTarget()) {
                String spwd = json.getString(u.getUserCode());
                if (!StringUtils.isNotBlank((CharSequence)spwd)) continue;
                ((UserInfo)u).setUserPin(spwd);
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void changeUserPassword(String userCode, String userPassword) {
        UserInfo ui = (UserInfo)((Map)CodeRepositoryCache.codeToUserMap.getCachedTarget()).get(userCode);
        if (ui == null) {
            return;
        }
        JSONObject json = null;
        String jsonFile = "/static_system_user_pwd.json";
        try {
            String jsonstr = this.loadJsonStringFormConfigFile(jsonFile);
            json = JSON.parseObject((String)jsonstr);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (json == null) {
            json = new JSONObject();
        }
        try {
            ui.setUserPin(this.passwordEncoder.encodePassword(userPassword, (Object)userCode));
            json.put(userCode, (Object)ui.getUserPin());
            FileIOOpt.writeStringToFile((String)json.toJSONString(), (String)(this.appHome + "/config" + jsonFile));
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public List<com.centit.framework.system.po.DataCatalog> listAllDataCatalogs() {
        return this.dataCatalogDao.listObjects();
    }

    public List<DataDictionary> listDataDictionaries(String catalogCode) {
        return this.dataDictionaryDao.listDataDictionary(catalogCode);
    }
}

