/*
 * Decompiled with CFR 0.152.
 */
package com.centit.bdbclient;

import com.centit.bdbclient.IPClientPlatformEnvironment;
import com.centit.bdbclient.JsonPlatformEnvironment;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.security.model.CentitPasswordEncoder;
import com.centit.framework.security.model.CentitUserDetailsService;
import com.centit.framework.staticsystem.service.impl.UserDetailsServiceImpl;
import com.centit.support.algorithm.BooleanBaseOpt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;

@PropertySource(value={"classpath:system.properties"})
public class AppSystemBeanConfig
implements EnvironmentAware {
    private Environment env;
    @Autowired
    private CentitPasswordEncoder passwordEncoder;

    @Autowired
    public void setEnvironment(Environment environment) {
        if (environment != null) {
            this.env = environment;
        }
    }

    @Bean
    public AutowiredAnnotationBeanPostProcessor autowiredAnnotationBeanPostProcessor() {
        return new AutowiredAnnotationBeanPostProcessor();
    }

    @Bean
    @Lazy(value=false)
    public PlatformEnvironment platformEnvironment() {
        Boolean ipEnable = (Boolean)this.env.getProperty("centit.ip.enable", Boolean.class);
        if (null != ipEnable && ipEnable.booleanValue()) {
            IPClientPlatformEnvironment ipPlatformEnvironment = new IPClientPlatformEnvironment();
            ipPlatformEnvironment.setTopOptId(this.env.getProperty("centit.ip.topoptid"));
            ipPlatformEnvironment.createPlatAppSession(this.env.getProperty("centit.ip.home"), BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("centit.ip.auth.enable"), (Boolean)false), this.env.getProperty("centit.ip.auth.usercode"), this.env.getProperty("centit.ip.auth.password"));
            return ipPlatformEnvironment;
        }
        JsonPlatformEnvironment jsonPlatformEnvironment = new JsonPlatformEnvironment();
        jsonPlatformEnvironment.setAppHome(this.env.getProperty("app.home"));
        jsonPlatformEnvironment.setPasswordEncoder(this.passwordEncoder);
        return jsonPlatformEnvironment;
    }

    @Bean
    public CentitUserDetailsService centitUserDetailsService(@Autowired PlatformEnvironment platformEnvironment) {
        UserDetailsServiceImpl userDetailsService = new UserDetailsServiceImpl();
        userDetailsService.setPlatformEnvironment(platformEnvironment);
        return userDetailsService;
    }

    @Bean
    public HttpSessionCsrfTokenRepository csrfTokenRepository() {
        return new HttpSessionCsrfTokenRepository();
    }
}

