/*
 * Decompiled with CFR 0.152.
 */
package com.centit.bdbclient;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.IDataCatalog;
import com.centit.framework.model.basedata.IOptDataScope;
import com.centit.framework.model.basedata.IOptInfo;
import com.centit.framework.model.basedata.IOptMethod;
import com.centit.framework.model.basedata.IOsInfo;
import com.centit.framework.model.basedata.IRoleInfo;
import com.centit.framework.model.basedata.IRolePower;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.framework.model.basedata.IUnitRole;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.model.basedata.IUserSetting;
import com.centit.framework.model.basedata.IUserUnit;
import com.centit.framework.security.SecurityContextUtils;
import com.centit.framework.security.model.CentitPasswordEncoder;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.security.model.JsonCentitUserDetails;
import com.centit.framework.staticsystem.po.DataCatalog;
import com.centit.framework.staticsystem.po.DataDictionary;
import com.centit.framework.staticsystem.po.OptDataScope;
import com.centit.framework.staticsystem.po.OptInfo;
import com.centit.framework.staticsystem.po.OptMethod;
import com.centit.framework.staticsystem.po.RoleInfo;
import com.centit.framework.staticsystem.po.RolePower;
import com.centit.framework.staticsystem.po.UserInfo;
import com.centit.framework.staticsystem.po.UserRole;
import com.centit.framework.staticsystem.po.UserSetting;
import com.centit.framework.staticsystem.po.UserUnit;
import com.centit.support.common.CachedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractStaticPlatformEnvironment
implements PlatformEnvironment {
    protected List<OptDataScope> optDataScopes;
    public CachedObject<List<DataDictionary>> allDictionaryRepo = new CachedObject(this::listAllDataDictionary, 2592000L);
    public CachedObject<List<UserRole>> allUserRoleRepo = new CachedObject(this::listAllUserRole, 2592000L);
    public CachedObject<List<JsonCentitUserDetails>> allUserDetailsRepo = new CachedObject(() -> {
        this.reloadPlatformData();
        return null;
    }, 2592000L);
    protected CentitPasswordEncoder passwordEncoder;

    public void setPasswordEncoder(CentitPasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    protected abstract void reloadPlatformData();

    protected void organizePlatformData() {
        for (IDataCatalog dd : (List)CodeRepositoryCache.catalogRepo.getCachedTarget()) {
            ((DataCatalog)dd).setDataDictionaries(this.listDataDictionaries(dd.getCatalogCode()));
        }
        for (IRoleInfo ri : (List)CodeRepositoryCache.roleInfoRepo.getCachedTarget()) {
            for (IRolePower rp : (List)CodeRepositoryCache.rolePowerRepo.getCachedTarget()) {
                if (!StringUtils.equals((CharSequence)rp.getRoleCode(), (CharSequence)ri.getRoleCode())) continue;
                ((RoleInfo)ri).addRolePowers((RolePower)rp);
            }
        }
        List userinfos = (List)CodeRepositoryCache.userInfoRepo.getCachedTarget();
        ArrayList<JsonCentitUserDetails> userDetails = new ArrayList<JsonCentitUserDetails>(userinfos.size());
        List uus = (List)CodeRepositoryCache.userUnitRepo.getCachedTarget();
        for (IUserInfo ui : userinfos) {
            ArrayList<RoleInfo> roles = new ArrayList<RoleInfo>();
            HashMap<String, String> userOptList = new HashMap<String, String>();
            for (UserRole ur : (List)this.allUserRoleRepo.getCachedTarget()) {
                IRoleInfo ri;
                if (!StringUtils.equals((CharSequence)ur.getUserCode(), (CharSequence)ui.getUserCode()) || (ri = (IRoleInfo)((Map)CodeRepositoryCache.codeToRoleMap.getCachedTarget()).get(ur.getRoleCode())) == null) continue;
                roles.add((RoleInfo)ri);
                for (IRolePower rp : ri.getRolePowers()) {
                    IOptMethod om = (IOptMethod)((Map)CodeRepositoryCache.codeToMethodMap.getCachedTarget()).get(rp.getOptCode());
                    if (om == null || !StringUtils.isNotBlank((CharSequence)om.getOptMethod())) continue;
                    userOptList.put(om.getOptId() + "-" + om.getOptMethod(), om.getOptCode());
                }
            }
            JsonCentitUserDetails ud = new JsonCentitUserDetails();
            ud.setUserInfo((JSONObject)JSON.toJSON((Object)ui));
            ud.getUserInfo().put("userPin", (Object)ui.getUserPin());
            ud.setAuthoritiesByRoles((JSONArray)JSON.toJSON(roles));
            ud.setUserOptList(userOptList);
            ArrayList<UserUnit> uulist = new ArrayList<UserUnit>(10);
            for (IUserUnit uu : uus) {
                if (!StringUtils.equals((CharSequence)uu.getUserCode(), (CharSequence)ui.getUserCode())) continue;
                uulist.add((UserUnit)uu);
            }
            ud.setUserUnits((JSONArray)JSON.toJSON(uulist));
            userDetails.add(ud);
        }
        this.allUserDetailsRepo.setFreshData(userDetails);
    }

    public boolean checkUserPassword(String userCode, String userPassword) {
        UserInfo ui = (UserInfo)((Map)CodeRepositoryCache.codeToUserMap.getCachedTarget()).get(userCode);
        if (ui == null) {
            return false;
        }
        return this.passwordEncoder.isPasswordValid(ui.getUserPin(), userPassword, (Object)userCode);
    }

    private static List<OptInfo> getMenuFuncs(List<OptInfo> preOpts, List<OptInfo> ls) {
        int i;
        boolean[] isNeeds = new boolean[preOpts.size()];
        for (int i2 = 0; i2 < preOpts.size(); ++i2) {
            isNeeds[i2] = false;
        }
        ArrayList<OptInfo> opts = new ArrayList<OptInfo>();
        block1: for (OptInfo opm : ls) {
            opts.add(opm);
            for (i = 0; i < preOpts.size(); ++i) {
                if (opm.getPreOptId() == null || !opm.getPreOptId().equals(preOpts.get(i).getOptId())) continue;
                isNeeds[i] = true;
                continue block1;
            }
        }
        ArrayList<OptInfo> needAdd = new ArrayList<OptInfo>();
        for (int i3 = 0; i3 < preOpts.size(); ++i3) {
            if (!isNeeds[i3]) continue;
            needAdd.add(preOpts.get(i3));
        }
        boolean[] isNeeds2 = new boolean[preOpts.size()];
        block4: while (true) {
            int i4;
            int nestedMenu = 0;
            for (i4 = 0; i4 < preOpts.size(); ++i4) {
                isNeeds2[i4] = false;
            }
            block6: for (i4 = 0; i4 < needAdd.size(); ++i4) {
                for (int j = 0; j < preOpts.size(); ++j) {
                    if (isNeeds[j] || ((OptInfo)needAdd.get(i4)).getPreOptId() == null || !((OptInfo)needAdd.get(i4)).getPreOptId().equals(preOpts.get(j).getOptId())) continue;
                    isNeeds[j] = true;
                    isNeeds2[j] = true;
                    ++nestedMenu;
                    continue block6;
                }
            }
            if (nestedMenu == 0) break;
            needAdd.clear();
            i4 = 0;
            while (true) {
                if (i4 >= preOpts.size()) continue block4;
                if (isNeeds2[i4]) {
                    needAdd.add(preOpts.get(i4));
                }
                ++i4;
            }
            break;
        }
        for (i = 0; i < preOpts.size(); ++i) {
            if (!isNeeds[i]) continue;
            opts.add(preOpts.get(i));
        }
        return opts;
    }

    private List<OptInfo> formatMenuTree(List<OptInfo> optInfos) {
        Iterator<OptInfo> menus = optInfos.iterator();
        ArrayList<OptInfo> parentMenu = new ArrayList<OptInfo>();
        while (menus.hasNext()) {
            OptInfo optInfo = menus.next();
            boolean getParent = false;
            for (OptInfo opt : optInfos) {
                if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                opt.addChild(optInfo);
                getParent = true;
                break;
            }
            if (getParent) continue;
            parentMenu.add(optInfo);
        }
        return parentMenu;
    }

    private List<OptInfo> formatMenuTree(List<OptInfo> optInfos, String superOptId) {
        if (StringUtils.isEmpty((CharSequence)superOptId)) {
            return Collections.emptyList();
        }
        Iterator<OptInfo> menus = optInfos.iterator();
        OptInfo parentOpt = null;
        while (menus.hasNext()) {
            OptInfo optInfo = menus.next();
            if (StringUtils.equals((CharSequence)superOptId, (CharSequence)optInfo.getOptId())) {
                parentOpt = optInfo;
            }
            for (OptInfo opt : optInfos) {
                if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                opt.addChild(optInfo);
            }
        }
        if (parentOpt != null) {
            return parentOpt.getChildren();
        }
        return Collections.emptyList();
    }

    private List<OptInfo> listUserOptInfos(String userCode) {
        ArrayList<OptInfo> userOptinfos = new ArrayList<OptInfo>();
        HashSet<String> optIds = new HashSet<String>(20);
        List<UserRole> userRoles = this.listUserRoles(userCode);
        userRoles.add(new UserRole(userCode, SecurityContextUtils.PUBLIC_ROLE_CODE));
        for (UserRole ur : userRoles) {
            RoleInfo ri = (RoleInfo)((Map)CodeRepositoryCache.codeToRoleMap.getCachedTarget()).get(ur.getRoleCode());
            if (ri == null) continue;
            for (RolePower rp : ri.getRolePowers()) {
                OptMethod om = (OptMethod)((Map)CodeRepositoryCache.codeToMethodMap.getCachedTarget()).get(rp.getOptCode());
                if (om == null) continue;
                optIds.add(om.getOptId());
            }
        }
        for (String optId : optIds) {
            OptInfo oi = (OptInfo)((Map)CodeRepositoryCache.codeToOptMap.getCachedTarget()).get(optId);
            if (!"Y".equals(oi.getIsInToolbar())) continue;
            OptInfo soi = new OptInfo();
            soi.copy(oi);
            soi.setOptId(oi.getOptId());
            userOptinfos.add(soi);
        }
        return userOptinfos;
    }

    protected List<OptInfo> getDirectOptInfo() {
        ArrayList<OptInfo> dirOptInfos = new ArrayList<OptInfo>();
        for (IOptInfo oi : (List)CodeRepositoryCache.optInfoRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)oi.getOptUrl(), (CharSequence)"...")) continue;
            OptInfo soi = new OptInfo();
            soi.copy((OptInfo)oi);
            soi.setOptId(oi.getOptId());
            dirOptInfos.add(soi);
        }
        return dirOptInfos;
    }

    public List<OptInfo> listUserMenuOptInfos(String userCode, boolean asAdmin) {
        List<OptInfo> userOptinfos = this.listUserOptInfos(userCode);
        List<OptInfo> preOpts = this.getDirectOptInfo();
        List<OptInfo> allUserOpt = AbstractStaticPlatformEnvironment.getMenuFuncs(preOpts, userOptinfos);
        Collections.sort(allUserOpt, (o1, o2) -> o2.getOrderInd() == null && o1.getOrderInd() == null ? 0 : (o2.getOrderInd() == null ? 1 : (o1.getOrderInd() == null ? -1 : (o1.getOrderInd() > o2.getOrderInd() ? 1 : (o1.getOrderInd() < o2.getOrderInd() ? -1 : 0)))));
        return this.formatMenuTree(allUserOpt);
    }

    public List<OptInfo> listUserMenuOptInfosUnderSuperOptId(String userCode, String superOptId, boolean asAdmin) {
        List<OptInfo> userOptinfos = this.listUserOptInfos(userCode);
        List<OptInfo> preOpts = this.getDirectOptInfo();
        List<OptInfo> allUserOpt = AbstractStaticPlatformEnvironment.getMenuFuncs(preOpts, userOptinfos);
        Collections.sort(allUserOpt, (o1, o2) -> o2.getOrderInd() == null && o1.getOrderInd() == null ? 0 : (o2.getOrderInd() == null ? 1 : (o1.getOrderInd() == null ? -1 : (o1.getOrderInd() > o2.getOrderInd() ? 1 : (o1.getOrderInd() < o2.getOrderInd() ? -1 : 0)))));
        return this.formatMenuTree(allUserOpt, superOptId);
    }

    public List<UserUnit> listUserUnits(String userCode) {
        ArrayList<UserUnit> userUnits = new ArrayList<UserUnit>(10);
        for (IUserUnit uu : (List)CodeRepositoryCache.userUnitRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)userCode, (CharSequence)uu.getUserCode())) continue;
            userUnits.add((UserUnit)uu);
        }
        return userUnits;
    }

    public List<UserUnit> listUnitUsers(String unitCode) {
        ArrayList<UserUnit> unitUsers = new ArrayList<UserUnit>(10);
        for (IUserUnit uu : (List)CodeRepositoryCache.userUnitRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)unitCode, (CharSequence)uu.getUnitCode())) continue;
            unitUsers.add((UserUnit)uu);
        }
        return unitUsers;
    }

    public List<UserRole> listUserRoles(String userCode) {
        ArrayList<UserRole> roles = new ArrayList<UserRole>();
        for (UserRole ur : (List)this.allUserRoleRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)ur.getUserCode(), (CharSequence)userCode)) continue;
            roles.add(ur);
        }
        return roles;
    }

    public List<? extends IOsInfo> listOsInfos() {
        this.reloadPlatformData();
        return (List)CodeRepositoryCache.osInfoCache.getCachedTarget();
    }

    public List<UserRole> listRoleUsers(String roleCode) {
        ArrayList<UserRole> users = new ArrayList<UserRole>();
        for (UserRole ur : (List)this.allUserRoleRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)ur.getRoleCode(), (CharSequence)roleCode)) continue;
            users.add(ur);
        }
        return users;
    }

    public CentitUserDetails loadUserDetailsByLoginName(String loginName) {
        for (JsonCentitUserDetails ud : (List)this.allUserDetailsRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)ud.getUserInfo().getString("loginName"), (CharSequence)loginName)) continue;
            return ud;
        }
        return null;
    }

    public CentitUserDetails loadUserDetailsByUserCode(String userCode) {
        for (JsonCentitUserDetails ud : (List)this.allUserDetailsRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)ud.getUserInfo().getString("userCode"), (CharSequence)userCode)) continue;
            return ud;
        }
        return null;
    }

    public CentitUserDetails loadUserDetailsByRegEmail(String regEmail) {
        for (JsonCentitUserDetails ud : (List)this.allUserDetailsRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)ud.getUserInfo().getString("regEmail"), (CharSequence)regEmail)) continue;
            return ud;
        }
        return null;
    }

    public CentitUserDetails loadUserDetailsByRegCellPhone(String regCellPhone) {
        for (JsonCentitUserDetails ud : (List)this.allUserDetailsRepo.getCachedTarget()) {
            if (!StringUtils.equals((CharSequence)ud.getUserInfo().getString("regCellPhone"), (CharSequence)regCellPhone)) continue;
            return ud;
        }
        return null;
    }

    public UserSetting getUserSetting(String userCode, String paramCode) {
        CentitUserDetails ud = this.loadUserDetailsByUserCode(userCode);
        if (ud == null) {
            return null;
        }
        return new UserSetting(ud.getUserCode(), paramCode, ud.getUserSettingValue(paramCode), "\u7528\u6237\u53c2\u6570");
    }

    public List<UserSetting> listUserSettings(String userCode) {
        CentitUserDetails ud = this.loadUserDetailsByUserCode(userCode);
        if (ud == null) {
            return null;
        }
        Map settingMap = ud.getUserSettings();
        if (settingMap == null) {
            return null;
        }
        ArrayList<UserSetting> userSettings = new ArrayList<UserSetting>(settingMap.size() + 1);
        for (Map.Entry ent : ud.getUserSettings().entrySet()) {
            userSettings.add(new UserSetting(ud.getUserCode(), (String)ent.getKey(), (String)ent.getValue(), "\u7528\u6237\u53c2\u6570"));
        }
        return userSettings;
    }

    public void updateUserInfo(IUserInfo userInfo) {
        UserInfo ui = (UserInfo)((Map)CodeRepositoryCache.codeToUserMap.getCachedTarget()).get(userInfo.getUserCode());
        if (ui == null) {
            return;
        }
        ui.copyNotNullProperty(userInfo);
    }

    public void saveUserSetting(IUserSetting userSetting) {
        CentitUserDetails ud = this.loadUserDetailsByUserCode(userSetting.getUserCode());
        if (ud == null) {
            return;
        }
        ud.setUserSettingValue(userSetting.getParamCode(), userSetting.getParamValue());
    }

    public List<? extends IUserInfo> listAllUsers() {
        this.reloadPlatformData();
        return (List)CodeRepositoryCache.userInfoRepo.getCachedTarget();
    }

    public List<? extends IUnitInfo> listAllUnits() {
        this.reloadPlatformData();
        return (List)CodeRepositoryCache.unitInfoRepo.getCachedTarget();
    }

    public List<? extends IUserUnit> listAllUserUnits() {
        this.reloadPlatformData();
        return (List)CodeRepositoryCache.userUnitRepo.getCachedTarget();
    }

    public List<? extends IRoleInfo> listAllRoleInfo() {
        this.reloadPlatformData();
        return (List)CodeRepositoryCache.roleInfoRepo.getCachedTarget();
    }

    public List<? extends IOptInfo> listAllOptInfo() {
        this.reloadPlatformData();
        return (List)CodeRepositoryCache.optInfoRepo.getCachedTarget();
    }

    public List<? extends IRolePower> listAllRolePower() {
        this.reloadPlatformData();
        return (List)CodeRepositoryCache.rolePowerRepo.getCachedTarget();
    }

    protected List<DataDictionary> listAllDataDictionary() {
        this.reloadPlatformData();
        return (List)this.allDictionaryRepo.getCachedTarget();
    }

    protected List<UserRole> listAllUserRole() {
        this.reloadPlatformData();
        return (List)this.allUserRoleRepo.getCachedTarget();
    }

    public List<? extends IOptMethod> listAllOptMethod() {
        this.reloadPlatformData();
        return (List)CodeRepositoryCache.optMethodRepo.getCachedTarget();
    }

    public List<? extends IOptDataScope> listAllOptDataScope() {
        this.reloadPlatformData();
        return this.optDataScopes;
    }

    public List<? extends IUnitRole> listUnitRoles(String unitCode) {
        return null;
    }

    public List<? extends IUnitRole> listRoleUnits(String roleCode) {
        return null;
    }

    public void insertOrUpdateMenu(List<? extends IOptInfo> optInfos, List<? extends IOptMethod> optMethods) {
    }
}

