/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.service.impl;

import com.centit.product.oa.dao.WorkDayDao;
import com.centit.product.oa.po.WorkDay;
import com.centit.product.oa.service.WorkDayManager;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.common.DateTimeSpan;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class WorkDayManagerImpl
implements WorkDayManager {
    private static Logger logger = LoggerFactory.getLogger(WorkDayManagerImpl.class);
    @Resource
    private WorkDayDao workDayDao;

    @Override
    public void mergeWorkDay(WorkDay workDay) {
        workDay.setWorkDay(WorkDay.toWorkDayId(workDay.getWorkDay()));
        if (WorkDay.WORK_DAY_TYPE_IGNORE.equals(workDay.getDayType())) {
            this.deleteWorkDay(workDay.getTopUnit(), workDay.getWorkDate());
        } else {
            WorkDay dbWorkDay = this.workDayDao.getWorkDay(workDay.getTopUnit(), workDay.getWorkDate());
            if (dbWorkDay != null && StringUtils.equals((CharSequence)workDay.getTopUnit(), (CharSequence)dbWorkDay.getTopUnit())) {
                dbWorkDay.copyNotNullProperty(workDay);
                this.workDayDao.updateObject(workDay);
            } else {
                this.workDayDao.saveNewObject(workDay);
            }
        }
    }

    @Override
    public void deleteWorkDay(String topUnit, Date currDate) {
        this.workDayDao.deleteObject(new WorkDay(topUnit, currDate));
    }

    @Override
    public WorkDay getWorkDay(String topUnit, Date currDate) {
        return this.workDayDao.getWorkDay(topUnit, currDate);
    }

    @Override
    public List<WorkDay> listWorkDays(String topUnit, Date startDate, Date endDate) {
        return this.workDayDao.listWorkDays(topUnit, startDate, endDate);
    }

    @Override
    public boolean isWorkDay(String topUnit, Date currDate) {
        WorkDay day = this.workDayDao.getWorkDay(topUnit, currDate);
        if (day != null) {
            if (WorkDay.WORK_DAY_TYPE_SHIFT.equals(day.getDayType())) {
                return true;
            }
            if (WorkDay.WORK_DAY_TYPE_HOLIDAY.equals(day.getDayType())) {
                return false;
            }
        }
        return DatetimeOpt.getDayOfWeek((Date)currDate) > 0 && DatetimeOpt.getDayOfWeek((Date)currDate) < 6;
    }

    @Override
    public int calcHolidays(String topUnit, Date startDate, Date endDate) {
        int holidays = DatetimeOpt.calcWeekendDays((Date)startDate, (Date)endDate);
        List<WorkDay> list = this.workDayDao.listWorkDays(topUnit, startDate, endDate);
        if (null != list) {
            for (WorkDay workDay : list) {
                Date workDate = WorkDay.toWorkDayDate(workDay.getWorkDay());
                if (WorkDay.WORK_DAY_TYPE_HOLIDAY.equals(workDay.getDayType()) && DatetimeOpt.getDayOfWeek((Date)workDate) > 0 && DatetimeOpt.getDayOfWeek((Date)workDate) < 6) {
                    ++holidays;
                    continue;
                }
                if (!WorkDay.WORK_DAY_TYPE_SHIFT.equals(workDay.getDayType()) || DatetimeOpt.getDayOfWeek((Date)workDate) != 0 && DatetimeOpt.getDayOfWeek((Date)workDate) != 6) continue;
                --holidays;
            }
        }
        return holidays;
    }

    @Override
    public int calcWorkDays(String topUnit, Date startDate, Date endDate) {
        int spanDays = DatetimeOpt.calcSpanDays((Date)startDate, (Date)endDate);
        int holidays = this.calcHolidays(topUnit, startDate, endDate);
        return spanDays - holidays;
    }

    @Override
    public Date calcWorkingDeadline(String topUnit, Date startDate, DateTimeSpan timeLimit) {
        Date beginDate = startDate;
        Date deadLine = new Date(startDate.getTime() + timeLimit.longValue());
        if (beginDate.before(deadLine)) {
            int n;
            while (beginDate.before(deadLine) && (n = this.calcHolidays(topUnit, beginDate, deadLine)) != 0) {
                beginDate = DatetimeOpt.addDays((Date)deadLine, (int)1);
                deadLine = DatetimeOpt.addDays((Date)deadLine, (int)n);
            }
        } else {
            int n;
            while (beginDate.after(deadLine) && (n = this.calcHolidays(topUnit, deadLine, beginDate)) != 0) {
                beginDate = DatetimeOpt.addDays((Date)deadLine, (int)-1);
                deadLine = DatetimeOpt.addDays((Date)deadLine, (int)(-n));
            }
        }
        return deadLine;
    }

    @Override
    public List<WorkDay> rangeHolidays(String topUnit, Date startDate, Date endDate) {
        List<WorkDay> list = this.workDayDao.listWorkDays(topUnit, startDate, endDate);
        int i = 0;
        int l = list == null ? 0 : list.size();
        ArrayList<WorkDay> workDays = new ArrayList<WorkDay>(16);
        Date s = startDate;
        while (DatetimeOpt.compareTwoDate((Date)s, (Date)endDate) < 1) {
            int day;
            int c;
            boolean specil = false;
            if (i < l && (c = DatetimeOpt.compareTwoDate((Date)s, (Date)list.get(i).getWorkDate())) == 0) {
                if (WorkDay.WORK_DAY_TYPE_HOLIDAY.equals(list.get(i).getDayType())) {
                    workDays.add((WorkDay)workDays.get(i));
                }
                specil = true;
                ++i;
            }
            if (!(specil || (day = DatetimeOpt.getDayOfWeek((Date)s)) != 0 && day != 6)) {
                WorkDay workDay = new WorkDay();
                workDay.setWorkDay(WorkDay.toWorkDayId(s));
                workDay.setDayType(WorkDay.WORK_DAY_TYPE_WEEKEND);
            }
            s = DatetimeOpt.addDays((Date)s, (int)1);
        }
        return workDays;
    }

    @Override
    public List<WorkDay> rangeWorkDays(String topUnit, Date startDate, Date endDate) {
        List<WorkDay> list = this.workDayDao.listWorkDays(topUnit, startDate, endDate);
        int i = 0;
        int l = list == null ? 0 : list.size();
        ArrayList<WorkDay> workDays = new ArrayList<WorkDay>(32);
        Date s = startDate;
        while (DatetimeOpt.compareTwoDate((Date)s, (Date)endDate) < 1) {
            int day;
            int c;
            boolean specil = false;
            if (i < l && (c = DatetimeOpt.compareTwoDate((Date)s, (Date)list.get(i).getWorkDate())) == 0) {
                if (WorkDay.WORK_DAY_TYPE_SHIFT.equals(list.get(i).getDayType())) {
                    workDays.add((WorkDay)workDays.get(i));
                }
                specil = true;
                ++i;
            }
            if (!specil && (day = DatetimeOpt.getDayOfWeek((Date)s)) != 0 && day != 6) {
                WorkDay workDay = new WorkDay();
                workDay.setWorkDay(WorkDay.toWorkDayId(s));
                workDay.setDayType(WorkDay.WORK_DAY_TYPE_WORKDAY);
            }
            s = DatetimeOpt.addDays((Date)s, (int)1);
        }
        return workDays;
    }
}

